.\" Copyright 1993-95 by Carl Harris, Jr. Copyright 1996 by Eric S. Raymond
.\" All rights reserved.
.\" For license terms, see the file COPYING in this directory.
.TH popclient LOCAL
.SH NAME
popclient \- retrieve mail from a mailserver using Post Office Protocol.
.SH SYNOPSIS
.B popclient
[\fI options \fR] \fI [server-host...]\fR
.SH DESCRIPTION
.I popclient
is a Post Office Protocol compliant mail retrieval client which supports 
both POP2 (as specified in RFC 937) and POP3 (RFC 1725).
.PP
Typically,
.I popclient
will be used to download mail in batch from the remote mailserver specified by
.I host
to a mail folder on the local disk.  The retrieved mail can then be 
manipulated using a local mail reader, such as
.I mail
or 
.I elm.
.PP
To facilitate the use of
.I popclient
in scripts, pipelines, etc, it returns an appropriate exit code upon 
termination -- see EXIT CODES below.
.PP
The behavior of
.I popclient
is controlled by comand-line options and a control file,
.I ~/.poprc
the syntax of which we describe below.  Command-line options override
.I ~/.poprc
declarations.
.SH OPTIONS
Each server name that you specify (following the options on the
command line) will be queried.  If you don't specify any servers
on the command line, each server in your 
.I ~/.poprc
file will be operated on.
.TP
.B \-2
Use Post Office Protocol version 2 (POP2).  See also the 
.B \--protocol
option, below.
.TP
.B \-3
Use Post Office Protocol version 3 (POP3).  See also the
.B \--protocol
option, below.
.TP
.B \-a, --all
POP3 only.  Retrieve both old (previously retrieved) and new messages from 
the mailserver.
.TP
.B \-c, --stdout
Causes retrieved messages to be written to stdout instead of a mail folder.
See OUTPUT OPTIONS below for a complete description.  You may not specify
both the
.B \-c
and 
.B \-o
options on the same command line.
.TP
.B \-F, --flush
POP3 only.  Delete old (previously retrieved) messages from the mailserver
before retrieving new messages.
.TP
.B \-f pathname, --poprc pathname
Specify an alternate name for the .poprc file.
.TP
.B \-i pathname, --idfile pathname
Specify an alternate name for the .popids file.
.TP
.B \-k, --keep
Keep retrieved messages in folder on remote mailserver.  Normally, messages 
are deleted from the folder on the mailserver after they have been retrieved
(unless 
.I popclient
was compiled with the KEEP_IS_DEFAULT option).  Specifying the 
.B keep 
option causes retrieved messages to remain in your folder on the mailserver.
.TP
.B \-K, --kill
Delete retrieved messages from the remote mailserver.  If 
.I popclient
is compiled with the KEEP_IS_DEFAULT option, the
.B kill
option forces retrieved mail to be deleted.
.TP
.B \-l lines, --limit lines
POP3 only.  Retrieve no more than the specified number of lines of each
message body (plus message headers).  The
.B keep
option is implied by the
.B limit
option -- i.e. messages downloaded with the 
.B limit
option remain on the remote mailserver.
.TP
.B \-m mda, --mda mda
Specify a mail delivery agent to use.  This can be used to pass
fetched mail to programs like procmail.  If the MDA string contains
%s, that escape will be expanded into your username on the client
machine.  Some possible MDAs are "/usr/formail", "/usr/bin/deliver %s",
"/usr/lib/sendmail -oem %s".
.TP
.B \--protocol proto
Specify the protocol to used when communicating with the remote 
mailserver.  
.I proto 
may be one of the following:
.RS
.IP POP2 
Post Office Protocol 2
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with MD5 authentication.
.IP RPOP
Use POP3 with trusted-host-based authentication (like rlogin/rsh). 
.I popclient
must be installed as a setuid root program to use RPOP.
.B \--proto.
.RE
.TP
.B \-o folder, --local folder
Causes retrieved messages to be appended to file named by the folder 
argument.  When neither 
.B \-o
nor
.B \-c
is specified, retrieved messages are appended to the system default mail 
folder. See OUTPUT OPTIONS below for a complete description.
.TP
.B \-r folder, --remote folder
Causes an alternate mail folder on the mailserver to be retrieved.  The
syntax of the folder name is server dependent, as is the default behavior
when no folder is specified.  Fortunately, most POP servers have a reasonable
default behavior, so use of this option should be limited to fairly specialized
applications.  POP3 does not provide a folder specification in the protocol.
If the
.B remote
option is used in conjunction with the POP3 protocol, the remote folder 
specification is ignored.
.TP
.B \-s, --silent
Silent mode.  Suppresses all progress/status messages that are normally
echoed to stderr during a POP connection.  If both the 
.B silent
and
.B verbose
options are specified, the 
.B verbose
option takes precedence.
.TP
.B \-u name, --username name
Specifies the user idenfication to be used when logging-in to the mailserver.
The appropriate user identification is both server and user dependent.  
The default is your login name on the machine that is running 
.I popclient.
See USER AUTHENTICATION below for a complete description.
.TP
.B \-v, --verbose
Verbose mode.  All control messages passed between 
.I popclient
and the mailserver are echoed to stderr.  Specifying
.B verbose
causes normal progress/status messages which would be redundant or meaningless
to be modified or omitted.
.TP
.B \-N, --norewrite
Normally,
.I popclient
edits RFC-822 address headers (To, From, Cc, Bcc, and Reply-To) in
fetched mail so that any mail IDs local to the host are expanded to
full addresses (@ and the POP host name are appended).  This enables 
replies on the client to get addressed correctly (otherwise your
mailer might think they should be addressed to local users on the
client machine).  This option disables the rewrite.
.TP
.B \-V, --version
Displays the version information for your copy of 
.I popclient.
No POP connection is made.
Instead, for each server specified, all option information
that would be computed if
.I popclient.
were connecting to that server is displayed.
.TP
.PP
.SH PROTOCOL SELECTION
The selection of the correct Post Office Protocol (POP2 or POP3) depends upon
the configuration of the mailserver from which you retrieve your mail.  The
system adminstrator who installed 
.I popclient
on your system should have chosen an appropriate default protocol for your 
mailserver.  If you get the message 'Connection refused' when using the 
default protocol, try specifying
.B \-2
or
.B \-3
to select a different protocol.  If the 'Connection refused' message persists 
regardless of the protocol selected, it is likely that your mailserver is not 
running a POP compliant mail service.
.PP
.SH USER AUTHENTICATION
User authentication in 
.I popclient
is very much like the authentication mechanism of 
.I ftp(1).
The correct user-id and password depend upon the underlying security
system at the mailserver.  
.PP
If the mailserver is a Unix machine on which you have an ordinary user 
account, your regular login name and password are used with 
.I popclient.
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the 
.B \-u
option \-\- 
the default behavior will use your login name on the client machine as the 
user-id on the server machine.  If you use a different login name
on the server machine, specify that login name with the
.B \-u
option.  e.g. if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start 
.I popclient 
as follows:
.IP
popclient -u jsmith mailgrunt
.PP
The default behavior of 
.I popclient
is to prompt you for your mailserver password before the POP connection is
established.  This is the safest way to use 
.I popclient
and ensures that your password will not be compromised.  You may also specify
your password in your
.I ~/.poprc
file.  This is convenient when using 
.I popclient
with automated scripts.
.PP
On mailservers that do not provide ordinary user accounts, your user-id and 
password are usually assigned by the server administrator when you apply for 
a mailbox on the server.  Contact your server administrator if you don't know 
the correct user-id and password for your mailbox account.
.PP
.SH OUTPUT OPTIONS
The normal behavior of 
.I popmail
is to deliver mail locally via your system's default mail delivery
agent or MDA (usually
.I /usr/lib/sendmail
but your system may use a different MDA -- the 
.I popclient
configuration process should detect this automatically).
You can change the MDA the mail is passed to with the -mda or -m option.
.PP
Using the 
.B \-o
option, you can specify a different mail folder to which the retrieved
messages will be appended;
.I popclient
always writes the retrieved messages using Unix mail folder format so
the folder will be parsed correctly by Unix mail programs such as
.I elm
or
.I pine. 
.PP
If you prefer, for example, to have your POP
mail from a machine called 'mailgrunt' stored in the 
.I mbox
file in your home directory, you would start 
.I popclient
as follows:
.IP 
popclient \-o $HOME/mbox mailgrunt
.PP
Note that the folder specified with
.B \-o
is write-locked while popclient is writing to it,   
.PP
.I popclient
can be used in a shell pipeline by using the 
.B \-c
option.  In this mode, 
.I popclient
writes the retrieved messages to stdout, instead of a mail folder.  This would
allow you, for instance, to pass the incoming mail through a filter that
discards mail marked as 'Precedence: junk'.  Suppose you've written an AWK
script called 'dumpjunk.awk' to implement a junk mail filter.  The appropriate
syntax to retrieve your mail from 'mailgrunt', pass it through the filter,
and write it to a folder called 'realmail' in your home directory would be:

.nf
  popclient -c mailgrunt | awk -f dumpjunk.awk >$HOME/realmail
.fi
.PP
The progress/status messages written to stderr when the 
.B \-s
option has not been specified, do not interfere with the message stream, which 
is written to stdout.  You may even use 
.B \-v
and 
.B \-c
together without corrupting the message stream.  It is a good idea to use the
.B \-k
option when using 
.B \-c
to insure that your messages will not be lost if part of the shell pipeline 
does not function incorrectly.  The safest bet would be something like:

.nf
  popclient -k -c mailgrunt | myfilter >$HOME/filtered.mail
.fi
.PP
followed by

.nf
  popclient -c mailgrunt > /dev/null
.fi
.PP
when you're sure the messages were correctly processed by 'myfilter'.
.PP
.SH DAEMON MODE
The 
.B --daemon
or
.B -d 
option runs 
.I popmail
in daemon mode.  You must specify a numeric argument which is a
polling interval in seconds.
.PP
In daemon mode, 
.I popmail
puts itself in background and runs forever, querying each specified
host and then sleeping for the given polling interval.
.PP
Simply invoking
.IP
popmail -d 900
.PP
will, therefore, poll the hosts described in your 
.I ~/.poprc
file once every fifteen minutes.
.PP
Only one daemon process is permitted per user; in daemon mode,
.I popclient
makes a per-user lockfile to guarantee this.  The option
.B --quit
will kill a running daemon process.
.PP
The
.B -L
or
.B --logfile
option allows you to redirect status messages emitted while in daemon
mode into a specified logfile (follow the option with the logfile name).
This is primarily useful for debugging configurations.
.SH THE POPRC FILE
The preferred way to set up popclient (and the only way if you want to
specify a password) is to write a .poprc file in your home directory.
To protect the security of your passwords, your ~/.poprc may not have
more than u+r,u+w permissions; 
.I popclient
will complain and exit otherwise.
.PP
Comments begin with a '#' and extend through the end of the line.
Otherwise the file consists of a series of server entries.
Blank lines between server entries are ignored.
Keywords and identifiers are case sensitive.
When there is a conflict between the command-line arguments and the
arguments in this file, the command-line arguments take precedence.
.PP
Legal keywords are:

    server
    protocol (or proto)
    username (or user)
    password (or pass)
    remotefolder (or remote)
    localfolder (or local)
    mda
    keep
    flush
    fetchall
    rewrite
    nokeep
    noflush
    nofetchall
    norewrite
.PP
Legal protocol identifiers are

    pop2 (or POP2)
    pop3 (or POP3)
    imap (or IMAP)
    apop (or APOP)
    rpop (or RPOP)
.PP
Basic format is:

.nf
  server SERVERNAME protocol PROTOCOL username NAME password PASSWORD 
.fi
.PP
Example:

.nf
  server pop.provider.net protocol pop3 username jsmith password secret1
.fi
.PP
Or, using some abbreviations:

.nf
  server pop.provider.net proto pop3 user jsmith password secret1
.fi
.PP
Multiple servers may be listed:

.nf
  server pop.provider.net proto pop3 user jsmith pass secret1
  server other.provider.net proto pop2 user John.Smith pass My^Hat
.fi
.PP
Other possibilities (note use of \ to escape newline -- this is all 
one server definition.

.nf
  server pop.provider.net       \e
        proto pop3              \e
        user jsmith             \e
        pass secret1            \e
        localfolder ~/mbox
.fi
If you need to include whitespace in a parameter string, enclose the
string in double quotes.  Thus:

.nf
  server mail.provider.net      \e
        proto pop3              \e
        user jsmith             \e
        pass secret1            \e
        mda "/bin/mail %s"
.fi
Finally, you may have an initial server description headed by the keyword
`defaults' instead of `server' followed by a name.  Such a record
is interpreted as defaults for all quries to use. It may be overwritten
by individual server descriptions.  So, you could write:

.nf
  defaults                      \e
        proto pop3              \e
        user jsmith             \e
        mda "/bin/mail %s"
  server pop.provider.net       \e
        pass secret1            \e
  server mail.provider.net      \e
        pass secret2            \e
.fi
.SH EXIT CODES
To facilitate the use of 
.I popclient
in shell scripts and the like, an exit code is returned to give an indication
of what occured during a given POP connection.  The exit code can be tested
by the script and appropriate action taken.
.PP
A simple example follows.  This Bourne shell script executes 
.I popclient
and, if some messages were successfully retrieved from a mailserver retrieved
from the command line, it starts the 
.I mail
utility to read those messages.  Otherwise, it prints a brief message, and
exits.
.EX 0
#!/bin/sh

if popclient $1
then
  mail
else
  echo "No mail to read."
fi
.EE
.PP
The exit codes returned by 
.I popclient
are as follows:
.IP 0
One or more messages were successfully retrieved.
.IP 1
There was no mail awaiting retrieval.
.IP 2
An error was encountered when attempting to open a socket for the POP 
connection.  If you don't know what a socket is, don't worry about it --
just treat this as an 'unrecoverable error'.
.IP 3
The user authentication step failed.  This usually means that a bad 
user-id or password was specified.
.IP 4
Some sort of protocol error was detected.  POP is not especially forgiving
when it comes to unexpected responses, commands, etc -- the protocol invariably
calls for terminating the connection under such error conditions.
.IP 5
There was a syntax error in the arguments to 
.I popclient.
.IP 6
Some kind of I/O woes occurred when writing to the local folder.
.IP 7
There was an error condition reported by the server (POP3 only).
.IP 8
Exclusion error.  This means 
.I popclient
either found another copy of itself already running, or failed in such
a way that it isn't sure whether another copy is running.
.IP 9
Something totally undefined occured.  This is usually caused by a bug within
.I popclient.
Do let me know if this happens.
.PP
When
.I popclient
queries more than one host, the returned status is that of the last
host queried.
.SH AUTHOR
.I popclient
was written by Carl Harris at Virginia Polytechnic Institute and State   
University (a.k.a. Virginia Tech).  Version 3.0 was extensively improved
by Eric S. Raymond <esr@snark.thyrsus.com> and is now maintained by esr..
.PP
.SH FILES
.TP 5
~/.poprc
default configuration file
~/.popids
default location of file associating hosts with last message IDs seen
(used only with newer RFC1725-compliant servers supporting the UIDL command).
.SH BUGS
.PP
The --version option doesn't display MDA arguments.
.PP
Delivery via
.IR sendmail (8)
doesn't work in daemon mode;
.I popmail
dies after the first delivery.  To cope with this, in daemon mode the
delivery mode is automatically switched to append-and-lock if sendmail
is the selected delivery agent.  This needs to be fixed.
.PP
The UIDL support for RFC1725-compliant servers is not yet well tested.
.PP
No IMAP or RPOP support yet.
.PP
Send comments, bug reports, gripes, and the like to Eric S. Raymond
<esr@thyrsus.com>.
.SH NOTE
The -p (--password) option of previous versions has been removed -- it
encouraged people to expose passwords in scripts.  Passwords
must now be specified either manually or in your
.I ~/.poprc
file.
.SH SEE ALSO
mail(1), binmail(1), sendmail(8), popd(8),
RFC 937, RFC 1081, RFC 1082, RFC 1225, RFC 1460, RFC 1725.
