
/*
 * DILOOKUP.C	Lookup a history DB entry based on message 
 *		id or hash values
 *
 * (c)Copyright 1997, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution 
 *    for specific rights granted.
 */

#include "defs.h"

int DILookup(char *id);

int ScanOpt = 0;

int
main(int ac, char **av)
{
    char *id = NULL;
    int i;
    int r = 0;

    LoadDiabloConfig(ac, av);

    for (i = 1; i < ac; ++i) {
	char *ptr = av[i];

	if (*ptr != '-') {
	    id = ptr;
	} else {
	    ptr += 2;
	    switch(ptr[-1]) {
	    case 'C':
		if (*ptr == 0)
		    ++i;
		break;
	    case 's':
		ScanOpt = 1;
		break;
	    default:
		fprintf(stderr, "Illegal option: %s\n", ptr - 2);
		exit(1);
	    }
	}
    }

    if (ScanOpt == 0 && id == NULL) {
	printf("dilookup <message-id>\n");
	printf("dilookup hv1.hv2\n");
	exit(0);
    }

    HistoryOpen(NULL, 0);

    if (ScanOpt == 0) {
	r += DILookup(id);
    } else {
	char buf[256];
	while (fgets(buf, sizeof(buf), stdin) != NULL) {
	    r += DILookup(buf);
	}
    }
    return(r);
}

int
DILookup(char *id)
{
    hash_t hv;
    History h;
    int r = 0;

    if (id[0] == '<' && strchr(id, '>')) {
	*(strchr(id, '>') + 1) = 0;
	hv = hhash(id);
    } else if (id[0] == 'D' && id[1] == '.') {
	int32 dummy;
	char *p = strchr(id, '/');

	if (p && p[1] == 'B' && p[2] == '.') {
	    /*
	     * dqueue data format
	     */
	    if ((id = strchr(p, '<')) != NULL && strchr(id, '>') != NULL) {
		*(strchr(id, '>') + 1) = 0;
		hv = hhash(id);
	    } else {
		fprintf(stderr, "argument error: %s\n", id);
		exit(1);
	    }
	} else {
	    /*
	     * hash code format 1
	     */
	    if (sscanf(id + 2, "%x/%x.%x", &dummy, &hv.h1, &hv.h2) != 3) {
		fprintf(stderr, "argument error: %s\n", id);
		exit(1);
	    }
	}
    } else if (strncmp(id, "DUMP ", 5) == 0) {
	if (sscanf(id + 5, "%x.%x", &hv.h1, &hv.h2) != 2) {
	    fprintf(stderr, "argument error: %s\n", id);
	    exit(1);
	}
    } else if (sscanf(id, "%x.%x", &hv.h1, &hv.h2) != 2) {
	/*
	 * hash code format 2
	 */
	fprintf(stderr, "argument error: %s\n", id);
	exit(1);
    }

    if (HistoryLookupByHash(hv, &h) == 0) {
	char tbuf1[64];
	char tbuf2[64];

	{
	    struct tm *tp;
	    time_t t;

	    t = h.gmt * 60;
	    tp = localtime(&t);
	    strftime(tbuf1, sizeof(tbuf1), "%d-%b-%y %H:%M:%S", tp);

	    if (H_EXP(h.exp) != H_EXP((unsigned short)-1)) {
		t = h.gmt * 60 + H_EXP(h.exp) * 60 * 60;
		tp = localtime(&t);
		strftime(tbuf2, sizeof(tbuf1), "%d-%b-%y %H:%M:%S", tp);
	    } else {
		sprintf(tbuf2, "expired");
	    }
	}

	if (h.boffset || h.bsize) {
	    printf(" [D.%08x/B.%04x hv=%08x.%08x gm=%d ex=%d off=%d len=%d F=%s]"
		   " GM=(%s) EX=(%s)\n",
		h.gmt - h.gmt % 10,
		(int)h.iter,
		h.hv.h1,
		h.hv.h2,
		(int)h.gmt,
		(int)H_EXP(h.exp),
		(int)h.boffset,
		(int)h.bsize,
		((h.exp & EXPF_HEADONLY) ? "H" : ""),
		tbuf1,
		tbuf2
	    );
	} else {
	    printf(" [D.%08x/B.XXXX (B.%04x) hv=%08x.%08x gm=%d ex=%d f=%s] GM=(%s) EX=(%s) (pre-expired)\n",
		h.gmt - h.gmt % 10,
		(int)h.iter,
		h.hv.h1,
		h.hv.h2,
		(int)h.gmt,
		(int)H_EXP(h.exp),
		((h.exp & EXPF_HEADONLY) ? "H" : ""),
		tbuf1,
		tbuf2
	    );
	}
    } else {
	printf("Not Found: %s (%08x.%08x)\n", id, hv.h1, hv.h2);
	r = 1;
    }
    return(r);
}

