
/*
 * LIB/ACTIVE.C	- dactive.kp active file support
 *
 * (c)Copyright 1998, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 *
 */

#include "defs.h"

Prototype void InitDActive(const char *fileNamePat);
Prototype int GenerateXRef(Buffer *b, const char *nglist, const char *npName, const char *ctl);

KPDB *DActiveDB;

void 
InitDActive(const char *fileNamePat)
{
    DActiveDB = KPDBOpen(PatDbExpand(fileNamePat), O_RDWR);
    if (DActiveDB == NULL) {
	syslog(LOG_CRIT, "InitDActive, open failed: %s", PatDbExpand(fileNamePat));
	exit(1);
    }
}

/*
 * GenerateXRef() - generate XRef: header.  Return the number of groups that
 *		    were included in the header.
 *
 *		    Note: if this is a control message, no XRef is generated
 *		    but we still return the group-match count.
 */

int 
GenerateXRef(Buffer *b, const char *nglist, const char *npName, const char *ctl)
{
    const char *p = nglist;
    char group[MAXGNAME];
    int count = 0;

    bwrite(b, "Xref: ", 6);
    bwrite(b, npName, strlen(npName));

    while (*p) {
	int i;
	for (i = 0; p[i] && p[i] != ',' && p[i] != ' ' && p[i] != '\t'; ++i)
	    ;
	if (i == 0)
	    break;
	if (i < sizeof(group)) {
	    const char *rec;
	    int recLen;

	    bcopy(p, group, i);
	    group[i] = 0;
	    rec = KPDBReadRecord(DActiveDB, group, KP_LOCK, &recLen);

	    if (rec != NULL && ctl[0]) {
		/* 
		 * Control messages aren't entered into groups so no
		 * XRef: is generated for groups, but we still keep track
		 * of whether the control message was posted to a group
		 * we know about.
		 */
		++count;
		KPDBUnlock(DActiveDB, rec);
	    } else if (rec != NULL) {
		int f1len;
		int f2len;
		const char *f1 = KPDBGetField(rec, recLen, "NE", &f1len, NULL);
		const char *f2 = KPDBGetField(rec, recLen, "NX", &f2len, NULL);

		if (f1 || f2) {
		    int n;
		    char buf[16];

		    if (f2)
			n = (strtol(f2, NULL, 10) + 1) & 0x7FFFFFFF;
		    else
			n = (strtol(f1, NULL, 10) + 1) & 0x7FFFFFFF;

		    sprintf(buf, "%010d", n);
		    KPDBWrite(DActiveDB, group, "NX", buf, KP_UNLOCK);
		    bwrite(b, " ", 1);
		    bwrite(b, group, i);
		    bwrite(b, ":", 1);
		    sprintf(buf, "%d", n);
		    bwrite(b, buf, strlen(buf));
		    ++count;
		} else {
		    KPDBUnlock(DActiveDB, rec);
		}
	    }
	}
	p += i;
	if (*p != ',')
	    break;
	++p;
    }
    bwrite(b, "\n", 1);
    return(count);
}

