#ifndef __OD_EMIL_BUTTON_H__
#define __OD_EMIL_BUTTON_H__

/*
	ODEmilButton - a multiple choice button widget.
	- mouse button 1: handles as an ordinary button
	- mouse button 2: selects second choice
	- mouse button 3: pops up a menu

	The signals from GtkButton are not used.
	Connect signal "activate" to a function of type
	   "void (ODEmilButton *button, gpointer widget_data, gpointer signal_data)"
	or "void (ODEmilButton *button, gpointer widget_data)"
	or "void (ODEmilButton *button)"
	or "void ()"
	
	You can use the same callback function for menus items 
	and ODEmilButtons. Remember that the pointer recieved is passed with the
	widget and not the signal.

	This module was written by Johan Hanson <johan@tiq.com>.
	Johan wrote another widget originally that had a menu created by the widget.
	Then Emil wanted to attach his own menus to the widget.. which required a
	rewrite. Thus the name "ODEmilButton".

	The prefix OD is to signify that the widget is written by "Obsession Development"
	and is not part of GTK. I also refuse to write my abbreviations in mixed caps!

	/ Johan
*/

#include <gdk/gdk.h>
#include <gtk/gtkenums.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkstyle.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define OD_TYPE_EMIL_BUTTON		(od_emil_button_get_type ())
#define OD_EMIL_BUTTON(obj)		(GTK_CHECK_CAST ((obj), OD_TYPE_EMIL_BUTTON, ODEmilButton))
#define OD_EMIL_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), OD_TYPE_EMIL_BUTTON, ODEmilButtonClass))
#define OD_IS_EMIL_BUTTON(obj)		(GTK_CHECK_TYPE ((obj), OD_TYPE_EMIL_BUTTON))
#define OD_IS_EMIL_BUTTON_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), OD_TYPE_EMIL_BUTTON))

enum {
	OD_EMIL_BUTTON_PRIMARY,
	OD_EMIL_BUTTON_SECONDARY,
	OD_EMIL_BUTTON_MAX_CHOICES
};

typedef struct _ODEmilButton       ODEmilButton;
typedef struct _ODEmilButtonClass  ODEmilButtonClass;
typedef struct _ODEmilButtonChoice ODEmilButtonChoice;

/* internal structure */
struct _ODEmilButtonChoice {
	GtkWidget *widget;
	gpointer  user_data;
/*
	GtkWidget	*menu_item;
	ODEmilButton	*button;
*/
};


/* The class */
struct _ODEmilButton
{
	GtkButton parent;

	ODEmilButtonChoice choices [OD_EMIL_BUTTON_MAX_CHOICES];

	GtkWidget *menu;
	GtkStyle  *oldstyle;

	guint	nth;
	guint8	button;
	guint   config : 2;
	guint16	width, height;
};

/* the meta class */
struct _ODEmilButtonClass
{
	GtkButtonClass parent_class;

	void (* activate)      (ODEmilButton *button, void *user_data, guint index);
	void (* paint_dogear)  (GtkWidget *widget, GdkRectangle *area);
	void (* paint_menutab) (GtkWidget *widget, GdkRectangle *area);
};


/* Functions */
GtkType		od_emil_button_get_type		(void);
GtkWidget*	od_emil_button_new		(void);

/* widgets */
void		od_emil_button_set_label	(ODEmilButton       *button,
						 guint		     index,
						 const gchar        *label_text,
						 const GdkColor	    *fg,
						 const GdkColor	    *bg,
						 const gpointer	     user_data);

void		od_emil_button_set_text		(ODEmilButton       *button,
						 guint		     index,
						 const gchar        *text);
void		od_emil_button_set_colors	(ODEmilButton       *button,
						 guint		     index,
                                                 const GdkColor	    *fg,
						 const GdkColor	    *bg);
void		od_emil_button_set_user_data	(ODEmilButton	    *button,
						 guint		     index,
						 const gpointer	     user_data);
gpointer	od_emil_button_get_user_data	(const ODEmilButton *button,
						 guint		     index);

void		od_emil_button_set_widget	(ODEmilButton	    *button,
						 guint		     index,
						 GtkWidget	    *widget,
						 const gpointer	     user_data);
GtkWidget *	od_emil_button_get_widget       (const ODEmilButton *button,
						 guint		     index);
void		od_emil_button_remove_widget	(ODEmilButton	    *button,
						 guint		     index);

/* Menu functions */
GtkMenu *	od_emil_button_get_menu		(const ODEmilButton *button);
void		od_emil_button_set_menu		(ODEmilButton	    *button,
						 GtkMenu	    *menu);
void		od_emil_button_remove_menu	(ODEmilButton	    *button);

void		od_emil_button_set_active	(ODEmilButton	    *button,
						 guint		    n);
void		od_emil_button_set_none_active	(ODEmilButton	    *button);

/* Since the same code is making both the real buttons and the config buttons
   and the old method of highlighting a button doesn't work anymore, there
   is now a fancy "Config Mode"... Try it!
*/
void		od_emil_button_config_mode	(ODEmilButton	    *button,
						 gboolean	    enabled);
void		od_emil_button_config_select	(ODEmilButton	    *button,
						 gboolean	    selected);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __OD_EMIL_BUTTON_H__ */

