/*
** 1999-06-19 -	Dialog module header. Lean & mean, hopefully.
*/

#if !defined(DIALOG_H)
#define	DIALOG_H

#include <glib.h>
#include <gtk/gtk.h>

/* ----------------------------------------------------------------------------------------- */

#define	DLG_POSITIVE	(0)

typedef struct _Dialog	Dialog;

typedef void (*DlgAsyncFunc)(gint button, gpointer user);

/* ----------------------------------------------------------------------------------------- */

Dialog *	dlg_dialog_sync_new(GtkWidget *body, const gchar *title, const gchar *buttons);
Dialog *	dlg_dialog_sync_new_simple(const gchar *body, const gchar *title, const gchar *buttons);
gint		dlg_dialog_sync_new_simple_wait(const gchar *body, const gchar *title, const gchar *buttons);
gint		dlg_dialog_sync_wait(Dialog *dlg);
void		dlg_dialog_sync_close(Dialog *dlg, gint button);
void		dlg_dialog_sync_destroy(Dialog *dlg);

Dialog *	dlg_dialog_async_new(GtkWidget *body, const gchar *title, const gchar *buttons, DlgAsyncFunc func, gpointer user);
Dialog *	dlg_dialog_async_new_simple(const gchar *body, const gchar *title, const gchar *buttons, DlgAsyncFunc func, gpointer user);
Dialog *	dlg_dialog_async_new_error(const gchar *body);
void		dlg_dialog_async_close(Dialog *dlg, gint button);
void		dlg_dialog_async_close_silent(Dialog *dlg);

#endif		/* DIALOG_H */
