<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: plist.inc,v 1.14 1999/07/06 09:22:47 prenagha Exp $
# ---------------------------------------------------------------
function print_list_break (&$list_tpl, $category, $category_id, $subcategory, $subcategory_id) {
  global $sess;
	
# construct URLs that include WHERE clauses for linking to the
# search page. The Category link will show a search WHERE the
# category matches. The sub-cat link will show a search WHERE
# the subcategory matches. Need to encode the URL since it contains
# single-quotes, equal sign, and possibly spaces.
# we use base64 coding rather than urlencode and rawencode since
# it seems to be more reliable.
  $cat_search = $sess->url( "search.php3?where=" . base64_encode("category.name='$category'"));
  $subcat_search = $sess->url("search.php3?where=" . base64_encode("subcategory.name='$subcategory'"));

  $list_tpl->assign(array(
    CATEGORY           => htmlspecialchars(stripslashes($category)),
    CATEGORY_ID        => $category_id,
		CATEGORY_SEARCH    => $cat_search,
    SUBCATEGORY        => htmlspecialchars(stripslashes($subcategory)),
    SUBCATEGORY_ID     => $subcategory_id,
		SUBCATEGORY_SEARCH => $subcat_search
  ));
				
  $list_tpl->parse(LIST_HDR, "header");
  $list_tpl->parse(LIST_FTR, "footer");
  $list_tpl->parse(CONTENT, ".list_section");
	$list_tpl->clear("LIST_ITEMS");
}

function print_list ($where_clause, $username, $limit, $offset, &$content) {
  global $bookmarker, $sess;
	
# if no action, then show the same list as last time
# this page was viewed. the session start variables 
# should be set by the register function
  $bk_c = new bk_db;

  $list_tpl = new FastTemplate($bookmarker->template_dir);

  if (! $bookmarker->FastTemplate_strict ) {
    $list_tpl->no_strict();
  }

  $list_tpl->define(array(
	  list_section   => "common.list.section.tpl",
	  header         => "common.list.hdr.tpl",
	  footer         => "common.list.ftr.tpl",
	  list_item      => "common.list.item.tpl",
	  item_keyw      => "common.list.item_keyw.tpl"
  ));

  $query = sprintf("select category.name as category_name, bookmark.category_id, subcategory.name as subcategory_name, bookmark.subcategory_id, bookmark.id, bookmark.url, bookmark.name as bookmark_name, bookmark.ldesc, bookmark.keywords, rating.name as rating_name, bookmark.rating_id from bookmark, category, subcategory, rating where (bookmark.category_id = category.id and category.username = bookmark.username and bookmark.subcategory_id = subcategory.id and subcategory.username = bookmark.username and bookmark.rating_id = rating.id and rating.username = bookmark.username and bookmark.username = '%s')", $username);
  
  if ($where_clause != "") {
    $where_clause_sql = " and " . $where_clause;
  } else {
    $where_clause_sql = " ";
  }

  $order_by_sql = " order by category.name, subcategory.name, bookmark.name, bookmark.id";
  
  if ($limit > 0) {
    $limit_sql = sprintf(" limit %s,%s", $offset, $limit);
  } else {
    $limit_sql = " ";
  }
  $query .= $where_clause_sql.$order_by_sql.$limit_sql;
  
  $bk_c->query($query);
  $prev_category_id = -1;
  $prev_subcategory_id = -1;
  $rows_printed = 0;

  while ($bk_c->next_record()) {
    $rows_printed ++;

   	if (($bk_c->f("category_id") != $prev_category_id) or
	    ($bk_c->f("subcategory_id") != $prev_subcategory_id)) {

	    if ($rows_printed > 1) {
        print_list_break(&$list_tpl, $prev_category, $prev_category_id, $prev_subcategory, $prev_subcategory_id);
      }

		  $prev_category       = $bk_c->f("category_name");
		  $prev_category_id    = $bk_c->f("category_id");
		  $prev_subcategory    = $bk_c->f("subcategory_name");
		  $prev_subcategory_id = $bk_c->f("subcategory_id");
		}
		
	if ($bk_c->f("keywords") > " ") {
	  $list_tpl->assign(BOOKMARK_KEYW, htmlspecialchars(stripslashes($bk_c->f("keywords"))));
    $list_tpl->parse(KEYWORDS,"item_keyw");
	} else {
    $list_tpl->clear_href("KEYWORDS");
	}
	
	$list_tpl->assign(array(
    MAINTAIN_URL       => $sess->url("maintain.php3?id=".$bk_c->f("id")),
    MAIL_THIS_LINK_URL => $sess->url("maillink.php3?id=".$bk_c->f("id")),
    BOOKMARK_ID        => $bk_c->f("id"),
    BOOKMARK_URL       => $bk_c->f("url"),
    BOOKMARK_RATING    => htmlspecialchars(stripslashes($bk_c->f("rating_name"))),
    BOOKMARK_RATING_ID => $bk_c->f("rating_id"),
    BOOKMARK_NAME      => htmlspecialchars(stripslashes($bk_c->f("bookmark_name"))),
		BOOKMARK_DESC      => nl2br(htmlspecialchars(stripslashes($bk_c->f("ldesc")))),
		IMAGE_URL_PREFIX   => $bookmarker->image_url_prefix
	));

  $list_tpl->parse(LIST_ITEMS, ".list_item");
	}

  if ($rows_printed > 0) {
    print_list_break(&$list_tpl, $prev_category, $prev_category_id, $prev_subcategory, $prev_subcategory_id);
    $content = $list_tpl->fetch("CONTENT");
	}
}
?>
