<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: crlogin.inc,v 1.2 1999/04/17 19:41:21 prenagha Exp $
# $Log: crlogin.inc,v $
# Revision 1.2  1999/04/17 19:41:21  prenagha
# cr looks good.
#
# Revision 1.1  1999/04/17 18:14:21  prenagha
# initial rev - started with old login page.
#
#
# ---------------------------------------------------------------
global $bookmarker;

# every bookmarker page uses the FastTemplate class
# to generate HTML.
$login_tpl = new FastTemplate($bookmarker->template_dir);

if (! $bookmarker->FastTemplate_strict ) {
  $login_tpl->no_strict();
}

$login_tpl->define(array(
    standard    => "common.standard.tpl",
    msie_js    => "common.msie_js.tpl",
	  body        => "bkloginform.body.tpl",
	  invalid_msg => "bkloginform.invalid.tpl",
	  guest_msg   => "bkloginform.guest.tpl"
));

set_standard("login", &$login_tpl);

# if browser is MSIE, then need to add this bit
# of javascript to the page so that MSIE correctly
# brings quik-mark and mail-this-link popups to the front.
if (check_browser() == "MSIE") {
  $login_tpl->parse(MSIE_JS, "msie_js");
}

if (isset($this->auth["uname"])) {
  $default_username = $this->auth["uname"];
}

if (! isset($default_username)) {
  $default_username = "";
}

$login_tpl->assign(array(
  FORM_ACTION            => $sess->self_url(),
  CHALLENGE              => $challenge,
  DEFAULT_USERNAME       => $default_username
));


global $username; 
if (isset($username)) {
  $login_tpl->parse(INVALID_MSG, "invalid_msg");
}

if (isset($bookmarker->guest_user)) {
  $login_tpl->assign(array(
    GUEST_USER            => $bookmarker->guest_user,
    GUEST_PASSWORD        => $bookmarker->guest_password
  ));
  $login_tpl->parse(GUEST_MSG, "guest_msg");
}

$login_tpl->parse(BODY, "body");
$login_tpl->parse(MAIN, "standard");

$login_tpl->FastPrint();
?>
