<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: bkshared.inc,v 1.10 1999/07/08 12:11:02 prenagha Exp $
# ---------------------------------------------------------------
function  set_standard($title, &$p_tpl)  {
  global $sess, $bookmarker;

  $p_tpl->assign(array(
    TITLE            => $title,
	START_URL        => $sess->url("index.php3"),
	TREE_URL         => $sess->url("tree.php3"),
	LIST_URL         => $sess->url("list.php3"),
	CREATE_URL       => $sess->url("create.php3"),
	MAINTAIN_URL     => $sess->url("maintain.php3"),
	MAILLINK_URL     => $sess->url("maillink.php3"),
	SEARCH_URL       => $sess->url("search.php3"),
	FAQ_URL          => $sess->url("faq.php3"),
	CATEGORY_URL     => $sess->url("codes.php3?codetable=category"),
	SUBCATEGORY_URL  => $sess->url("codes.php3?codetable=subcategory"),
	RATINGS_URL      => $sess->url("codes.php3?codetable=rating"),
	USER_URL         => $sess->url("user.php3"),
	LOGOUT_URL       => $sess->url("logout.php3"),
	DOWNLOAD_URL     => $sess->url("download.php3"),
	BUGS_URL         => $sess->url("bugs.php3"),
	MAILLIST_URL     => $sess->url("maillist.php3"),
	VERSION          => $bookmarker->version
  ));
}

function set_bkusername() {
	global $sess, $auth, $bookmarker, $bkusername;

	if ($auth->auth["uname"] == $bookmarker->guest_user) {
		$bkusername = $bookmarker->guest_user_select_user;
	} else {
		$bkusername = $auth->auth["uname"];
	}

	$sess->register("bkusername");
}

# function to load a drop down list box from one
# of the standard id-name formatted tables. this
# routine will insert the <option> tags, it does
# not insert the <select> tags.
function load_ddlb($table, $selected_id, $bkusername, &$content, $blank) {
  global $bookmarker;
  
  $db_ddlb = new bk_db;
  
  $option_tpl = new FastTemplate($bookmarker->template_dir);
  if (! $bookmarker->FastTemplate_strict ) {
    $option_tpl->no_strict();
  }

  $option_tpl->define(array(
	  option_list => "common.option.tpl",
	  select      => "common.select.tpl"
  ));

# if the user wants a blank option, add that first
# the blank can be selected.
  if ($blank) {
    $opt_value =  "NONE";
		$opt_name  =  "----";
    if ($selected_id == $opt_value) {
      $opt_selected = "selected";
    } else {
      $opt_selected = "";
    }
    $option_tpl->assign(array(
      OPTION_SELECTED => $opt_selected,
      OPTION_VALUE    => $opt_value,
      OPTION_NAME     => $opt_name
    ));
    $option_tpl->parse(OPTION_LIST, ".option_list");
	}

  
  $query = sprintf("select id, name from %s where username='%s' order by name", $table, $bkusername);
  $db_ddlb->query($query);
  while ($db_ddlb->next_record()) {
    $cnt = $cnt + 1;
    $opt_value =  $db_ddlb->f("id");
		$opt_name  =  htmlspecialchars(stripslashes($db_ddlb->f("name")));
		
    if ($selected_id == $opt_value) {
      $opt_selected = "selected";
    } else {
      $opt_selected = "";
    }

    $option_tpl->assign(array(
      OPTION_SELECTED => $opt_selected,
      OPTION_VALUE    => $opt_value,
      OPTION_NAME     => $opt_name
    ));
    $option_tpl->parse(OPTION_LIST, ".option_list");
  }
	
	if ( $cnt > 0 ) {
    $option_tpl->assign(FIELD_NAME, $table);
    $option_tpl->parse(MAIN, "select");
    $content = $option_tpl->fetch("MAIN");
	} else {
	  $content = " ";
	}
}

# function to determine what type of browser the user has.
# code idea from http://www.php.net/
function check_browser() {
  global $HTTP_USER_AGENT;
	
  $browser= "UNKNOWN";

  if (ereg( "MSIE",$HTTP_USER_AGENT)) {
	  $browser = "MSIE";
  } elseif (ereg( "Mozilla",$HTTP_USER_AGENT)) {   
	  $browser = "NETSCAPE";
  } else {
	  $browser = "UNKNOWN";
  }
	
	return $browser;
}
?>
