#ifndef MixerConfig_h
#define MixerConfig_h

#include <sidplay/emucfg.h>  // where we take constants from

class voiceVol
{
 public:
    unsigned short int l, r;  // left/right volume/panning level
    voiceVol() { l = 255; r = 0; }
};

class MixerConfig
{
 public:

    int channels;     // basically the same as in emuConfig
    int mixingMode;   //
    int panningMode;  //
        
    voiceVol volFP[4];           // high quality mixing mode
    voiceVol volHQ[4];           // full panning mixing mode
    
    // These always reflect the volume slider position.
    // Max=256, Min=0. Map to slider values: 0=top=max, 100=bottom=min
    unsigned short int volTotal[4];
    
    unsigned short int muteMask[4];  // binary mask, 0=off, 65535=on
    
    MixerConfig()
    {
        channels = SIDEMU_MONO;
        mixingMode = SIDEMU_NONE;
        panningMode = SIDEMU_NONE;
        
        volHQ[0].l = volHQ[1].r = volHQ[2].l = volHQ[3].r = 255;
        volHQ[0].r = volHQ[1].l = volHQ[2].r = volHQ[3].l = 0;
        volFP[0].l = volFP[1].r = volFP[2].l = volFP[3].r = 255;
        volFP[0].r = volFP[1].l = volFP[2].r = volFP[3].l = 0;
        volTotal[0] = volTotal[1] = volTotal[2] = volTotal[3] = 256;
        muteMask[0] = muteMask[1] = muteMask[2] = muteMask[3] = 65535;
    }
};

#endif  // MixerConfig_h
