/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GLIB_GLIST_H
#define _GLIB_GLIST_H

#include "glib.h"
#include "GlobalSanityCheck.h"


/*
 *  Glib_GList: very *simple* wrapper for glib/ghash.c
 */
class Glib_GList
	{
	public:
					Glib_GList ();
		virtual			~Glib_GList ();

		void 			append (gpointer data); 
		void			prepend (gpointer data);
		void			insert (gpointer data, gint position);
		void			insert_sorted (gpointer data, GCompareFunc func); 
		void			concat (GList *list2);
		void			remove (gpointer data);
		void			remove_link (GList *link);
		void			reverse ();
		gpointer		nth (gint n);
		gpointer		find (gpointer data);
		gpointer		first ();
		gpointer		last ();
		int			length (); 
		void			foreach (GFunc func, gpointer user_data);

	protected:
		virtual void		clearList () {;}
		GList			*p_list;

	// C++ sugar
	public:
		bool operator==(const Glib_GList & rhs)
			{
			if (p_list && rhs.p_list)
				return (p_list==rhs.p_list);
			return (FALSE);
			}
	};


inline Glib_GList::Glib_GList ()
{
	p_list = NULL;
}


// user must clear list before destroying it!
inline Glib_GList::~Glib_GList ()
{
	// free any memory held by GList items
	if (p_list)
		{
		clearList();
		g_list_free (p_list);
		}
}


inline void Glib_GList::append (gpointer data)
{
	p_list = g_list_append (p_list, data);
}


inline void Glib_GList::prepend (gpointer data)
{
        p_list = g_list_prepend (p_list, data);
}


inline void Glib_GList::insert (gpointer data, gint position)
{
        p_list = g_list_insert (p_list, data, position);
}


inline void Glib_GList::insert_sorted (gpointer data, GCompareFunc func)
{
        p_list = g_list_insert_sorted (p_list, data, func);
}


inline void Glib_GList::concat (GList *list2)
{
        p_list = g_list_concat (p_list, list2);
}


inline void Glib_GList::remove (gpointer data)
{
        p_list = g_list_remove (p_list, data);
}


inline void Glib_GList::remove_link (GList *link)
{
        p_list = g_list_remove (p_list, link);
}


inline void Glib_GList::reverse ()
{
        p_list = g_list_reverse (p_list);
}


inline gpointer Glib_GList::nth (gint n)
{
	GList	*t = g_list_nth (p_list, n);
	return t->data;
}


inline gpointer Glib_GList::find (gpointer data)
{
	GList	*t = g_list_find (p_list, data);
	return t->data;
}


inline gpointer Glib_GList::first ()
{
        GList	*t = g_list_first(p_list);
	return t->data;
}


inline gpointer Glib_GList::last ()
{
        GList	*t = g_list_last(p_list);
	return t->data;
}


inline gint Glib_GList::length ()
{
	return g_list_length (p_list);;
}


// slightly different sig from orig: C++ objects to GHRFunc being used
inline void Glib_GList::foreach (GFunc		func,
				gpointer	user_data)
{
        g_list_foreach (p_list, func, user_data);
}


#endif // _GLIB_GLIST_H
