/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include "Timer.h"


/*
 * msleep: sleep n microseconds 
 */
void Timer::msleep (long n)
{
	struct timeval  sleept;

	sleept.tv_sec = 0;
	sleept.tv_usec = n;
	select(FD_SETSIZE, NULL, NULL, NULL, &sleept);
}


/*
 * getElapsedTime: return the elapsed time in a timeval struct
 */
struct timeval *Timer::getElapsedTime ()
{
	if (d_elapsedTime.tv_usec || d_elapsedTime.tv_sec)
		return &d_elapsedTime;
	else
		return NULL;
}


/*
 * getElapsedSeconds: return the elapsed time in seconds 
 */
float Timer::getElapsedSeconds ()
{
	if (d_elapsedTime.tv_usec || d_elapsedTime.tv_sec)
		return ((float)(d_elapsedTime.tv_usec/1000000.0+d_elapsedTime.tv_sec));
	else
		return -1;
}


/*
 * startStopwatch: initiate a timing sequence
 */
void Timer::start ()
{
	d_elapsedTime.tv_usec = 0;
	d_elapsedTime.tv_sec = 0;
	d_startTime.tv_usec = 0;
	d_startTime.tv_sec = 0;
	d_stopTime.tv_usec = 0;
	d_stopTime.tv_sec = 0;
	gettimeofday (&d_startTime, NULL);
}


/*
 * startStopwatch: initiate a timing sequence
 */
void Timer::stop ()
{
	long	t;

	// are we actually in a timing loop
	if (d_elapsedTime.tv_usec || d_elapsedTime.tv_sec)
		return;

	gettimeofday (&d_stopTime, NULL);

	t = d_stopTime.tv_usec - d_startTime.tv_usec;
	if (t < 0)
		t = 1000000 + t;
	d_elapsedTime.tv_usec = t;
	d_elapsedTime.tv_sec = d_stopTime.tv_sec - d_startTime.tv_sec;
}

