/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogFill.h"
#include "GuiDialogOAC.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize all data members 
 */
TFDialogFill::TFDialogFill (HeightField *HF, HeightFieldDraw *HFD) 
	        : TFPreviewDialog (HF, HFD, "Terraform Fill Dialog", 
				    "Fill Parameters", 6, 4),
		  d_vBoxOptions (TRUE, 0),
		  d_hBoxFillElv (TRUE, 0),
		  d_hBoxTightFactor (TRUE, 0),
		  d_hBoxKeepMin (TRUE, 0),
		  d_adjFillElv (0.33, 0.0, 1.0, 0.01),
		  d_adjTightFactor (0.5, 0.0, 1.0, 0.01),
		  d_hsFillElv (d_adjFillElv),
		  d_hsTightFactor (d_adjTightFactor),
		  d_lblFillElv (_("Elevation to fill up to")),
		  d_lblTightFactor (_("Tightness factor")),
		  d_lblKeepMin (_("Keep zero elevation")),
		  d_frmOptions (_("Fill Options")),
		  d_cbKeepMin ()

{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogFill\n");
	buildDialogWindow ();
	this->setHFobjs (HF, HFD); 
	sprintf (this->p_windowTitle, _("Fill: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (d_adjFillElv.value_changed, this, &TFDialogFill::updatePreviewCallback);
	connect_to_method (d_adjTightFactor.value_changed, this, &TFDialogFill::updatePreviewCallback);
	connect_to_method (d_cbKeepMin.clicked, this, &TFDialogFill::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogFill::~TFDialogFill ()
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogFill\n");
}


/*
 *  insertOptions: fill the dialog's VBox
 */
void TFDialogFill::insertOptions ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogFill called without Frame label",
		"TFDialogFill::setHFobjs");

	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hBoxFillElv.pack_start (d_lblFillElv, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblFillElv.show ();
	d_hsFillElv.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsFillElv.set_digits (2);
	d_hsFillElv.set_draw_value (TRUE);
	d_hBoxFillElv.pack_end (d_hsFillElv, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsFillElv.show ();
	d_vBoxOptions.pack_start (d_hBoxFillElv, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hBoxFillElv.show ();

	d_hBoxTightFactor.pack_start (d_lblTightFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblTightFactor.show ();
	d_hsTightFactor.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsTightFactor.set_digits (2);
	d_hsTightFactor.set_draw_value (TRUE);
	d_hBoxTightFactor.pack_end (d_hsTightFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsTightFactor.show ();
	d_vBoxOptions.pack_start (d_hBoxTightFactor, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hBoxTightFactor.show ();

	d_hBoxKeepMin.pack_start (d_lblKeepMin, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblKeepMin.show ();
	d_cbKeepMin.set_active (TRUE);
	d_hBoxKeepMin.pack_end (d_cbKeepMin, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_cbKeepMin.show ();
	d_vBoxOptions.pack_start (d_hBoxKeepMin, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hBoxKeepMin.show ();
	
	d_frmOptions.add (d_vBoxOptions);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 3);
	d_vBoxOptions.show ();
	d_frmOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogFill::buildDialogWindow ()
{
	this->set_usize (450, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();

	this->show ();
}


/*
 *  buttonCallbackApply: fill the height field 
 */
void TFDialogFill::buttonCallbackApply ()
{
	float		elv = d_adjFillElv.get_value (),
			factor = d_adjTightFactor.get_value ();
	bool		keepMin=d_cbKeepMin.get_active();

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogFill::buttonCallbackApply");
	SanityCheck::bailout ((!p_HFD), "p_HFD==NULL", "TFDialogFill::buttonCallbackApply");
	p_HFO->fill (elv, factor, keepMin);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}
	this->b_applyHit = TRUE;
}



/*
 *  updatePreviewCallback: update the preview after a widget has been updated. 
 */
void TFDialogFill::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		elv = d_adjFillElv.get_value (),
			factor = d_adjTightFactor.get_value ();
	bool		keepMin=d_cbKeepMin.get_active();

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogFill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogFill::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogFill::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->fill (elv, factor, keepMin);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}


