/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <math.h>
#include "MathTrig.h"


/*
 *  distance: static distance function using 2D coordinates
 */
double MathTrig::distance (int x1, int y1, int x2, int y2)
{
	int	dx, dy;
	double	distance;

	dx = x1-x2;
	dy = y1-y2;
	distance = sqrt (dx*dx+dy*dy);
	return (distance);
}


/*
 *  distance: static distance function using 2D points
 */
double MathTrig::distance (PT2 p1, PT2 p2)
{
	double 	dx, dy;
	double	distance;

	dx = p1.x-p2.x;
	dy = p2.y-p2.y;
	distance = sqrt (dx*dx+dy*dy);
	return (distance);
}


/*
 *  normalVector: compute normal vector, store result in tri->normal.[xyz]
 */
void MathTrig::normalVector (TriMod3D model, TriVert *tri)
{
	PT3		v1, v2;
	float 	x1, y1, z1, x2, y2, z2, x3, y3, z3;

	x1 = model.data[tri->v1].x;
	y1 = model.data[tri->v1].y;
	z1 = model.data[tri->v1].z;

	x2 = model.data[tri->v2].x;
	y2 = model.data[tri->v2].y;
	z2 = model.data[tri->v2].z;

	x3 = model.data[tri->v3].x;
	y3 = model.data[tri->v3].y;
	z3 = model.data[tri->v3].z;

	v1.x = x1 - x2;
	v1.y = y1 - y2;
	v1.z = z1 - z2;

	v2.x = x3 - x2;
	v2.y = y3 - y2;
	v2.z = z3 - z2;

	tri->normal.x = (v1.y*v2.z) - (v1.z*v2.y);
	tri->normal.y = (v1.z*v2.x) - (v1.x*v2.z);
	tri->normal.z = (v1.x*v2.y) - (v1.y*v2.x);
}


/*
 *  normalVector: compute normal vector, store result in n[3]
 */
void MathTrig::normalVector (float* u, float* v, float* n)
{
	// compute the cross product (u x v for right-handed [ccw]) 
	n[0] = u[1] * v[2] - u[2] * v[1];
	n[1] = u[2] * v[0] - u[0] * v[2];
	n[2] = u[0] * v[1] - u[1] * v[0];
}


/*
 *  normalVectorNormalized: normalize the normal vector
 */
void MathTrig::normalVectorNormalized (float* u, float* v, float* n)
{
	float	l;

	MathTrig::normalVector (u, v, n);

	l = (float)sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]);
	n[0] /= l;
	n[1] /= l;
	n[2] /= l;
}
