/*
 * input.c: Handles input for XTux.
 * Copyright 1999 David Lawrence (philaw@camtech.net.au)
 * Last modified July 26.
 */

#include <X11/keysym.h>
#include "header.h"
#include "entity.h"
#include "win.h"
#include "input.h"

extern Display *display;
extern int trigger, change_weap;
extern int map_dirty, status_dirty;
extern entity *player;

/* Handle events depending on the game state. (only PLAYING at the mo.) */
void handle_events(int *game_state)
{
  
  XEvent event;
  KeySym key;
  int pressed;
  
  XFlush(display);
  
  while( XPending(display) ) {

    XNextEvent(display, &event);

    /* Windows may have been drawn over, so update it */
    if( event.type == GraphicsExpose || event.type == Expose
	|| event.type == NoExpose ) {
      status_dirty = 1;
      map_dirty = 1;
      break;
    }

    if( event.type == KeyPress )
      pressed = 1;
    else if( event.type == KeyRelease )
      pressed = 0;
    
    key = XLookupKeysym(&event.xkey, 0);
    
    switch(key) {
    case XK_Left:
    case XK_KP_Left:
    case XK_h:
      player->x_v = -1 * pressed;
      break;
    case XK_Right:
    case XK_KP_Right:
    case XK_l:
      player->x_v = 1 * pressed;
      break;
    case XK_Up:
    case XK_KP_Up:
    case XK_k:
      player->y_v = -1 * pressed;
      break;
    case XK_Down:
    case XK_KP_Down:
    case XK_j:
      player->y_v = 1 * pressed;
      break;
    case XK_Control_L:
    case XK_Control_R:
    case XK_Alt_L:
    case XK_Alt_R:
      change_weap = pressed;
      break;
    case XK_space:
      trigger = pressed;
      break;
    case XK_Escape:
    case XK_q:
      *game_state = MENU;
      break;
    }
    
  }
  
} /* Handle Events */












