#ifndef lint
static char *RCSid = "$Id: doscmd.c,v 1.3 1999/12/24 04:36:07 mark Exp $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#if defined(DOS) || defined(WIN32) || defined(OS2) || defined(_AMIGA) /* MH 10-06-96 */

#include "rexx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined(DOS)                                        /* MH 10-06-96 */
# include <dos.h>
#endif                                                  /* MH 10-06-96 */

#include <errno.h>

#if defined(HAVE_ASSERT_H)
# include <assert.h>
#endif

#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif

#if defined(WIN32)
# ifdef _MSC_VER
#  if _MSC_VER >= 1100
/* Stupid MSC can't compile own headers without warning at least in VC 5.0 */
#   pragma warning(disable: 4115 4201 4214)
#  endif
# endif
# include <windows.h>
# ifdef _MSC_VER
#  if _MSC_VER >= 1100
#   pragma warning(default: 4115 4201 4214)
#  endif
# endif
#endif

#if defined(__WATCOMC__) || defined(_MSC_VER) || defined(__SASC) || defined(__MINGW32__)
# include "utsname.h"                                   /* MH 10-06-96 */
# define MAXPATHLEN  _MAX_PATH                          /* MH 10-06-96 */
#else                                                   /* MH 10-06-96 */
# if defined(WIN32) && defined(__IBMC__)                /* LM 26-02-99 */
#  define MAXPATHLEN (8192)
#  include <io.h>
# else
#  include <sys/param.h>                                 /* MH 10-06-96 */
#  include <sys/utsname.h>                               /* MH 10-06-96 */
# endif
#endif

#if defined (__EMX__) || defined(__WATCOMC__) || defined(_MSC_VER) || defined(DJGPP) || defined(__CYGWIN32__)
# define HAVE_BROKEN_TMPNAM
# define PATH_DELIMS ":\\/"
# if defined(__EMX__) || defined(__CYGWIN32__)
#  define ISTR_SLASH "/"  /* This is not a must, \\ works, too */
#  define I_SLASH '/'  /* This is not a must, \\ works, too */
# else
#  define ISTR_SLASH "\\" /* This is not a must, / works at least for MSC, too */
#  define I_SLASH '\\' /* This is not a must, / works at least for MSC, too */
# endif
# ifndef HAVE_UNISTD_H
#  include <io.h> /* access() */
# endif
#endif

#if !defined(WIN32)
# define mysystem system
#endif

#define BUF_SIZE 512

#define RC_OUT_OF_MEMORY (-1)
#define RC_EOF           (-2)

int getenvir( streng *envir );

#if defined(WIN32)
/*********************************************************/
static int mysystem( const char *command )
/*********************************************************/
{
   PROCESS_INFORMATION pinfo;
   STARTUPINFO         sinfo;
   DWORD               exitCode;
   DWORD               version;

   ZeroMemory(&sinfo, sizeof(sinfo));
   sinfo.cb = sizeof(sinfo);
#if !defined(HAVE_WIN32GUI)
   version = GetVersion();
   if (version < 0x80000000)
   {  /* WinNT system */
/*      printf("mysystem: WinNT\n"); */
      return system(command);
   }

   /* Win95, Win98 system */
/*   printf("mysystem: Win9x\n");*/

   /* test for redirections or pipes */
   if (command == NULL || strpbrk(command, "<>|"))
      return system(command);
/*   printf("no redirection\n");*/
#else
   sinfo.dwFlags=STARTF_USESHOWWINDOW;
   sinfo.wShowWindow=SW_HIDE;
#endif
   /* first try: assume it is a EXE-program like pkzip.exe */
   if (!CreateProcess(NULL,    /* pointer to name of executable module    */
             (char *) command, /* pointer to command line string          */
                      NULL,    /* pointer to process security attributes  */
                      NULL,    /* pointer to thread security attributes   */
                      TRUE,    /* handle inheritance flag                 */
                      0,       /* creation flags                          */
                      NULL,    /* pointer to new environment block        */
                      NULL,    /* pointer to current directory name       */
                      &sinfo,  /* pointer to STARTUPINFO                  */
                      &pinfo)) /* pointer to PROCESS_INFORMATION          */
   {  /* second try: assume a command like dir, copy, BAT-program which needs command.com */
      char *p, szTemp[4096];
      p = mygetenv("COMSPEC", szTemp, 4096);
      if (!p)
         strcpy(szTemp, "COMMAND.COM");
      strcat(szTemp, " /C ");
      strcat(szTemp, command);
      assert(strlen(szTemp) < 4096);
/*      printf("mysystem: 2nd try: <%s>\n", szTemp);*/

      if (!CreateProcess(NULL,    /* pointer to name of executable module    */
                         szTemp,  /* pointer to command line string          */
                         NULL,    /* pointer to process security attributes  */
                         NULL,    /* pointer to thread security attributes   */
                         TRUE,    /* handle inheritance flag                 */
                         0,       /* creation flags                          */
                         NULL,    /* pointer to new environment block        */
                         NULL,    /* pointer to current directory name       */
                         &sinfo,  /* pointer to STARTUPINFO                  */
                         &pinfo)) /* pointer to PROCESS_INFORMATION          */
      {
/*       printf("mysystem: 2nd try: cannot launch child process\n"); */
      return -1;
      }
   }

   /* wait until child process exits */
   WaitForSingleObject(pinfo.hProcess, INFINITE);
   GetExitCodeProcess(pinfo.hProcess, &exitCode);
   CloseHandle(pinfo.hProcess);
   CloseHandle(pinfo.hThread);
/*   printf("mysystem: exitCode %i\n", exitCode);*/
   return exitCode;
}
/*********************************************************/
int my_win32_setenv( char *name, char *value )
/*********************************************************/
{
   return (SetEnvironmentVariable( name, value ) );
}
#endif

/***********************************************************************/
static char *get_a_line(FILE *fp,char *string,int *length,int *rcode)
/***********************************************************************/
{
 int ch=' ';
 int bufs = 1;
 register int i=0;

/*---------------------------------------------------------------------*/
/* Allocate the first block of memory.                                 */
/*---------------------------------------------------------------------*/
 if ((string = (char *)malloc(BUF_SIZE+1)) == NULL)
   {
    *rcode = RC_OUT_OF_MEMORY;
    return(NULL);
   }

 for(;;)
   {
/*---------------------------------------------------------------------*/
/* Read a character form the stream...                                 */
/*---------------------------------------------------------------------*/
    if ((ch = fgetc(fp)) == EOF)
      {
/*---------------------------------------------------------------------*/
/* If EOF is reached, check that it really is end of file.             */
/*---------------------------------------------------------------------*/
       if (feof(fp))
         {
          *length = i;
          *rcode = RC_EOF;
          return(string);
         }
      }
/*---------------------------------------------------------------------*/
/* If end of line is reached, nul terminate string and return.         */
/*---------------------------------------------------------------------*/
    if ((char)ch == '\n')
      {
       *(string+i) = '\0';
       break;
      }
/*---------------------------------------------------------------------*/
/* All other characters, copy to string.                               */
/*---------------------------------------------------------------------*/
    *(string+i++) = (char)ch;
/*---------------------------------------------------------------------*/
/* If we have got to the end of the allocated memory, realloc some more*/
/*---------------------------------------------------------------------*/
    if (i == BUF_SIZE*bufs)
      {
       if ((string = (char *)realloc(string,(BUF_SIZE*(++bufs))+1)) == NULL)
         {
          *rcode = RC_OUT_OF_MEMORY;
          return(NULL);
         }
      }
   }
/*---------------------------------------------------------------------*/
/* Return a line read form the temporary file.                         */
/*---------------------------------------------------------------------*/
 *length = i;
 *rcode = 0;
 return(string);
}

#ifdef HAVE_BROKEN_TMPNAM
# ifdef tmpnam
#  undef tmpnam
# endif
# define tmpnam(s) mytmpnam(s)
static char *mytmpnam(const char *prefix)
{
/* FGC: The replacement of the broken tmpnam was broken, too. This should
 * work. tmpnam originally is broken by either:
 * * creating a tempfile only in the current dir
 * * using broken value L_tmpnam
 * This function is not thread safe.
 */
   char *path,*filename;
   char last_resort[4];
   char buf[2048]; /* enough space for largest path name */
   static char *buffer = NULL;
   static size_t buffersize = 0;
   size_t needed;
   unsigned int i;
   int len;

   if (prefix != NULL) /* L_tmpnam maybe too short -> broken original */
   {
      fputs("Regina: tmpnam replacement called in a wrong manner\n",stderr);
#ifdef EINVAL
      errno = EINVAL;
#endif
      return(NULL);
   }

   if ((path = mygetenv( "TMP", buf, sizeof(buf) )) == NULL)
   {
      if ((path = mygetenv( "TEMP", buf, sizeof(buf) )) == NULL)
      {
         if ((path = mygetenv( "TMPDIR", buf, sizeof(buf) )) == NULL)
         {
            strcpy(last_resort,"C:");
            strcat(last_resort, ISTR_SLASH);
            path = last_resort; /* works in ALL cases */
         }
      }
   }

   needed = strlen(path) + 1 /* ISTR_SLASH */ + sizeof("TMP12345.TMP");
   if (needed > buffersize)
   {
      if ((buffer = realloc(buffer,needed)) == NULL)
         return(NULL);
      buffersize = needed;
   }

   strcpy(buffer,path);
   /*
    * Finished with "path" now, so can use it below...
    */
   if (strchr(PATH_DELIMS,buffer[strlen(buffer)-1]) == NULL)
      strcat(buffer,ISTR_SLASH);
   strcat(buffer,"TMP?????.TMP");
   filename = buffer + ( strlen(buffer) - 9 );
   for (i = 0;i <= 100;i++)
   {
      sprintf(path,"%05lu",clock());
      len = strlen(path);
      memcpy(filename,path+(len - 5),5);
      if (access(buffer,0) != 0)
         return(buffer);
   }

   return(NULL);
}
#endif

char *regina_tmpnam( char *name )
{
   char *path,*slash;
   char last_resort[4];
   char buf[2048]; /* enough space for largest path name */
   unsigned int i;
   int len;
   int pid;

   if ((path = mygetenv( "TMP", buf, sizeof(buf) )) == NULL)
   {
      if ((path = mygetenv( "TEMP", buf, sizeof(buf) )) == NULL)
      {
         if ((path = mygetenv( "TMPDIR", buf, sizeof(buf) )) == NULL)
         {
            strcpy(last_resort,"C:");
            strcat(last_resort, ISTR_SLASH);
            path = last_resort; /* works in ALL cases */
         }
      }
   }
   if ( path[strlen(path)-1] != I_SLASH )
      slash = ISTR_SLASH;
   else
      slash = "";
#if (defined(__EMX__) && defined(DOS)) || defined(DJGPP)
   /*
    * We assume that these platforms can only handle files
    * with DOS 8.3 limitation, and that only 1 thread of execution
    * is possible at any point in time
    */
   for (i = 0;i <= 100;i++)
   {
      sprintf(name,"%s%sTMP%05lu", path, slash, clock() );
      if (access(name,0) != 0)
         return(name);
   }
#else
   pid = getpid();
# if THREADED
#  if PTHREAD
   tid = pthread_self();
#  endif
# endif
   for ( i = 0; i <= 100; i++ )
   {
# if THREADED
      sprintf( name, "%s%stmp%d%d%d", path, slash, pid, tid, clock() );
# else
      sprintf( name, "%s%stmp%d%d", path, slash, pid, clock() );
# endif
      if ( access( name, 0 ) != 0 )
         return( name );
   }
#endif
   return( NULL );
}

/***********************************************************************/
int dos_do_command( streng *command, int io_flags, int dummy )
/***********************************************************************/
{
   int rc=0;
   streng *cmd=NULL ;
   int in=0, out=0, fout=0 ;
   streng *inredir=NULL,*outredir=NULL ;
   int length=0, rcode=0, flush=0 ;
   streng *result=NULL ;
   char *string=NULL;

   FILE *infp,*outfp;
#if MH
   char *infile="",*outfile="";
#else
   char infile[REXX_PATH_MAX];
   char outfile[REXX_PATH_MAX];
#endif

   in = io_flags & REDIR_INPUT ;
   out = io_flags & REDIR_OUTLIFO ;
   fout = io_flags & REDIR_OUTFIFO ;

   command = Str_ify( command ) ;
   flush = (out!=0) + ((fout!=0)*2) ;

   if ((!in)&&(!out)&&(!fout))
   {
      ;       /* maybe this should not be allowed. ... */
   }
   cmd = NULL ;
/*---------------------------------------------------------------------*/
/* If redirecting stdin, create a temporary file and write the contents*/
/* of the stack to the file.                                           */
/*---------------------------------------------------------------------*/
   if (in)
   {
#if MH
      if ( ( infile = strdup( tmpnam( NULL ) ) ) == NULL )
#else
      if ( regina_tmpnam( infile ) == NULL )
#endif
      {
         perror( "While getting temporary in-file name" ) ;
         return (-1);
      }
      if ( ( infp = fopen( infile, "w" ) ) == NULL )
      {
         perror( "While opening input file" ) ;
         return (-1);
      }
      while( !stack_empty( ) )
      {
         result = Str_ify( popline( ) ) ;
         fputs( result->value, infp );
         fputs( "\n", infp );
      }
      if ( fclose( infp ) )
      {
         perror( "While closing input file" ) ;
         return (-1);
      }
      inredir = Str_make( strlen( infile ) + 4 );
      sprintf( inredir->value, "< %s ", str_trans( infile, '/', '\\' ) );
      inredir->len = strlen( inredir->value );
   }
/*---------------------------------------------------------------------*/
/* If redirecting stdout, create the name of a temporary file for the  */
/* output.                                                             */
/*---------------------------------------------------------------------*/
   if ((out)||(fout))
   {
#if MH
      if ( ( outfile = strdup( tmpnam( NULL ) ) ) == NULL )
#else
      if ( regina_tmpnam( outfile ) == NULL )
#endif
      {
         perror( "While getting temporary out-file name" ) ;
         return (-1);
      }
      outredir = Str_make( strlen( outfile ) + 3 );
      sprintf( outredir->value, "> %s", str_trans( outfile, '/', '\\' ) );
      outredir->len = strlen( outredir->value );
   }
/*---------------------------------------------------------------------*/
/* Build up the command to be passed to the system() command. The      */
/* command will contain the command to be executed, any arguments and  */
/* the redirection commands and file names.                            */
/*---------------------------------------------------------------------*/
   length = command->len + ((in) ? inredir->len : 0) + (((out)||(fout)) ? outredir->len : 0) + 2;
   cmd = Str_make(length);
   cmd = Str_cat(cmd,command);
   if (in)
   {
      cmd = Str_cat(cmd,inredir);
      Free_string(inredir);
   }
   if (out||fout)
   {
      cmd = Str_cat(cmd,outredir);
      Free_string(outredir);
   }
/*---------------------------------------------------------------------*/
/* Execute the command.                                                */
/*---------------------------------------------------------------------*/
   cmd = Str_ify(cmd);
   rc = mysystem(cmd->value);
   Free_string(cmd);
/*---------------------------------------------------------------------*/
/* If redirecting stdout, we now have to read the file and push each   */
/* line onto the stack.                                                */
/*---------------------------------------------------------------------*/
   if ((out)||(fout))
   {
      str_trans(outfile,'\\','/');
      if ((outfp = fopen(outfile,"r")) == NULL)
      {
         perror("While opening output file") ;
         return(-1);
      }

/*---------------------------------------------------------------------*/
/* If redirecting stdin, create a temporary file and write the contents*/
/* of the stack to the file.                                           */
/*---------------------------------------------------------------------*/
      for (;;)
      {
         string = get_a_line(outfp,string,&length,&rcode);
         if (rcode == RC_OUT_OF_MEMORY)
         {
            perror("While reading output file");
            return (-1);
         }
         if (rcode == RC_EOF && length == 0)
         {
            free(string);
            break;
         }
         result = Str_ncre(string,length);
         tmp_stack(result,flush==2);
         free(string);
         if (rcode == RC_EOF)
            break;
      }
      if (flush)
         flush_stack(flush==2);

      if (fclose(outfp))
      {
         perror("While closing output file") ;
         return(-1);
      }
   }
/*---------------------------------------------------------------------*/
/* Delete the temporary file(s) and free up any memory.                */
/*---------------------------------------------------------------------*/
  if (in)
  {
     unlink(str_trans(infile,'\\','/'));
     free(infile);
  }
  if ((out)||(fout))
  {
     unlink(str_trans(outfile,'\\','/'));
     free(outfile);
  }
/*---------------------------------------------------------------------*/
/* Return with, hopefully, return code from system() command.          */
/*---------------------------------------------------------------------*/
  return rc ;
}
# if defined(__WATCOMC__) || defined(_MSC_VER) || defined(__SASC) || defined(__MINGW32__)
/********************************************************* MH 10-06-96 */
int uname(struct utsname *name)                         /* MH 10-06-96 */
/********************************************************* MH 10-06-96 */
{                                                       /* MH 10-06-96 */
#  if defined (WIN32)
 SYSTEM_INFO sysinfo;
 OSVERSIONINFO osinfo;
 char computername[MAX_COMPUTERNAME_LENGTH+1];
 char *pComputerName=computername;
 DWORD namelen=MAX_COMPUTERNAME_LENGTH;
#  endif
/*-------------------------------------------------------- MH 10-06-96 */
/* Set up values for utsname structure...                  MH 10-06-96 */
/*-------------------------------------------------------- MH 10-06-96 */
#  if defined(OS2)                                      /* MH 10-06-96 */
 strcpy(name->sysname,"OS2");                           /* MH 10-06-96 */
 sprintf(name->version,"%d",_osmajor);                  /* MH 10-06-96 */
 sprintf(name->release,"%d",_osminor);                  /* MH 10-06-96 */
 strcpy(name->nodename,"standalone");
 strcpy(name->machine,"i386");
#  endif                                                /* MH 10-06-96 */
#  if defined(_AMIGA)
 strcpy(name->sysname,"AMIGA");
 sprintf(name->version,"%d",0);
 sprintf(name->release,"%d",0);
 strcpy(name->nodename,"standalone");
 strcpy(name->machine,"m68k");
#  endif
#  if defined(WIN32)                                    /* MH 10-06-96 */
 osinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
#   if defined(__WATCOMC__)
 sprintf(name->version,"%d",_osmajor);                  /* MH 10-06-96 */
 sprintf(name->release,"%d",_osminor);                  /* MH 10-06-96 */
#   else
 GetVersionEx(&osinfo);
 sprintf(name->version,"%d",osinfo.dwMajorVersion);
 sprintf(name->release,"%d",osinfo.dwMinorVersion);
#   endif
 switch(osinfo.dwPlatformId)
 {
    case VER_PLATFORM_WIN32s:
       strcpy(name->sysname,"WIN32S");
       break;
    case VER_PLATFORM_WIN32_WINDOWS:
       strcpy(name->sysname,"WIN95");
       break;
    case VER_PLATFORM_WIN32_NT:
       strcpy(name->sysname,"WINNT");
       break;
 }

 GetComputerName(pComputerName,&namelen);
 strcpy(name->nodename,computername);
 GetSystemInfo(&sysinfo);
 switch(sysinfo.dwProcessorType)
 {
    case PROCESSOR_INTEL_386:
       strcpy(name->machine,"i386");
       break;
    case PROCESSOR_INTEL_486:
       strcpy(name->machine,"i486");
       break;
    case PROCESSOR_INTEL_PENTIUM:
       strcpy(name->machine,"i586");
       break;
#if 0
    case PROCESSOR_INTEL_MIPS_R4000:
       strcpy(name->machine,"mipsR4000");
       break;
    case PROCESSOR_INTEL_ALPHA_21064:
       strcpy(name->machine,"alpha21064");
       break;
#endif

 }
#  endif /* WIN32 */

 return(0);
}
# endif
#endif
