/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#if !defined(NO_RCSID) && !defined(lint)
static char z80_xxops_c[] = "$Id: z80_xxops.c,v 3.3 1997/03/16 08:26:42 erik Rel $";
#endif


case 0x09:
	Tstates += 15;
	ADD_XX(BC);
	break;

case 0x19:
	Tstates += 15;
	ADD_XX(DE);
	break;

case 0x21:
	Tstates += 14;
	XX = RD_WORD(PC);
	PC += 2;
	break;

case 0x22:
	Tstates += 20;
	WR_WORD(RD_WORD(PC), XX);
	PC += 2;
	break;

case 0x23:
	Tstates += 10;
	XX++;
	break;

case 0x24:
	Tstates += 8;
	INC(HXX);
	break;

case 0x25:
	Tstates += 8;
	DEC(HXX);
	break;

case 0x26:
	Tstates += 11;
	HXX = RD_BYTE(PC++);
	break;

case 0x29:
	Tstates += 15;
	ADD_XX(XX);
	break;

case 0x2A:
	Tstates += 20;
	XX = RD_WORD(RD_WORD(PC));
	PC += 2;
	break;

case 0x2B:
	Tstates += 10;
	XX--;
	break;

case 0x2C:
	Tstates += 8;
	INC(LXX);
	break;

case 0x2D:
	Tstates += 8;
	DEC(LXX);
	break;

case 0x2E:
	Tstates += 11;
	LXX = RD_BYTE(PC++);
	break;

case 0x34:
	Tstates += 23;
	work16 = XX + (sgn8)RD_BYTE(PC++);
	work8 = RD_BYTE(work16);
	INC(work8);
	WR_BYTE(work16, work8);
	break;

case 0x35:
	Tstates += 23;
	work16 = XX + (sgn8)RD_BYTE(PC++);
	work8 = RD_BYTE(work16);
	DEC(work8);
	WR_BYTE(work16, work8);
	break;

case 0x36:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC), RD_BYTE(PC + 1));
	PC += 2;
	break;

case 0x39:
	Tstates += 15;
	ADD_XX(SP);
	break;

case 0x44:
	Tstates += 8;
	B = HXX;
	break;

case 0x45:
	Tstates += 8;
	B = LXX;
	break;

case 0x46:
	Tstates += 15;
	B = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x4C:
	Tstates += 8;
	C = HXX;
	break;

case 0x4D:
	Tstates += 8;
	C = LXX;
	break;

case 0x4E:
	Tstates += 15;
	C = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x54:
	Tstates += 8;
	D = HXX;
	break;

case 0x55:
	Tstates += 8;
	D = LXX;
	break;

case 0x56:
	Tstates += 19;
	D = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x5C:
	Tstates += 8;
	E = HXX;
	break;

case 0x5D:
	Tstates += 8;
	E = LXX;
	break;

case 0x5E:
	Tstates += 19;
	E = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x60:
	Tstates += 8;
	HXX = B;
	break;

case 0x61:
	Tstates += 8;
	HXX = C;
	break;

case 0x62:
	Tstates += 8;
	HXX = D;
	break;

case 0x63:
	Tstates += 8;
	HXX = E;
	break;

case 0x64:
	Tstates += 8;
	break;

case 0x65:
	Tstates += 8;
	HXX = LXX;
	break;

case 0x66:
	Tstates += 19;
	H = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x67:
	Tstates += 8;
	HXX = A;
	break;

case 0x68:
	Tstates += 8;
	LXX = B;
	break;

case 0x69:
	Tstates += 8;
	LXX = C;
	break;

case 0x6A:
	Tstates += 8;
	LXX = D;
	break;

case 0x6B:
	Tstates += 8;
	LXX = E;
	break;

case 0x6C:
	Tstates += 8;
	LXX = HXX;
	break;

case 0x6D:
	Tstates += 8;
	break;

case 0x6E:
	Tstates += 19;
	L = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x6F:
	Tstates += 8;
	LXX = A;
	break;

case 0x70:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), B);
	break;

case 0x71:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), C);
	break;

case 0x72:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), D);
	break;

case 0x73:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), E);
	break;

case 0x74:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), H);
	break;

case 0x75:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), L);
	break;

case 0x77:
	Tstates += 19;
	WR_BYTE(XX + (sgn8)RD_BYTE(PC++), A);
	break;

case 0x7C:
	Tstates += 8;
	A = HXX;
	break;

case 0x7D:
	Tstates += 8;
	A = LXX;
	break;

case 0x7E:
	Tstates += 19;
	A = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	break;

case 0x84:
	Tstates += 8;
	ADD(HXX);
	break;

case 0x85:
	Tstates += 8;
	ADD(LXX);
	break;

case 0x86:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	ADD(work8);
	break;

case 0x8C:
	Tstates += 8;
	ADC(HXX);
	break;

case 0x8D:
	Tstates += 8;
	ADC(LXX);
	break;

case 0x8E:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	ADC(work8);
	break;

case 0x94:
	Tstates += 8;
	SUB(HXX);
	break;

case 0x95:
	Tstates += 8;
	SUB(LXX);
	break;

case 0x96:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	SUB(work8);
	break;

case 0x9C:
	Tstates += 8;
	SBC(HXX);
	break;

case 0x9D:
	Tstates += 8;
	SBC(LXX);
	break;

case 0x9E:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	SBC(work8);
	break;

case 0xA4:
	Tstates += 8;
	AND(HXX);
	break;

case 0xA5:
	Tstates += 8;
	AND(LXX);
	break;

case 0xA6:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	AND(work8);
	break;

case 0xAC:
	Tstates += 8;
	XOR(HXX);
	break;

case 0xAD:
	Tstates += 8;
	XOR(LXX);
	break;

case 0xAE:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	XOR(work8);
	break;

case 0xB4:
	Tstates += 8;
	OR(HXX);
	break;

case 0xB5:
	Tstates += 8;
	OR(LXX);
	break;

case 0xB6:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	OR(work8);
	break;

case 0xBC:
	Tstates += 8;
	CMP(HXX);
	break;

case 0xBD:
	Tstates += 8;
	CMP(LXX);
	break;

case 0xBE:
	Tstates += 19;
	work8 = RD_BYTE(XX + (sgn8)RD_BYTE(PC++));
	CMP(work8);
	break;

case 0xCB:
	{
		sgn8 disp = RD_BYTE(PC++);
		XX += disp;
		switch(RD_BYTE(PC++))
		{
#			include "z80_xxcbops.c"
		}
		XX -= disp;
	}
	break;

case 0xE1:
	Tstates += 14;
	POP(XX);
	break;

case 0xE3:
	Tstates += 23;
	work16 = RD_WORD(SP);
	WR_WORD(SP, XX);
	XX = work16;
	break;

case 0xE5:
	Tstates += 15;
	PUSH(XX);
	break;

case 0xE9:
	Tstates += 8;
	PC = XX;
	break;

case 0xF9:
	Tstates += 10;
	SP = XX;
	break;

case 0xDD:
case 0xFD:
	Tstates += 4;
	PC--;
	break;

case 0xEB:
case 0xED:
	Tstates += 8;
	break;

default:
	Tstates += 4;
	PC--;
#ifdef DEBUG
	if(GETCFG(debug) & D_ILLOPS)
	{
		Msg(M_ERR, "unimplemented instruction %02X %02X at <%04x>",
			RD_BYTE(PC - 1), RD_BYTE(PC), PC - 1);
	}
#endif
	break;

