/*
 * ratCompat.c --
 *
 *	This file contains compatibility functions.
 *
 * TkRat software and its included text is Copyright 1996,1997,1998
 * by Martin Forssn
 *
 * The full text of the legal notice is contained in the file called
 * COPYRIGHT, included with this distribution.
 */

#include "rat.h"

#if TCL_MAJOR_VERSION < 8


/*
 *----------------------------------------------------------------------
 *
 * RatFile --
 *
 *      An implementation of the file command which emulates the 8.0
 *	behaviour.
 *
 * Results:
 *	A standard tcl result
 *
 * Side effects:
 *	May modify the file system
 *
 *
 *----------------------------------------------------------------------
 */

int
RatFile(ClientData dummy, Tcl_Interp *interp, int argc, char *argv[])
{
    Tcl_CmdInfo info;
    int i;

    if (argc > 3 && !strcmp("copy", argv[1])) {
	int force = 0;
	Tcl_DString ds;
	for (i=2; i<argc && '-' == argv[i][0]; i++) {
	    if (!strcmp("-force", argv[i])) {
		force = 1;
	    } else if (!strcmp("--", argv[i])) {
		i++;
		break;
	    } else {
		Tcl_SetResult(interp, "Invalid argument", TCL_STATIC);
		return TCL_ERROR;
	    }
	}
	if (i != argc-2) {
	    Tcl_SetResult(interp, "You can only give two filenames",TCL_STATIC);
	    return TCL_ERROR;
	}
	Tcl_DStringInit(&ds);
	Tcl_DStringAppend(&ds, "cp ", 3);
	if (force) {
	    Tcl_DStringAppend(&ds, "-f ", 3);
	}
	Tcl_DStringAppend(&ds, argv[i], -1);
	Tcl_DStringAppend(&ds, " ", 1);
	Tcl_DStringAppend(&ds, argv[i+1], -1);
	system(Tcl_DStringValue(&ds));
	Tcl_DStringFree(&ds);
	return TCL_OK;

    } else if (argc > 2 && !strcmp("delete", argv[1])) {
	for (i=2; i<argc && '-' == argv[i][0]; i++) {
	    if (!strcmp("-force", argv[i])) {
		continue;
	    } else if (!strcmp("--", argv[i])) {
		i++;
		break;
	    } else {
		Tcl_SetResult(interp, "Invalid argument", TCL_STATIC);
		return TCL_ERROR;
	    }
	}
	for(; i<argc; i++) {
	    unlink(argv[i]);
	}
	return TCL_OK;

    } else {
	Tcl_GetCommandInfo(interp, "RatOldFile", &info);
	return (*info.proc)(info.clientData, interp, argc, argv);
    }
}

#endif	/* TCL_MAJOR_VERSION < 8 */
