/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: file_tool.cpp,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: file_tool.cpp,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
// Revision 1.3  1997/04/29  08:54:27  ruben
// Loads of changes bij martin,
// some cleanup by me
//
// Revision 1.3  1997/04/29  08:54:27  ruben
// Loads of changes bij martin,
// some cleanup by me
//
 * Revision 1.2  1997/04/06 21:19:37  ruben
 * Added filenotify code. use this for watching for new files in directories
 *
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: file_tool.cpp,v 1.4 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

#include <qdir.h>

#include <assert.h>
#include <errno.h>

#include "file_tool.h"

#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif	 // HAVE_SYS_PARAM_H

#ifdef HAVE_SYS_UCRED_H
#include <sys/ucred.h>
#endif	 // HAVE_SYS_UCRED_H

#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif	 // HAVE_SYS_MOUNT_H

#ifdef HAVE_MNTENT_H
#include <mntent.h>
#endif	 // HAVE_MNTENT_H

//>------ we'll have to get rid of all these large strings .....

char    link_dir[PATH_MAX];
char    temp_data[PATH_MAX];
char    temp_strng[PATH_MAX];
char    temp_string[PATH_MAX];
char    number[5];

char    device_name[20];
char    mount_point[100];
char    mtab_entry[100];

/*---------------------------------------------------------------------------*/
FileEntry::FileEntry(const char *szFilename, struct stat *st):fe_fname(szFilename)
{
	memcpy(&fe_stat, st, sizeof(struct stat));
}
/*---------------------------------------------------------------------------*/
FileEntry & FileEntry::operator = (const FileEntry & entry)
{
	if (this != &entry)
	{
		fe_fname = entry.fe_fname;
		memcpy(&fe_stat, &entry.fe_stat, sizeof(struct stat));
	}
	return *this;
}
/*---------------------------------------------------------------------------*/
FileEntry:: FileEntry(const FileEntry & entry):fe_fname(entry.fe_fname)
{
	memcpy(&fe_stat, &entry.fe_stat, sizeof(struct stat));
}
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
FileList::FileList(int flags):Sortspecs(flags)
{
	setAutoDelete(TRUE);
}
/*---------------------------------------------------------------------------*/
int     FileList::compareItems(GCI item1, GCI item2)
{
	FileEntry *fe1 = (FileEntry *) item1,
	       *fe2 = (FileEntry *) item2;

	// if the first one is a dir, and the other one a file

	if (S_ISDIR(fe1->fe_stat.st_mode) && !S_ISDIR(fe2->fe_stat.st_mode))
	{
		if (Sortspecs & DirsFirst)
			return 1;
		else if (Sortspecs & DirsLast)
			return -1;
	}
	if (!S_ISDIR(fe1->fe_stat.st_mode) && S_ISDIR(fe2->fe_stat.st_mode))
	{
		if (Sortspecs & DirsFirst)
			return -1;
		else if (Sortspecs & DirsLast)
			return 1;
	}

	// both dirs/files: let comparision of filenames/sizes do the trick

	if (Sortspecs & Names)
		if (Sortspecs & Ignorecase)
			return stricmp(fe1->fe_fname, fe2->fe_fname);
		else
			return strcmp(fe1->fe_fname, fe2->fe_fname);
	else if (Sortspecs & Sizes)
		return fe1->fe_stat.st_size < fe2->fe_stat.st_size ? -1 : (fe1->fe_stat.st_size > fe2->fe_stat.st_size ? 1 : 0);
	else
		return 0;				// I would have minded if I had one.... (iow, set Sortflags)

}
/*---------------------------------------------------------------------------*/
GCI     FileList::newItem(GCI item)
{
	FileEntry *copy = NULL,
	       *entry = (FileEntry *) item;

	if (entry)
		copy = new FileEntry(*entry);
	return copy;
}
/*---------------------------------------------------------------------------*/
void    FileList::deleteItem(GCI item)
{
	FileEntry *entry = (FileEntry *) item;
	delete  entry;
}
/*---------------------------------------------------------------------------*/
int     FileList::Scandir(const char *szDir)
{
	int     res = -1;
	struct stat st;
	struct dirent *pEntry;
	char    fname[PATH_MAX];
	DIR    *pDir = opendir(szDir);

	if (pDir)
	{
		res = 0;

		if (!isEmpty())
			clear();

		while ((pEntry = readdir(pDir)))
		{
			sprintf(fname, "%s%s", szDir, pEntry->d_name);
			if (lstat(fname, &st) != -1)
				inSort(new FileEntry(pEntry->d_name, &st));
		}
		if (closedir(pDir) == -1)
			perror("closedir:");
	}
	else if (errno != EACCES)
		perror("opendir:");
	return res;
}
/*---------------------------------------------------------------------------*/
//
// Todo: rework to use fstat() perhaps this gives us some speedup
// 
FileNotify:: FileNotify(int iInterval):
iMicrosecs(iInterval)
{
	/* while(1) {int NOP=0;} // dare to uncomment me! */
}
/*---------------------------------------------------------------------------*/
FileNotify::~FileNotify()
{
	endNotify();
}
/*---------------------------------------------------------------------------*/
void    FileNotify::timerEvent(QTimerEvent *)
{
	if (stat(szFilename, &st) != -1)
	{
		if (difftime(st.st_mtime, spLastaccess))
		{
			spLastaccess = st.st_mtime;
			// printf("%s has changed\n",(const char*)szFilename);
			emit    fileChanged(szFilename);
		}
	}
	else
		warning("Could not watch file!");
}
/*---------------------------------------------------------------------------*/
/*                                                                           */
/* Shouldn't there be an endNotify here to kill left over timers ?           */
/* This code should also react to the blocking of reread_dir ();             */
/* and should put it's event in a queue. This all to prevent ambigues        */
/* situations when dragging and dropping                                     */
/*                                                                           */
/*---------------------------------------------------------------------------*/
void    FileNotify::startNotify(const char *szFname)
{
	szFilename.resize(0);

	if (stat(szFilename = szFname, &st) != -1)
	{
		spLastaccess = st.st_mtime;
		startTimer(iMicrosecs);
	}
	else
		warning("Could not watch file!");
}
/*---------------------------------------------------------------------------*/
void    FileNotify::endNotify()
{
	killTimers();
}
/*---------------------------------------------------------------------------*/

						 // first the file tools

/*---------------------------------------------------------------------------*/
RETSIGTYPE SigHandler(int sig)
{
	typedef void (*signal_handler)(...);
	char    buf[80];

	signal(sig, SIG_IGN);
	switch (sig)
	{
	case SIGINT:
		signal(SIGINT, SIG_IGN);
		fprintf(stdout, "caught signal: interrupt\n");
		fprintf(stdout, "Do you want to terminate program? (y/n)");
		scanf("%s", buf);
		signal(SIGINT, (signal_handler)SigHandler);
		if (buf[0] == 'y')
			break;
		else
			return;
	case SIGQUIT:
		fprintf(stdout, "caught signal: quit\n");
		break;
	case SIGFPE:
		fprintf(stdout, "caught signal: floating point exception\n");
		break;
	case SIGBUS:
		fprintf(stdout, "caught signal: bus error, got no ticket\n");
		break;
	case SIGSEGV:
		fprintf(stdout, "caught signal: segmentation violation\n");
		break;
	case SIGPIPE:
		fprintf(stdout, "caught signal: broken pipe, buy new one\n");
		break;
	case SIGTERM:
		fprintf(stdout, "caught signal: software termination\n");
		break;
	case SIGCHLD:
		fprintf(stdout, "caught signal: death of child process\n");
		break;
	default:
		fprintf(stdout, "Unidentified Signal caught\n");
		break;
	}

	exit(0);
}
/*---------------------------------------------------------------------------*/
int     show_mount(MountBox * temp_box)
{
#ifdef HAVE_GETMNTENT
	FILE   *mtab = setmntent(MOUNTED, "r");
	struct mntent *spMntent;

	if (mtab)
	{
		while ((spMntent = getmntent(mtab)))
		{
			sprintf(mtab_entry,
					"%s -> %s",
					spMntent->mnt_fsname,
					spMntent->mnt_dir);
			temp_box->add_item(mtab_entry,
							   spMntent->mnt_fsname,
							   spMntent->mnt_dir);

		}
		endmntent(mtab);
	}
#else
#ifdef HAVE_GETMNTINFO
	struct statfs *spStatfs_buf = NULL;
	int     iMntpoints;

	if ((iMntpoints = getmntinfo(&spStatfs_buf, MNT_WAIT)) != -1)
	{
		for (int iCurrentEntry = 0; iCurrentEntry < iMntpoints; iCurrentEntry++)
		{
			sprintf(mtab_entry,
					"%s -> %s",
					spStatfs_buf[iCurrentEntry].f_mntfromname,
					spStatfs_buf[iCurrentEntry].f_mntonname);
			temp_box->add_item(mtab_entry,
							   spStatfs_buf[iCurrentEntry].f_mntfromname,
							   spStatfs_buf[iCurrentEntry].f_mntonname);

		}

	}
#else	 // HAVE_GETMNTINFO
	FILE   *mtab = fopen("/etc/mtab", "r");

	if (mtab != NULL)
	{
		// >------- process mtab file 
		while (!feof(mtab))
		{
			fscanf(mtab, "%s", device_name);	// >------ device

			if (feof(mtab))
			{
				fclose(mtab);
				return (1);
			}

			fscanf(mtab, "%s", mount_point);	// >------ mount point

			if ((strcmp(device_name, "none") != 0) && (strcmp(mount_point, "/") != 0))
			{
				sprintf(mtab_entry,
						"%s -> %s",
						device_name + 5,
						mount_point);
				temp_box->add_item(mtab_entry,
								   device_name,
								   mount_point);
			}

			fscanf(mtab, "%s", mtab_entry);		// >------ fs type

			fscanf(mtab, "%s", mtab_entry);		// >------ rw .... etc

			fscanf(mtab, "%d", mtab_entry);		// >------ forgot 

			fscanf(mtab, "%d", mtab_entry);		// >------ forgot

		}

		fclose(mtab);
	}

#endif	 // HAVE_GETMNTINFO
#endif	 // HAVE_GETMNTENT
	return (0);
}
/*---------------------------------------------------------------------------*/
int     check_directory(char *current_path)
{
	FileList dirs;
	int     nr_dirs = 0;

	// struct stat dir_stat; UNUSED

	if (dirs.Scandir(current_path) != -1)
		for (FileEntry * entry = dirs.first(); entry; entry = dirs.next())
		{
			if (S_ISDIR(entry->fe_stat.st_mode))
				nr_dirs++;
		}
	return (nr_dirs - 2);		// compensate for . and ..

}
/*---------------------------------------------------------------------------*/
