/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: config_expl.cpp,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: config_expl.cpp,v $
 * Revision 1.3  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 *
 * Revision 1.2  1997/05/27  09:10:46  ruben
 * some indentstuff and reworked include strategy
 *
 * Revision 1.2  1997/05/27  09:10:46  ruben
 * some indentstuff and reworked include strategy
 *
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: config_expl.cpp,v 1.3 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#include "config_expl.h"

char    temp_str1[PATH_MAX];

TypeClass *types[256];
int     nr_types = 0;

/*---------------------------------------------------------------------------*/
TypeClass::TypeClass(void)
{
	extention = NULL;
	program = NULL;
	icon_name = NULL;
	arguments = NULL;
}
/*---------------------------------------------------------------------------*/
TypeClass::~TypeClass()
{
	if (extention != NULL)
		delete extention;
	if (program != NULL)
		delete program;
	if (icon_name != NULL)
		delete icon_name;
	if (arguments != NULL)
		delete arguments;
}
/*---------------------------------------------------------------------------*/
void    TypeClass::set_extention(char *new_str)
{
	extention = (char *) new char[strlen(new_str) + 1];
	strcpy(extention, new_str);
}
/*---------------------------------------------------------------------------*/
void    TypeClass::set_program(char *new_str)
{
	program = (char *) new char[strlen(new_str) + 1];
	strcpy(program, new_str);
}
/*---------------------------------------------------------------------------*/
void    TypeClass::set_icon_name(char *new_str)
{
	icon_name = (char *) new char[strlen(new_str) + 1];
	strcpy(icon_name, new_str);
}
/*---------------------------------------------------------------------------*/
void    TypeClass::set_arguments(char *new_str)
{
	arguments = (char *) new char[strlen(new_str) + 1];
	strcpy(arguments, new_str);
}
/*---------------------------------------------------------------------------*/
char   *TypeClass::get_extention(void)
{
	return (extention);
}
/*---------------------------------------------------------------------------*/
char   *TypeClass::get_program(void)
{
	return (program);
}
/*---------------------------------------------------------------------------*/
char   *TypeClass::get_icon_name(void)
{
	return (icon_name);
}
/*---------------------------------------------------------------------------*/
char   *TypeClass::get_arguments(void)
{
	return (arguments);
}
/*---------------------------------------------------------------------------*/
int     TypeClass::test_ext(char *filename)
{
	if (strstr(filename, extention) != NULL)
		return (0);

	return (1);
}
/*---------------------------------------------------------------------------*/
int     TypeClass::execute_command(char *filename)
{
	int     return_code;

	sprintf("%s %s %s", program, arguments, filename);
	return_code = system(temp_str1);

	if (return_code == -1)
	{
		fprintf(stderr, "Unknow execution error");
		return (1);
	}

	switch (return_code)
	{
	case 127:
		fprintf(stderr, "Unable to execute [/bin/sh]");
		break;
	}

	return (0);
}
/*---------------------------------------------------------------------------*/

			  // >-----   Internal Standalone functions

/*---------------------------------------------------------------------------*/
void    read_comment(FILE * temp_file)
{
	char    letter;

	letter = fgetc(temp_file);
	while ((letter != '\r') && (letter != '\n'))
		letter = fgetc(temp_file);
}
/*---------------------------------------------------------------------------*/
int     read_name(FILE * temp_file, char *temp_str)
{
	char    letter;
	int     i = 0;

	/* first read away the spaces */

	letter = fgetc(temp_file);
	while (letter != '"')
	{
		if (letter == '#')
		{
			read_comment(temp_file);
			return (1);
		}

		letter = fgetc(temp_file);

		if (feof(temp_file) == 1)
		{
			temp_str[i] = 0;
			return (1);
		}
	}

	/* now start reading until we find another " */

	letter = fgetc(temp_file);
	while (letter != '"')
	{
		if (letter == '#')
		{
			read_comment(temp_file);
			return (1);
		}

		if (feof(temp_file) == 1)
		{
			temp_str[i] = 0;
			return (1);
		}

		temp_str[i] = letter;
		letter = fgetc(temp_file);
		i++;
	}

	temp_str[i] = 0;

	return (0);
}
/*---------------------------------------------------------------------------*/
int     read_var(FILE * temp_file)
{
	char    letter;

	/* first read away the spaces */

	letter = fgetc(temp_file);
	while (letter != '=')
	{

		if (letter == '#')
		{
			read_comment(temp_file);
			return (1);
		}

		if (feof(temp_file) == 1)
			return (1);

		letter = fgetc(temp_file);
	}

	return (0);
}
/*---------------------------------------------------------------------------*/
void    print_type(TypeClass * temp_type, FILE * output_file)
{
	fprintf(output_file,
			"%s %s %s %s\n",
			temp_type->get_extention(),
			temp_type->get_program(),
			temp_type->get_icon_name(),
			temp_type->get_arguments());
}
/*---------------------------------------------------------------------------*/
void    print_type_usage(FILE * type_file)
{
	fprintf(type_file, "# [extention name]\n" \
			"#\n" \
			"# This is the piece of text the explorer will use to search for reserved\n" \
			"# types. If you want to specify .txt as an extention for example then\n" \
			"# state it like: \n" \
			"#\n" \
			"# \".txt\"\n" \
			"#\n" \
			"# [app to start]\n" \
			"#\n" \
		  "# Place the name of the program with the complete path here.\n" \
			"#\n" \
			"#\n" \
			"# [icon]\n" \
			"#\n" \
			"# The explorer is capable of displaying type icons, place an icon here if \n" \
			"# you've got a special bitmap file. Icons should be no larger than 18x18 \n" \
			"# and should be placed on a white background. Currently the program only\n" \
			"# supports .bmp files.\n" \
			"# \n" \
			"#\n" \
			"# [program args]\n" \
			"#\n" \
			"# If the program needs some arguments or switches when it wants to start\n" \
			"# with a specific file, then place those arguments here. For example:\n" \
			"#\n" \
			"# \"-file\" \n" \
			"#\n" \
			"# [extention name]  [app to start]                   [icon]      [program args]\n" \
			"\n");
}
/*---------------------------------------------------------------------------*/
int     save_types(void)
{
	FILE   *config_file;

	sprintf(temp_str1,
			"%s/.explorer.types",
			home_path);

	config_file = fopen(temp_str1, "w");
	if (config_file == NULL)
	{
		printf("Unable to open config file: %s\n", temp_str1);
		return (KERNEL_PANIC);
	}

	print_type_usage(config_file);
	for (int i = 0; i < nr_types; i++)
		print_type(types[i], config_file);

	fclose(config_file);
	return (KERNEL_OK);
}
/*---------------------------------------------------------------------------*/
int     read_types(void)
{
	int     end = 0;
	FILE   *config_file;

	sprintf(temp_str1,
			"%s/types/types.cfg",
			explore_path);

	config_file = fopen(temp_str1, "r");
	if (config_file == NULL)
	{
		printf("Unable to open config file: %s\n", temp_str1);
		return (KERNEL_PANIC);
	}

	while (end == 0)
	{
		types[nr_types] = new TypeClass;

		read_comment(config_file);

		end = read_name(config_file, temp_str1);
		types[nr_types]->set_extention(temp_str1);

		if (fscanf(config_file, "%s", temp_str1) == EOF)
			end = 1;

		types[nr_types]->set_program(temp_str1);

		if (fscanf(config_file, "%s", temp_str1) == EOF)
			end = 1;

		types[nr_types]->set_icon_name(temp_str1);

		end = read_name(config_file, temp_str1);

		types[nr_types]->set_arguments(temp_str1);

		if (end == 0)
		{
			fclose(config_file);
		}

		print_type(types[nr_types], stdout);

		nr_types++;
	}

	fclose(config_file);
	return (KERNEL_OK);
}
/*---------------------------------------------------------------------------*/

						// config class members


/*---------------------------------------------------------------------------*/
int     ConfigClass::load_resources(void)
{
	home_path = getenv("HOME");
	if (home_path == NULL)
	{
		printf("Unable to find environment variable [HOME]\n");
		return (KERNEL_PANIC);
	}

	explore_path = getenv("EXPLOREDIR");
	if (explore_path == NULL)
	{
#ifdef EXPLORERDATADIR
		explore_path = EXPLORERDATADIR;
#else
		printf("Unable to find Explorer environment variable [EXPLOREDIR]\n");
		return (KERNEL_PANIC);
#endif	 // EXPLORERDATADIR
	}

    // check to see if the path is valid
    struct DIR *checkdir;

    //>---------- first check for the explorer path itself

    checkdir=opendir (explore_path);
    if (checkdir==NULL)
    {
     printf ("The path pointed to by EXPLOREDIR does not exists\n");
     return (KERNEL_PANIC);
    }
    else
     closedir (checkdir);

    //>---------- now check for the icons directory

	sprintf (temp_string, "%s/icons/", explore_path);

    checkdir=opendir (temp_string);
    if (checkdir==NULL)
    {
     printf ("The icons directory [%s] does not exists\n",temp_string);
     return (KERNEL_PANIC);
    }
    else
     closedir (checkdir);

    //>---------- then check for the types directory

	sprintf(temp_string, "%s/types/", explore_path);

    checkdir=opendir (temp_string);
    if (checkdir==NULL)
    {
     printf ("The types directory [%s] does not exists\n",temp_string);
     return (KERNEL_PANIC);
    }
    else
     closedir (checkdir);

	sprintf(temp_string, "%s/icons/about.bmp", explore_path);
	logo = new QPixmap;
	if (!(logo->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	// >---------- Create Pixmap Icon Classes
	for (int i = 0; i < NR_ICONS; i++)
		pm[i] = new QPixmap;

	// >---------- Now load the appropriate icons
	sprintf(temp_string, "%s/icons/nd_min.bmp", explore_path);
	if (!(pm[ND_MIN]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/nd_pls.bmp", explore_path);
	if (!(pm[ND_PLUS]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/nd_nul.bmp", explore_path);
	if (!(pm[ND_NUL]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_01.bmp", explore_path);
	if (!(pm[NODE_EXPLORER]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_02.bmp", explore_path);
	if (!(pm[NODE_DESKTOP]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_03.bmp", explore_path);
	if (!(pm[NODE_FLOPPY]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_04.bmp", explore_path);
	if (!(pm[NODE_DISK]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_05.bmp", explore_path);
	if (!(pm[NODE_CDROM]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_06.bmp", explore_path);
	if (!(pm[NODE_FILECLOSED]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_07.bmp", explore_path);
	if (!(pm[NODE_FILEOPEN]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_08.bmp", explore_path);
	if (!(pm[NODE_GENERAL]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_09.bmp", explore_path);
	if (!(pm[NODE_BOGUS]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_10.bmp", explore_path);
	if (!(pm[NODE_TEXT]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_11.bmp", explore_path);
	if (!(pm[NODE_HTML]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_12.bmp", explore_path);
	if (!(pm[NODE_LINK]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_13.bmp", explore_path);
	if (!(pm[NODE_LINK_DSBL]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_14.bmp", explore_path);
	if (!(pm[NODE_CONSOLE]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_15.bmp", explore_path);
	if (!(pm[NODE_SOCKET]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_16.bmp", explore_path);
	if (!(pm[NODE_DIRLINK]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	// >----------- load explorer tool bar icons

	sprintf(temp_string, "%s/icons/expl_17.bmp", explore_path);
	if (!(pm[ICON_01]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_18.bmp", explore_path);
	if (!(pm[ICON_02]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_19.bmp", explore_path);
	if (!(pm[ICON_03]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_20.bmp", explore_path);
	if (!(pm[ICON_04]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_21.bmp", explore_path);
	if (!(pm[ICON_05]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_22.bmp", explore_path);
	if (!(pm[ICON_06]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_23.bmp", explore_path);
	if (!(pm[ICON_07]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_24.bmp", explore_path);
	if (!(pm[ICON_08]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_25.bmp", explore_path);
	if (!(pm[ICON_09]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_26.bmp", explore_path);
	if (!(pm[ICON_10]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_27.bmp", explore_path);
	if (!(pm[ICON_11]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/nd_nl1.bmp", explore_path);
	if (!(pm[ND_NL1]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/nd_nl2.bmp", explore_path);
	if (!(pm[ND_NL2]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_28.bmp", explore_path);
	if (!(pm[ICON_12]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	sprintf(temp_string, "%s/icons/expl_29.bmp", explore_path);
	if (!(pm[NODE_PLUGIN]->load(temp_string)))
	{
		printf("Unable to open [%s]\n", temp_string);
		return (KERNEL_PANIC);
	}

	return (KERNEL_OK);
}
/*---------------------------------------------------------------------------*/
void    ConfigClass::unload_resources(void)
{
	// >---------- Create Pixmap Icon Classes
	for (int i = 0; i < NR_ICONS; i++)
		delete  pm[i];

}
/*---------------------------------------------------------------------------*/
