/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: main_expl.cpp,v $
 *
 * $Revision: 1.3 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: main_expl.cpp,v $
 * Revision 1.3  1997/07/11 11:05:10  ruben
 * Added getopts
 *
 * Revision 1.2  1997/05/27  09:37:06  ruben
 * Made the lowmemory handler active once again. hopefully the new
 * prototype will not break if not found
 * (set_new_handler from <new.h>
 *
 * Revision 1.2  1997/04/29  08:14:45  ruben
 * Added set_new_handler for dumb gcc installations. *sigh*
 *
 * Revision 1.1  1997/04/25 16:07:18  martin
 * Initial revision
 *
 * Revision 1.1  1997/04/06 21:44:04  ruben
 * Initial revision
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H
 
#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: main_expl.cpp,v 1.3 1997/07/11 11:05:10 ruben Exp $";
#endif	 /* USE_RCS_ID */

#include <ewidgets.h>

#include <iostream.h>
#include <stdlib.h>


#ifdef HAVE_NEW_H
#include <new.h>  
#else
extern "C++" {
typedef void (*new_handler)();
extern "C" new_handler set_new_handler (new_handler);
}
#endif


#include <qmsgbox.h>

/*---------------------------------------------------------------------------*/
static void lowmem_handler()
{
	QMessageBox::message("Fatal Error",
                         "Something went terribly wrong and the Explorer went out of memory\nThe Explorer will quit itself after this message","Ok");
	exit(1);
}
/*---------------------------------------------------------------------------*/

const static char szOpts[] = "hvd:b:";
const static char szEnvprefix[] ="EXPLOREDIR=";

/*---------------------------------------------------------------------------*/
int     main(int argc, char **argv)
{
	QApplication::setColorMode(QApplication::CustomColors);
	QApplication a(argc, argv);
	int c;
	char *env=NULL, *bgname=NULL;
	
	set_new_handler(&lowmem_handler);	
	
	while ((c = getopt(argc,argv,szOpts)) != EOF)
	{
		switch(c)
		{
			case 'd':
				env = new char[strlen(szEnvprefix)+strlen(optarg)+1];
				strcpy(env, szEnvprefix);
				strcat(env, optarg);
				putenv(env);
				break;
			case 'b':
				bgname = new char[strlen(optarg)+1];
				strcpy(bgname,optarg);
				break;
			case 'v':
				cerr << "This is explorer 0.72, licensed to you under the GNU Public License" << endl
					 << endl	
					 <<	"You should have received a copy of the GNU General Public License" << endl
					 <<	"along with this program; if not, write to the Free Software" << endl
					 <<	"Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA." << endl
					 << endl							
					 <<	"all releases beneath 1.0 are experimental alpha's" << endl
					 <<	"and come with absolutely no warranty" << endl 
					 <<	"or fitness for a particular purpose" << endl;
				exit(1);
			case 'h':
				cerr << "Usage: " << argv[0] << ": -v -h -d path" << endl
				     << endl
					 <<	"-v - print version number" << endl
					 <<	"-h - this message" << endl
					 <<	"-d - path to explorer data directory" << endl
					 <<	"-b - pixmap to use a a background " << endl
					 <<	endl
					 <<	"Explorer also has the following options:" << endl
					 <<	endl
					 <<	"-display display, sets the X display (default is $DISPLAY). " << endl
					 <<	"-geometry geometry, sets the client geometry of the main widget." << endl
					 <<	"-fn or -font font, defines the application font. " << endl
					 <<	"-bg or -background color, sets the default background color and" << endl
					 <<	"     an application palette" << endl
					 <<	"     (light and dark shades are calculated). " << endl
					 <<	"-fg or -foreground color, sets the default foreground" << endl
					 <<	"     color. " << endl
					 <<	"-name name, sets the application name. " << endl
					 <<	"-title title, sets the application title" << endl
					 <<	"     (caption). " << endl
					 <<	"-style= style, sets the application" << endl
					 <<	"     GUI style. Possible values are motif" << endl
					 <<	"     and windows " << endl;
				exit(1);
			default:
				break;
		}
	}
	

  

	ExploreClass *f = new ExploreClass(NULL, NULL,bgname);

	a.setMainWidget(f);
	f->show();
	a.exec();
	if (env)
		delete env;
	return (0);
}
/*---------------------------------------------------------------------------*/
// vi:ts=4:sw=4:
