/*
 * vi:ts=4:sw=4:
 *
 * Project : "       "
 * Copyright 1997. All Rights Reserved.
 * 
 * $RCSfile: m_config.cpp,v $
 *
 * $Revision: 1.0 $
 * 
 * $Author:  martin $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */
 
#include "m_config.h"
#include "parser.h"

char compose_str [PATH_MAX];

/*---------------------------------------------------------------------------*/ 
ConfigClass::ConfigClass (char *config_file)
{
 parent      =NULL;
 program_name=NULL;
 file_name   =NULL;

 if (config_file!=NULL)
 {
   file_name=(char *) malloc (strlen (config_file)+1);
   strcpy (file_name,config_file);
 }
 else
 {
   file_name=(char *) malloc (strlen (DEFAULT_CONFIG)+1);
   strcpy (file_name,DEFAULT_CONFIG);
 }
 
 file_pointer  =NULL;

 group_top     =NULL;
 group_current =NULL;

 default_int   =DEFAULT_INT;
 default_float =DEFAULT_FLOAT;
 default_string=NULL;

 default_string=(char *) malloc (strlen (DEFAULT_STRING)+1);
 strcpy (default_string,DEFAULT_STRING);

}
/*---------------------------------------------------------------------------*/ 
ConfigClass::ConfigClass (char *config_file,char *prog_name)
{
 parent      =NULL;
 program_name=NULL;
 file_name   =NULL;
 
 if (prog_name!=NULL)
 {
   program_name=(char *) malloc (strlen (prog_name)+1);
   strcpy (program_name,prog_name);
 }

 if (config_file!=NULL)
 {
   file_name=(char *) malloc (strlen (config_file)+1);
   strcpy (file_name,config_file);
 }
 else
 {
   file_name=(char *) malloc (strlen (DEFAULT_CONFIG)+1);
   strcpy (file_name,DEFAULT_CONFIG);
 }
 
 file_pointer  =NULL;

 group_top     =NULL;
 group_current =NULL;

 default_int   =DEFAULT_INT;
 default_float =DEFAULT_FLOAT;
 default_string=NULL;

 default_string=(char *) malloc (strlen (DEFAULT_STRING)+1);
 strcpy (default_string,DEFAULT_STRING);

}
/*---------------------------------------------------------------------------*/ 
ConfigClass::~ConfigClass ()
{
 if (parent!=NULL) // clone data structure and give the copy to the parent
 {
 
 }
}
/*---------------------------------------------------------------------------*/     
void ConfigClass::insert_group (char *new_name)
{
 if (group_top==NULL)
 {
  group_top          =new group_entry;
  group_current      =group_top;
  group_current->next=NULL;  
 }
 else
 {
  group_current->next=new group_entry;
  group_current=group_current->next;
  group_current->next=NULL;
 }
 
 // now fill in the blanks
 group_current->group_name=(char *) malloc (strlen (new_name)+1);
 strcpy (group_current->group_name,new_name);

 group_current->var_top    =NULL;
 group_current->var_current=NULL;
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::insert_entry (char *name,
                                char *var_string,...)
{
 int i=0;

 //>------ make sure we have a group to insert to, if not create one
 if (group_top==NULL)
 {
  group_top          =new group_entry;
  group_current      =group_top;
  group_current->next=NULL;  

  group_current->group_name=(char *) malloc (strlen ("main")+1);
  strcpy (group_current->group_name,"main");

  group_current->var_top    =NULL;
  group_current->var_current=NULL;
 }

 //>------ create a new entry in the current group

 if (group_current->var_top==NULL)
 {
  group_current->var_top=new conf_entry;
  group_current->var_current=group_current->var_top;
  group_current->var_current->next=NULL;
 }
 else
 {
  group_current->var_current->next=new conf_entry;
  group_current->var_current=group_current->var_current->next;
  group_current->var_current->next=NULL;
 }

 //>------ add the actual variables to the current entry in the current group
 group_current->var_current->var_name =(char *) malloc (strlen (name)+1);
 strcpy (group_current->var_current->var_name,name);

 group_current->var_current->var_types=(char *) malloc (strlen (var_string)+1);
 strcpy (group_current->var_current->var_types,var_string);
 group_current->var_current->nr_entries=strlen (var_string);

 va_list ap;
 va_start (ap,var_string);

 while (*var_string)
 {
  group_current->var_current->var_array [i]=(void *) va_arg (ap,void *);
  // don't forget to set the contents of the pointer to the default value

  var_string++;
  i++; 
 }
 
 va_end (ap);
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::insert_entry_to_group (char *name,
                                         char *group,
                                         char *var_string,...)
{
 name=name;
 group=group;
 var_string=var_string;

}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::set_defaults (int def1,float def2,char *def3)
{
 default_int  =def1;
 default_float=def2;

 if (default_string!=NULL)
  free (default_string);

 default_string=(char *) malloc (strlen (def3)+1);
   strcpy (default_string,def3); 
}
/*---------------------------------------------------------------------------*/ 
int ConfigClass::read_config (void)
{
 char *home=getenv ("HOME");
 if (home==NULL)
 {
  fprintf (stderr,"Unable to find home-directory\n");
  return (NO_HOMEDIR);
 }

 compose_str [0]=0;
 sprintf (compose_str,"%s/%s",home,file_name);
 file_pointer=fopen (compose_str,"r");
 if (file_pointer==NULL)
 {
  // we'll leave the next fprintf out because this could be the first time
  // that someone is running the program

  // fprintf (stderr,"No config file found with specified name\n");
  return (NO_CONFIG);      
 }
 
 //>----------- now read the damn thing :)

 if (file_pointer!=NULL)
 {
  printf ("parsing....\n");
  parse_a_file (this,file_pointer);
 }

 fclose (file_pointer); 
 return (0);
}
/*---------------------------------------------------------------------------*/ 
int ConfigClass::write_entries (FILE *temp_file,struct conf_entry *temp_entry)
{
 int i;

 while (temp_entry!=NULL)
 {
  fprintf (temp_file,"\n<%s> ",temp_entry->var_name);

  for (i=0;i<temp_entry->nr_entries;i++)
  {
   switch (temp_entry->var_types [i])
   {
    case 'i': 
              fprintf (temp_file," %d",*((int *) (temp_entry->var_array [i])));
              break;
    case 'f': 
              fprintf (temp_file," %f",*((float *) (temp_entry->var_array [i])));
              break;
    case 's': 
              fprintf (temp_file," \"%s\"",(char *) temp_entry->var_array [i]);
              break;
   }
  }

  fprintf (temp_file,"\n");

  temp_entry=temp_entry->next;
 }

 return (0);
}
/*---------------------------------------------------------------------------*/ 
int ConfigClass::write_config (void)
{
 time_t time_struct;

 time (&time_struct);

 char *home=getenv ("HOME");
 if (home==NULL)
 {
  fprintf (stderr,"Unable to find home-directory\n");
  return (NO_HOMEDIR);
 }

 compose_str [0]=0;
 sprintf (compose_str,"%s/%s",home,file_name);

 file_pointer=fopen (compose_str,"w");
 if (file_pointer==NULL)
 {
  fprintf (stderr,
           "Unable to open config file with specified name\n [%s]\n",
           compose_str);
  return (ERROR_WRITING);      
 }

 fprintf (file_pointer,"\n\n");
 fprintf (file_pointer,"# This file was automaticly generated, please do not edit\n");
 fprintf (file_pointer,"# by hand unless you know what you're doing\n");
 fprintf (file_pointer,"#\n");
 fprintf (file_pointer,"# File created by ConfigManager v0.10 on %s",ctime (&time_struct));
 fprintf (file_pointer,"# Copyright (C) 1997 Martin van Velsen, vvelsen@ronix.ptf.hro.nl\n");
 fprintf (file_pointer,"#\n");

 if (program_name!=NULL)
   fprintf (file_pointer,"# This config file belongs to the (%s) package\n",
                         program_name);

 fprintf (file_pointer,"#\n");
 fprintf (file_pointer,"\n");

 // now traverse the group/entry/variable tree

 struct group_entry *temp_group=group_top;

 while (temp_group!=NULL)
 {
  fprintf (file_pointer,"\n#--------------------------------------------------------\n\n");
  fprintf (file_pointer,"[%s]\n\n",temp_group->group_name);

  if (temp_group->var_top!=NULL)
   write_entries (file_pointer,
                  temp_group->var_top);

  temp_group=temp_group->next;
 }
 
 fprintf (file_pointer,"# end of (%s)\n\n",file_name);

 fclose (file_pointer); 
 return (0);
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::create_group (char *token)
{
 token=token;
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::create_var   (char *token)
{
 token=token;
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::add_integer  (int token)
{
 token=token;
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::add_float    (float token)
{
 token=token;
}
/*---------------------------------------------------------------------------*/ 
void ConfigClass::add_string   (char *token)
{
 token=token;
}
/*---------------------------------------------------------------------------*/  
struct group_entry *ConfigClass::find_group (char *target)
{
 group_entry *temp_group=group_top;

 while (temp_group!=NULL)
 {
  if (strcmp (temp_group->group_name,target)==0)
   return (temp_group);    

  temp_group=temp_group->next;
 }
 
 return (temp_group);
}
/*---------------------------------------------------------------------------*/  
struct conf_entry *ConfigClass::find_entry (char *target)
{
 group_entry *temp_group=group_top;
 conf_entry  *temp_entry=NULL;

 while (temp_group!=NULL)
 {
  temp_entry=temp_group->var_top;
  while (temp_entry!=NULL)
  {
   if (strcmp (temp_entry->var_name,target)==0)
     return (temp_entry);    

   temp_entry=temp_entry->next;
  }   

  temp_group=temp_group->next;
 }
 
 return (temp_entry);
}
/*---------------------------------------------------------------------------*/  
