dnl #########################################################################
dnl
dnl Project : Linux Explorer & Mindseye
dnl Copyright 1996,1997. All Rights Reserved.
dnl
dnl $RCSfile: aclocal.m4,v $
dnl
dnl $Revision: 1.6 $
dnl
dnl $Author: ruben $
dnl
dnl $Locker:  $
dnl
dnl $State: Exp $
dnl
dnl $Log: aclocal.m4,v $
dnl Revision 1.6  1997/06/24 13:03:57  ruben
dnl Fixed cannot-find-mesa-in-my-total-weird-path bug in the AC_PATH_GL
dnl macro. problem may persist in AC_PATH_QT, please report if so...
dnl
dnl
dnl #########################################################################


dnl #########################################################################
dnl Synopsis:
dnl     AC_PATH_USR_LOCALSHARE
dnl Purpose:
dnl     To include local includes and libraries in the searchpath
dnl     Currently: only /usr/share/ include and lib and
dnl     /usr/local include and lib are added to the searchpath
dnl
dnl Access:
dnl     None
dnl
dnl Defines: (to DEFS or config.h)
dnl     None
dnl Substitutions: (to Makefile from Makefile.in)
dnl     CFLAGS  - Will have the gcc/g++ specific flags
dnl Requirements:
dnl     AC_PROG_CC must be called first
dnl Returns:
dnl     gcc flags in CFLAGS or configure will warn that you are not using gcc
dnl #########################################################################

AC_DEFUN(AC_PATH_USR_LOCALSHARE,
[
AC_PROVIDE([$0])

AC_CHECKING(["for extra includes"])

for ac_dir in               \
  /usr/local/include        \
  /usr/share/include        \
  ; \
do
  if test -d "$ac_dir"; then
    CPPFLAGS="${CPPFLAGS} -I$ac_dir"
    AC_MSG_RESULT(["+ Adding -I$ac_dir"])
  fi
done


AC_CHECKING(["for extra library dirs"])
for ac_dir in               \
  /usr/local/lib            \
  /usr/share/lib            \
  ; \
do
  if test -d "$ac_dir"; then
    LIBS="${LIBS} -L$ac_dir"
    AC_MSG_RESULT(["+ Adding -L$ac_dir"])
  fi
done

])

dnl 
dnl #########################################################################
dnl Synopsis:
dnl        AC_C_GCCFLAGS
dnl    Purpose:
dnl        To set g++ specific flags
dnl Access:
dnl
dnl --enable-gcc-warn-all   when using gcc, warn on everything    
dnl --enable-gcc-error-all  when using gcc, turn all warnings in errors
dnl 
dnl
dnl Defines: (to DEFS or config.h)
dnl        None
dnl    Substitutions: (to Makefile from Makefile.in)
dnl        CFLAGS  - Will have the gcc/g++ specific flags
dnl Requirements:
dnl        AC_PROG_CC must be called first
dnl    Returns:
dnl        gcc flags in CFLAGS or configure will warn that you are not using gcc
dnl #########################################################################

AC_DEFUN(AC_C_GCCFLAGS,
[
AC_PROVIDE([$0])
AC_REQUIRE([AC_PROG_CC])

ac_cv_with_gcc_warn_all=
ac_cv_with_gcc_error_all=


AC_ARG_ENABLE(gcc-warn-all,
    [  --enable-gcc-warn-all   when using gcc, warn on everything],
    [  ac_cv_enable_gcc_warn_all="$enableval" ])

AC_ARG_ENABLE(gcc-error-all,
    [  --enable-gcc-error-all  when using gcc, turn all warnings in errors],
    [  ac_cv_enable_gcc_error_all="$enableval" ])

if test "$GCC" = yes ; then
    AC_MSG_CHECKING(["for extra gcc flags"])
    if test "${ac_cv_with_gcc_error_all}" = yes; then
        CFLAGS="${CFLAGS} -Werror"
    fi
    if test "${ac_cv_with_gcc_warn_all}" = yes; then
        CFLAGS="${CFLAGS} -Wall"
    fi
    AC_MSG_RESULT(["$CFLAGS"])
else
    AC_MSG_WARN(["Using gcc specific flags disabled because you don\'t have gcc"])
fi
])

dnl #########################################################################
dnl Synopsis:
dnl        AC_C_GXXFLAGS
dnl    Purpose:
dnl        To set g++ specific flags
dnl Access:
dnl
dnl --enable-g++-warn-all   when using g++, warn on everything    
dnl --enable-g++-error-all  when using g++, turn all warnings in errors
dnl 
dnl
dnl Defines: (to DEFS or config.h)
dnl        None
dnl    Substitutions: (to Makefile from Makefile.in)
dnl        CXXFLAGS  - Will have the g++/g++ specific flags
dnl Requirements:
dnl        AC_PROG_CC must be called first
dnl    Returns:
dnl        g++ flags in CXXFLAGS or configure will warn that you are not using g++
dnl #########################################################################

AC_DEFUN(AC_C_GXXFLAGS,
[
AC_PROVIDE([$0])
AC_REQUIRE([AC_PROG_CXX])

ac_cv_enable_gxx_warn_all=
ac_cv_enable_gxx_error_all=


AC_ARG_ENABLE(gxx-warn-all,
    [  --enable-gxx-warn-all   when using g++, warn on everything],
    [  ac_cv_enable_gxx_warn_all="$enableval" ],
    [  ac_cv_enable_gxx_warn_all="no" ])

AC_ARG_ENABLE(gxx-error-all,
    [  --enable-gxx-error-all  when using g++, turn all warnings in errors],
    [  ac_cv_enable_gxx_error_all="$enableval" ],
    [  ac_cv_enable_gxx_error_all="no" ])
    

if test "$GXX" = yes ; then
    AC_MSG_CHECKING(["for extra g++ flags"])
    if test "${ac_cv_enable_gxx_error_all}" = yes; then
        CXXFLAGS="${CXXFLAGS} -Werror"
    fi
    if test "${ac_cv_enable_gxx_warn_all}" = yes; then
        CXXFLAGS="${CXXFLAGS} -Wall"
    fi
    AC_MSG_RESULT(["$CXXFLAGS"])
else
    AC_MSG_WARN(["Using g++ specific flags disabled because you don\'t have g++"])
fi
])

dnl #########################################################################
dnl Synopsis:
dnl        AC_PATH_QT
dnl    Purpose:
dnl        To seek and find your Qt installation
dnl Access:
dnl
dnl    --with-qt-dir           where the root of qt is installed (/usr/local/qt)    
dnl --with-qt-include       where the qt includes are. (/usr/local/qt/include)
dnl --with-qt-lib           where the qt library is installed. (/usr/local/qt/lib)
dnl
dnl Defines: (to DEFS or config.h)
dnl        None
dnl    Substitutions: (to Makefile from Makefile.in)
dnl        QT_CFLAGS - Path to Qt includes (-Iwhateverincdir)
dnl        QT_LIBS   - Linkpath and libraryname (-Lwhateverlibdir -lqt)
dnl Requirements:
dnl        AC_PATH_XTRA must be called first
dnl    Returns:
dnl        values in QT_CFLAGS and QT_LIBS, or configure will stop on error
dnl #########################################################################

AC_DEFUN(AC_PATH_QT,
[
AC_PROVIDE([$0])
AC_REQUIRE_CPP
AC_REQUIRE([AC_PATH_XTRA])

ac_cv_with_qt_dir=
ac_cv_with_qt_lib=
ac_cv_with_qt_inc=
QT_CFLAGS=
QT_LIBS=

AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed (/usr/local/qt) ],
    [  ac_cv_with_qt_dir="$withval" ])

AC_ARG_WITH(qt-include,
    [  --with-qt-include       where the qt includes are. (/usr/local/qt/include) ],
    [  ac_cv_with_qt_inc="$withval" ])
    
AC_ARG_WITH(qt-lib,
    [  --with-qt-lib           where the qt library is installed. (/usr/local/qt/lib)],
    [  ac_cv_with_qt_lib="$withval" ])
    
dnl try to set some paths

AC_MSG_CHECKING("for Qt location")

for ac_dir in				\
	${ac_cv_with_qt_dir}	\
	${QTDIR}				\
	/usr/local/qt			\
	/usr/share/qt			\
	; \
do
	if test -n "$ac_dir" && test -d "$ac_dir"; then
        ac_cv_with_qt_dir="$ac_dir" 
		break;
	fi
done

if test ! -n "$ac_cv_with_qt_dir"; then
	AC_MSG_RESULT("Nonstandard")
else
	AC_MSG_RESULT("$ac_cv_with_qt_dir")
fi

dnl check for libraries and includes

AC_MSG_CHECKING("for Qt include paths")
AC_LANG_SAVE
AC_LANG_CPLUSPLUS

AC_TRY_CPP([#include <qapp.h>],
[
	AC_MSG_RESULT(["Good, includes in your path"])
],
[
AC_MSG_RESULT(["Not in your path, searching..."])
for ac_dir in                   \
	$ac_cv_with_qt_dir/include	\
	$ac_cv_with_qt_inc	        \
    /usr/local/qt/include       \
    /usr/local/include/qt       \
    /usr/share/qt/include       \
    /usr/share/include/qt       \
    /usr/qt/include             \
    /usr/include/qt             \
    /usr/X11R6/include/qt       \
    /usr/include/X11/qt         \
    /usr/local/X11R6/include/qt \
    /usr/local/X11/include/qt   \
    ; \
do
   AC_MSG_CHECKING(["in $ac_dir"])
   if test -r "$ac_dir/qapp.h"; then
      ac_cv_with_qt_inc=$ac_dir
      break
   fi
   AC_MSG_RESULT(["no"])
done

if test -n "$ac_cv_with_qt_inc" ; then
   AC_MSG_RESULT(["yes"])
   QT_CFLAGS="-I${ac_cv_with_qt_inc}"
else
   AC_MSG_ERROR(["Can\'t find the Qt includes"])
fi
])
AC_LANG_RESTORE


AC_CHECKING("for Qt library path")

SAVE_LIBS="${LIBS}"
    
AC_CHECK_LIB(qt, main,
[
    QT_LIBS="-lqt"
	AC_SUBST(QT_LIBS)
	AC_MSG_RESULT(["Good, libraries in your path"])
],
[
AC_MSG_RESULT(["Not in your path, searching..."])
for ac_dir in               \
	$ac_cv_with_qt_dir/lib	\
	$ac_cv_with_qt_lib	    \
    /usr/local/qt/lib       \
    /usr/local/lib/qt       \
    /usr/share/qt/lib       \
    /usr/share/lib/qt       \
    /usr/qt/lib             \
    /usr/lib/qt             \
    /usr/X11R6/lib/qt       \
    /usr/lib/X11/qt         \
    /usr/local/X11R6/lib/qt \
    /usr/local/X11/lib/qt   \
    /usr/X11R6/lib          \
    /usr/lib/X11            \
    /usr/local/X11R6/lib    \
    /usr/local/X11/lib      \
    ; \
do
   SAVE2_LIBS="${LIBS}"
   LIBS="${LIBS} -L$ac_dir -lqt  $X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS"
   AC_MSG_CHECKING("for -lqt in $ac_dir")
   AC_TRY_LINK([],[ main ],
	[
		ac_cv_with_qt_lib=$ac_dir
		QT_LIBS="-L$ac_cv_with_qt_lib -lqt"
		break
	],
	[
		AC_MSG_RESULT(["no"])	
	])
   LIBS="${SAVE2LIBS}"
done

if test -n "$ac_cv_with_qt_lib" ; then
   AC_MSG_RESULT(["yes"])
else
   AC_MSG_ERROR(["Can\'t find the Qt library"])
fi
],
[$X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS])

LIBS="${SAVE_LIBS}"

AC_MSG_RESULT(["+ Qt libraries ${ac_cv_with_qt_lib}, Qt includes ${ac_cv_with_qt_inc}"])


SAVE_PATH="${PATH}"
if test -n $PATH ; then
    PATH="${PATH}:$ac_cv_with_qt_dir/bin"
else
    PATH="$ac_cv_with_qt_dir/bin"
fi

AC_PATH_PROG(MOC, moc, no)
if test "$MOC" = no; then
    AC_MSG_ERROR("You need to install Qt first: can\'t find the meta object compiler")
fi
PATH="${SAVE_PATH}"


AC_SUBST(QT_LIBS)
AC_SUBST(QT_CFLAGS)

])

dnl #########################################################################
dnl Synopsis:
dnl        AC_PATH_GL
dnl    Purpose:
dnl        To seek and find your Qt installation
dnl Access:
dnl
dnl    --with-gl-dir           where the root of gl is installed (/usr/local/gl)    
dnl --with-gl-include       where the gl includes are. (/usr/local/gl/include)
dnl --with-gl-lib           where the gl library is installed. (/usr/local/gl/lib)
dnl --enable-mesagl         If you always want MesaGL instead of just GL
dnl Defines: (to DEFS or config.h)
dnl        None
dnl    Substitutions: (to Makefile from Makefile.in)
dnl        GL_CFLAGS - Path to Qt includes (-Iwhateverincdir)
dnl        GL_LIBS   - Linkpath and libraryname (-Lwhateverlibdir -lgl)
dnl Requirements:
dnl        AC_PATH_XTRA must be called first, for now
dnl    Returns:
dnl        values in GL_CFLAGS and GL_LIBS, or configure will stop on error
dnl #########################################################################

AC_DEFUN(AC_PATH_GL,
[
AC_PROVIDE([$0])
AC_REQUIRE([AC_PATH_XTRA])

ac_cv_with_gl_dir=
ac_cv_with_gl_lib=
ac_cv_with_gl_inc=
ac_cv_enable_mesagl=

GL_CFLAGS=
GL_LIBS=

AC_ARG_WITH(gl-dir,
    [  --with-gl-dir           where the root of gl is installed (/usr/local/gl) ],
    [  ac_cv_with_gl_dir="$withval" ])

AC_ARG_WITH(gl-include,
    [  --with-gl-include       where the gl includes are. (/usr/local/gl/include) ],
    [  ac_cv_with_gl_inc="$withval" ])
    
AC_ARG_WITH(gl-lib,
    [  --with-gl-lib           where the gl library is installed. (/usr/local/gl/lib)],
    [  ac_cv_with_gl_lib="$withval" ])

AC_ARG_ENABLE(mesagl,
    [  --enable-mesagl         If you always want MesaGL instead of just GL ],
    [  ac_cv_enable_mesagl="$enableval" ],
    [  ac_cv_enable_mesagl="no" ])
    

AC_MSG_CHECKING("we like Mesa GL instead of just OpenGL")
AC_MSG_RESULT("$ac_cv_enable_mesagl")

dnl try to set some paths

AC_MSG_CHECKING("for Gl location")

for ac_dir in				\
	${GLDIR}				\
	${ac_cv_with_gl_dir}	\
	/usr/gl			        \
	/usr/local/gl			\
	/usr/share/gl			\
	/usr/GL			        \
	/usr/local/GL			\
	/usr/share/GL			\
	/usr/MesaGL			    \
	/usr/local/MesaGL		\
	/usr/share/MesaGL		\
	; \
do
	if test -n "$ac_dir" && test -d "$ac_dir"; then
        ac_cv_with_gl_dir="$ac_dir" 
		break;
	fi
done

if test ! -n "$ac_cv_with_gl_dir"; then
	AC_MSG_RESULT("don\'t know...")
else
	AC_MSG_RESULT("$ac_cv_with_gl_dir")
fi
dnl check for libraries and includes
dnl TODO: use the value of $ac_cv_with_gl_inc first if it existed!
 

AC_MSG_CHECKING("for Gl include paths")

AC_TRY_CPP([#include <GL/gl.h>],
[
	AC_MSG_RESULT(["Good, includes in your path"])
],
[
AC_MSG_RESULT(["Not in your path, searching..."])
for ac_dir in                   \
	$ac_cv_with_gl_dir/include	\
	$ac_cv_with_gl_inc	        \
    /usr/local/MesaGL/include   \
    /usr/local/include          \
    /usr/share/MesaGL/include   \
    /usr/share/include          \
    /usr/MesaGL/include         \
    /usr/include                \
    /usr/include/GL             \
    /usr/X11R6/include          \
    /usr/include/X11            \
    /usr/local/X11R6/include    \
    /usr/local/X11/include      \
    ; \
do
   AC_MSG_CHECKING(["in $ac_dir"])
   if test -r "$ac_dir/GL/gl.h"; then
      ac_cv_with_gl_inc=$ac_dir
      break
   fi
   AC_MSG_RESULT(["no"])
done

if test -n "$ac_cv_with_gl_inc" ; then
   AC_MSG_RESULT(["yes"])
   GL_CFLAGS="-I${ac_cv_with_gl_inc}"
else
   AC_MSG_ERROR(["Can\'t find the Gl includes"])
fi
])



AC_MSG_RESULT(["+ Gl libraries ${ac_cv_with_gl_lib}, Gl includes ${ac_cv_with_gl_inc}"])

SAVE_LIBS="${LIBS}"



if test ! -n "${ac_cv_with_gl_lib}" && test -n ${ac_cv_with_gl_dir}; then
    ac_cv_with_gl_lib="${ac_cv_with_gl_dir}/lib"
elif test ! -n "${ac_cv_with_gl_lib}"; then 
    ac_cv_with_gl_lib="."
fi

if test "$ac_cv_enable_mesagl" = no; then
    AC_CHECK_LIB(GL, main,
    [
        if test "${ac_cv_with_gl_lib}" = "."; then
            GL_LIBS="-lGL -lXext -lm"
        else
            GL_LIBS="-L${ac_cv_with_gl_lib} -lGL -lXext -lm"
        fi
        AC_SUBST(GL_LIBS)
    ],
    [
        GL_LIBS=no
    ],
    [-L$ac_cv_with_gl_lib $X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS -lXext -lm])
fi
if test "$ac_cv_enable_mesagl" = yes || test "${GL_LIBS}" = no; then
    if test "$ac_cv_enable_mesagl" = yes; then
        AC_MSG_WARN(["Will not link with standard Gl, trying to force the Mesa library..."])
    else
        AC_MSG_WARN(["Can\'t not link with Gl, trying the Mesa library..."])
    fi
    AC_CHECK_LIB(MesaGL, main,
    [
        if test "${ac_cv_with_gl_lib}" = "."; then
            GL_LIBS="-lMesaGL -lXext -lm"
        else
            GL_LIBS="-L${ac_cv_with_gl_lib} -lMesaGL -lXext -lm"
        fi
        AC_SUBST(GL_LIBS)
    ],
    [
        AC_MSG_ERROR(["You need to install \(Mesa\) OpenGL first: can\'t find either the GL or MesaGL library"])
    ], [-L$ac_cv_with_gl_lib $X_LIBS $X_PRE_LIBS -lX11 $X_EXTRA_LIBS -lXext -lm])
fi

LIBS="${SAVE_LIBS}"

AC_SUBST(GL_CFLAGS)

])


dnl #######################################
dnl EXPERIMENTAL
dnl DO NOT USE
dnl I'LL BREAK THINGS FOR SURE
dnl #######################################


AC_DEFUN(AC_SYS_DL,
[
ac_cv_dl_underscore=
ac_cv_dl_extension=
ac_cv_dl_cflags=
ac_cv_dl_lflags=
ac_cv_dl_dllcmd=
ac_cv_dl_rtld_def=
ac_cv_dl_iface=

dnl ##
dnl #if dynamic loading interface is dlopen (SunOS style)
dnl ##

AC_CHECK_HEADERS(dlfcn.h dl.h,[break],[
    AC_MSG_WARN(["Don't know how to link dynamicly on your system"])
    AC_DEFINE(NO_DYNAMIC_LINKING)
])

if test -n "${HAVE_DLFCN_H}"; then
    AC_MSG_CHECKING("RTLD_LAZY define in dlfcn.h ...")
    AC_EGREP_CPP(yes,
    [ #include <dlfcn.h>
    #ifdef RTLD_LAZY
     yes
    #endif
    ], ac_cv_dl_rtld_def=yes,ac_cv_dl_rtld_def=no)

    if test "${ac_cv_dl_rtld_def}" = "yes"; then
        AC_DEFINE_QUOTED(RTLD_LAZY,1)
    fi
    AC_MSG_RESULT("${ac_cv_dl_rtld_def}")
    
    dnl Start of dlsym needs leading underscore test

    dnl borrowed from kaffe, a free java implementation
    dnl Some dynamic library need an underscore on the loading name, some don't

    AC_CACHE_CHECK(for underscore in dlsym, ac_cv_dl_underscore,
    echo "#define _LIBC_ \"`ls /lib/lib*c.so* /usr/lib/lib*c.so.* 2>/dev/null | head -1`\"" >> confdefs.h
    AC_TRY_RUN(main()
    {[void* lib = (void*)dlopen(_LIBC_);
      if (dlsym(lib, "_printf") != 0) { exit(0); } else { exit(1); } }],
    ac_cv_dl_underscore=yes, ac_cv_dl_underscore=no, ac_cv_dl_underscore=cross))
    if test "$ac_cv_dl_underscore" = "yes"; then
        AC_DEFINE(HAVE_DLSYM_UNDERSCORE)

    dnl try to figure out compilerflags, linkerflags, etc...

    dnl ##
    dnl #End dlfcn.h
    dnl ##


elif test -n "${HAVE_DL_H}"; then
    dnl HP-UX flags
fi
])
