/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/ProviderRequestXml/ProviderCollectInstancesXml.h"

#include "Doc/ProviderRequestDoc/CProviderCollectInstancesCollectionDoc.h"
#include "Doc/ProviderRequestDoc/CProviderCollectInstancesDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderCollectInstancesCollectionXml.h"

using namespace Caf;

void ProviderCollectInstancesCollectionXml::add(
	const SmartPtrCProviderCollectInstancesCollectionDoc providerCollectInstancesCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderCollectInstancesCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerCollectInstancesCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCProviderCollectInstancesDoc> collectInstancesVal =
			providerCollectInstancesCollectionDoc->getCollectInstances();
		CAF_CM_VALIDATE_STL(collectInstancesVal);

		if (! collectInstancesVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCProviderCollectInstancesDoc> > collectInstancesIter(collectInstancesVal);
				collectInstancesIter; collectInstancesIter++) {
				const SmartPtrCXmlElement collectInstancesXml =
					thisXml->createAndAddElement("collectInstances");
				ProviderCollectInstancesXml::add(*collectInstancesIter, collectInstancesXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderCollectInstancesCollectionDoc ProviderCollectInstancesCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderCollectInstancesCollectionXml", "parse");

	SmartPtrCProviderCollectInstancesCollectionDoc providerCollectInstancesCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection collectInstancesChildrenXml =
			thisXml->findRequiredChildren("collectInstances");

		std::deque<SmartPtrCProviderCollectInstancesDoc> collectInstancesVal;
		if (! collectInstancesChildrenXml.IsNull() && ! collectInstancesChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> collectInstancesXmlIter(*collectInstancesChildrenXml);
				collectInstancesXmlIter; collectInstancesXmlIter++) {
				const SmartPtrCXmlElement collectInstancesXml = collectInstancesXmlIter->second;
				const SmartPtrCProviderCollectInstancesDoc collectInstancesDoc =
					ProviderCollectInstancesXml::parse(collectInstancesXml);
				collectInstancesVal.push_back(collectInstancesDoc);
			}
		}

		providerCollectInstancesCollectionDoc.CreateInstance();
		providerCollectInstancesCollectionDoc->initialize(
			collectInstancesVal);
	}
	CAF_CM_EXIT;

	return providerCollectInstancesCollectionDoc;
}

