# ----------------------------------------------------------------------
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#  EXAMPLE: working around problems with "regsub"
# ----------------------------------------------------------------------
#  Effective Tcl/Tk Programming
#    Mark Harrison, DSC Communications Corp.
#    Michael McLennan, Bell Labs Innovations for Lucent Technologies
#    Addison-Wesley Professional Computing Series
# ======================================================================
#  Copyright (c) 1996-1997  Lucent Technologies Inc. and Mark Harrison
# ======================================================================

# ----------------------------------------------------------------------
#  USAGE:  percent_subst <%pattern> <string> <subst>
#
#  This command is a "safe" version of regsub, for substituting
#  each occurance of <%pattern> in <string> with <subst>.  The
#  usual Tcl "regsub" command does the same thing, but also
#  converts characters like "&" and "\0", "\1", etc. that may
#  be present in the <subst> string.
#
#  Returns <string> with <subst> substituted in place of each
#  <%pattern>.
# ----------------------------------------------------------------------
proc percent_subst {percent string subst} {
    if {![string match %* $percent]} {
        error "bad pattern \"$percent\": should be %something"
    }
    regsub -all {\\|&} $subst {\\\0} subst
    regsub -all $percent $string $subst string
    return $string
}
