/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmap.h>
#include <qpixmap.h>

#include <klocale.h>
#include <kdebug.h>
#include <ktempdir.h>
#include <kgenericfactory.h>

#include "settings.h"
#include "datastruct/aux.h"
#include "datastruct/DItem.h"
#include "datastruct/DDataControl.h"
#include "datastruct/DDataItem.h"

#include "kdissasciidoc.h"

K_EXPORT_COMPONENT_FACTORY(libkdissasciidoc, kdissasciidocFactory) 
	QObject *kdissasciidocFactory::createObject(QObject *, const char *, const char *, const QStringList &) { return new kdissasciidoc; }


kdissasciidoc::kdissasciidoc() : DGenerator()
{
	m_cnt_lev1 = 0;
	m_cnt_lev2 = 0;
	m_cnt_lev3 = 0;
}

const QString kdissasciidoc::identifikation()
{
	return "kdissasciidoc";
}

const QString kdissasciidoc::fullName()
{
	return i18n("ASCII");
}

const QString kdissasciidoc::group()
{
	return i18n("Plain Text");
}

const QString kdissasciidoc::description()
{
	return i18n("This template generates a plain text document (one page without pictures). The pictures will be included in the directory created.");
}

const QString kdissasciidoc::quickstart()
{
	return i18n("Go into the directory created and view main.txt with a text editor (eg: Kate)\n");
}

void kdissasciidoc::outputLinks(DDataItem* item, QTextStream & s)
{
	for (unsigned int i=0; i<item->m_urllist.count(); i++)
	{
		if (!item->m_urllist[i].m_caption.length())
			s<<item->m_urllist[i].m_url<<"\n";
		else
			s<<item->m_urllist[i].m_caption<<" ["<<item->m_urllist[i].m_url<<"]\n";
	}
}

void kdissasciidoc::writeItem(DDataItem* item, QTextStream & s, int level)
{
	DGenerator::writeItem(item, s, level);

	if (level == 0)
	{
		// print the abstract
		s<<i18n("add a space after the:", "Abstract: ")<<wipeTags(item->m_text)<<"\n\n\n";

		outputLinks(item, s);
	}
	if (level == 1)
	{
		m_cnt_lev1++;
		m_cnt_lev2=0;

		s<<"\n"<<m_cnt_lev1<<" "<<item->m_summary.upper()<<"\n";
		s<<wipeTags(item->m_text)<<"\n";
		outputLinks(item, s);
	}
	else if (level == 2)
	{
		m_cnt_lev2++;
		m_cnt_lev3=0;

		s<<" "<<m_cnt_lev1<<"."<<m_cnt_lev2<<" "<<item->m_summary.upper()<<"\n";
		s<<wipeTags(item->m_text)<<"\n";
		outputLinks(item, s);
	}
	else if (level == 3)
	{
		m_cnt_lev3++;

		s<<"  "<<m_cnt_lev1<<"."<<m_cnt_lev2<<"."<<m_cnt_lev3<<" "<<item->m_summary.upper()<<"\n";
		s<<wipeTags(item->m_text)<<"\n";
		outputLinks(item, s);
	}
	else if (level > 3)
	{
		s<<item->m_summary<<"\n";
		s<<wipeTags(item->m_text)<<"\n";
		outputLinks(item, s);
	}	

	// write recursively the rest of the tree
	for (unsigned int i = 0; i<item->countChildren(); i++)
	{
		writeItem( (DDataItem*) m_data->Item(item->childNum(i)), s, level+1);
	}
}

bool kdissasciidoc::writeMaindoc(DDataItem *root, const QString & path)
{
	QFile textfile(path+"/main.txt");
	if (!textfile.open(IO_WriteOnly | IO_Append) )
	{
		kdWarning()<<"could not open ascii file for append :-/"<<endl;
		return false;
	}

	QTextStream u(&textfile);
	if (Settings::templatesUTF8())
	{
		u.setEncoding(QTextStream::UnicodeUTF8);
	}

	u<<i18n("add a space after the:", "Title: ")<<root->m_summary<<"\n";
	u<<i18n("add a space after the:", "Author: ")<<m_data->m_fname<<" "<<m_data->m_sname<<"\n";
	if (!m_data->m_email.isEmpty())
        {
          u<<i18n("add a space after the:", "Email: ")<<m_data->m_email<<"\n";
        }
        if (!m_data->m_company.isEmpty())
        {
          u<<i18n("add a space after the:", "Company: ")<<m_data->m_company<<"\n";
        }

	// now the central part, with text, pictures, etc ..
	writeItem(root, u, 0);

	// close the file 
	textfile.close();

	notifyDocGenerated( path+"/main.txt" );
	
	return true;
}

#include "kdissasciidoc.moc"
