/***************************************************************************
 *   Copyright (C) 2005 Sebastian Kratzert                                 *
 *   Sebastian Kratzert <krase (at) in-chemnitz.de>                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef TREELIST_FRAME_H
#define TREELIST_FRAME_H

#include <qwidget.h>

#include <kdeversion.h>

/**
 * This class provides a widget which encapsulates a KListView and a KListViewSearchLine
 *
 * @short Widget with Listview and searchline
 * @author Sebastian Kratzert <krase (at) in-chemnitz.de>
 * @version 1.0.pre4
 */

class DTreeListView;
class QToolButton;
class KListViewSearchLine;

class TreeListViewFrame : public QWidget
{
	public:
		TreeListViewFrame( QWidget *parent, const char *name = 0);
		~TreeListViewFrame();
		DTreeListView* tree() const { return m_tree; };

	private:
		DTreeListView* m_tree;
		QToolButton* clearButton;


#if KDE_IS_VERSION(3, 3, 0)
		KListViewSearchLine* m_searchLine;
#endif
};

#endif // TREELIST_FRAME_H
