/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/irmp3mod.h,v $ -- Module handling functions
 * $Id: irmp3mod.h,v 1.10 2004/08/04 05:15:47 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#ifndef MOD_H
#define MOD_H

#include <sys/types.h>
/*************************************************************************
 * MODULE FUNCTION TYPES
 */
typedef char *(*mod_initfunc_t)(void);
typedef void (*mod_deinitfunc_t)(void);
typedef char *(*mod_reloadfunc_t)(void);
typedef void (*mod_pollfunc_t)(int fd);
typedef void (*mod_updatefunc_t)(void);
typedef void (*mod_messagefunc_t)(int messagetype, char *message, const char *sender);
typedef void (*mod_sigchldfunc_t)(pid_t childpid, int status);

typedef struct mod_s {
	const char *mod_name;		// module name
	mod_deinitfunc_t deinit;	// deinit function
	mod_reloadfunc_t reload;	// reload function
	fd_set *watchfd_set;		// fd's to watch for input
	mod_pollfunc_t poll;		// called when watchfd has input
	mod_updatefunc_t update;	// called periodically
	mod_messagefunc_t message;	// called to distribute messages
	mod_sigchldfunc_t chld;		// called to handle dying children
	mod_initfunc_t init;		// called at module initialisation

	struct mod_s *next;
} mod_t;

extern mod_t *mod_list;


/*************************************************************************
 * MODULE MESSAGE DISTRIBUTION
 */
#define MSGTYPE_EVENT		0	// Events notification
#define MSGTYPE_INPUT		1	// message from input module
#define MSGTYPE_PLAYER		2	// message from player module
#define MSGTYPE_INFO		3	// Other info, answers to queries
#define MSGTYPE_QUERY		4	// Queries

typedef struct mod_message_s {
	int msgtype;			// type of message
	char *msg;			// the message itself
	const char *sender;

	struct mod_message_s *next;
} mod_message_t;

	
/*************************************************************************
 * PUBLIC MODULE FUNCTIONS (used by the modules)
 */

void mod_sendmsg (int msgtype, char *msg);
void mod_sendmsgf (int msgtype, char *msg, ...);

mod_message_t * mod_query(int msgtype, char *msg);
mod_message_t * mod_queryf(int msgtype, char *msg,...);


void free_message(mod_message_t* to_free);



pid_t system_noblock(int* std_in, int* std_out, int* std_error, char* cmd,...);
int system_block(int std_in, int* std_out, int* std_error,char* cmd,...);
/*************************************************************************
 * PRIVATE MODULE FUNCTIONS (only used by the main program)
 */
void mod_init (void);
void mod_deinit (void);
void mod_reload (void);
void mod_update (void);
void mod_sigchld (void);


#endif /* MOD_H */

/*************************************************************************
 * GLOBALS
 */

fd_set blank_fd;


/*************************************************************************
 * EOF
 */
