Summary: A unit test framework for C
Name: check
Version: 0.9.3
Release: 1
Epoch: 1
Source: http://prdownloads.sourceforge.net/check/check-%{version}.tar.gz
Group: Development/Tools
Copyright: Arien Malec <arien_malec@yahoo.com>
URL: http://check.sourceforge.net/
Prefix: %{_prefix}
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Fredrik Hugosson <hugo303@users.sourceforge.net>

%description
Check is a unit test framework for C. It features a simple interface for defining unit tests, putting little in the way of the developer. Tests are run in a separate address space, so Check can catch both assertion failures and code errors that cause segmentation faults or other signals. The output from unit tests can be used within source code editors and IDEs.

%prep
%setup

%build
./configure --prefix %{_prefix} --libdir %{_libdir}
make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}
make prefix=$RPM_BUILD_ROOT%{_prefix} libdir=$RPM_BUILD_ROOT%{_libdir} install

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
cd %{_prefix}/share/doc/%{name}-%{version}
ln -s book1.html index.html

%preun
rm %{_prefix}/share/doc/%{name}-%{version}/index.html

%files
%defattr(-,root,root)
%{_includedir}/check.h
%{_libdir}/libcheck.a
%{_prefix}/share/aclocal/check.m4
%doc %{_prefix}/share/doc/%{name}-%{version}

%changelog
* Mon Feb 28 2005 hugo303
- patch from antoine Fri Jan 28 2005
- fix lib64 for x86_64 arch (fc3)
* Wed Nov 10 2004 hugo303
- Updated for 0.9.2
- Changed Release to 1 again.
* Sat Jun  6 2004 Bill Barnard <bill@barnard-engineering.com> - 1:0.9.0-2
- Updated for 0.9.0
- Minor edits/additions to tutorial.sgml
- Removed all html files from the tarball, generated them instead
- Removed check.spec file from rpm dir, generated it instead
- Removed redundant explicit file list from %docdir section
* Fri May 24 2002 Sven Neumann <sven@convergence.de>
- Updated for 0.8.3
* Mon Oct 24 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.8.0
* Mon Aug 21 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.7.3
* Mon Aug 6 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.7.2
- Moved money example files to example subdirectory, and removed some
  confusing files
- Renamed the Tutorial files tutorial*.*
* Tue Jul 30 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.7.1
* Tue Jul 10 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.7.0
* Wed Jun 27 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.6.1
* Thu Jun 21 2001 Arien Malec <arien_malec@yahoo.com>
- Updated for 0.6.0, removed example-5.html
* Sat Jun 2 2001 Arien Malec <arien_malec@yahoo.com>
- First packaging.
