#ifndef TLINPHYSICAL_H
#define TLINPHYSICAL_H

#include <Component.h>

#include <qpixmap.h>

class TLinPhysical : public Component
{
public:
  TLinPhysical( const QPoint& center );
  virtual ~TLinPhysical();

  virtual void initComponent();
  virtual void addToAdmittanceMatrix( TReal freq, Matrix* yn );

  virtual const QString& getCatagory() const;
  virtual const QString& getName() const;
  virtual const QPixmap& getPixmap() const;

  virtual bool initSweep();

protected:
  virtual void drawSymbol(QPainter*);

private:
  static QPixmap* pixmap_;
  TReal w_;
  TReal l_;
  QString substrate_;
};

#endif
