#include <fstream.h>
#include <iostream.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_NODE 10 // the total number of nodes
#define MAX_ELEMENT 4 // the total number of elements
#define NNOL 8 // the number of nodes per element
#define NDIM 3 // the dimension of the problem (1, 2 or 3)
#define NAME "-HEX8" // the name of the elements

/* 
   Purpose: 
   --------

   Change nodes, elements for abaqus input file to tochnog input file.


   Steps:
   ------

   Compile this routine to a aba2tn executable.

   Delete everything from the abaqus input file, except for the nodes and elements.
   Delete the commas (,) in the nodes and element lists.
   So the abaqus file contains something like:
      1  0. 0.
      2  1. 0.
      3  1. 1.
      4  0. 1.
      1  1 2 3 4

   Run:
   ----

   aba2tn < abaqus.inp > tn.dat

   Email:
   -----

   Dennis Roddeman, dennis.roddeman@feat.nl
*/

int main( )

{
  long int inod=0, inol=0, iel=0, idim=0, icount=0, nodes[NNOL];
  double coord=0.;

  for ( icount=1; icount<=MAX_NODE; icount++ ) {
    cin >> inod;
    cout << "node " << inod;
    for ( idim=0; idim<NDIM; idim++ ) {
      cin >> coord;
      cout << " " << coord;
    }
    cout << "\n";
  }
  cout << "\n";

  for ( icount=1; icount<=MAX_ELEMENT; icount++ ) {
    cin >> iel;
    cout << "element " << iel << " " << NAME;
    for ( inol=0; inol<NNOL; inol++ ) cin >> nodes[inol];
    if      ( NDIM==2 ) {
      if      ( NNOL==3 ) {
        cout << " " << nodes[0] << " " << nodes[1] << " " << nodes[2];
      }
      else if ( NNOL==4 ) {
        cout << " " << nodes[0] << " " << nodes[1] << " " << nodes[3] << " " << nodes[2];
      }
    }
    else if ( NDIM==3 ) {
      if      ( NNOL==4 ) {
        cout << " " << nodes[0] << " " << nodes[1] << " " << nodes[2] << " " << nodes[3];
      }
      else if ( NNOL==8 ) {
        cout << " " << nodes[0] << " " << nodes[1] << " " << nodes[3] << " " << nodes[2] <<
                " " << nodes[4] << " " << nodes[5] << " " << nodes[7] << " " << nodes[6];
      }
    }
    cout << "\n";
  }
  cout << "\n";

  return 0;
}
