# Author:: Nathaniel Talbott.
# Copyright:: Copyright (c) 2000-2002 Nathaniel Talbott. All rights reserved.
# License:: Ruby license.

puts "Preconfiguring..."

rb_dir = config("rb-dir")
runit_dir = File.join(rb_dir, "runit")
testunit_indicator_file = File.join(rb_dir, "runit", "testunit-installed")

if (File.exists?(runit_dir))
  unless (File.exists?(testunit_indicator_file) || config('with') =~ /runit-compat/ || config('without') =~ /runit-compat/)
    puts "Skipping the install of the runit compatibility layer because a version of runit is already installed."
    @config['without'] = [config('without'), 'runit-compat'].reject{ |entry| entry == ''}.join(',')
  end
end
