/* $Id: parser.h,v 1.10 2000/10/04 17:40:54 slay Exp $ */

#ifndef __PARSER_H__
#define __PARSER_H__

#include "ipcompat.h"
#include "packet.h"
#include "misc.h"
#include "dev_struct.h"
#include "codes.h"

#ifdef SOLARIS
extern char *sys_errlist[];
#endif

/************************/
/* Global variables ... */
/************************/
char max_gbg = 0;
char *optarg;
char **l_cod_t, **cod_r, **cod_u;
u_short max_cod_r,
        max_cod_u,
        max_l_cod_t;
u_int cont_gways = 0;

u_char win_data[] = { 0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,
                      0x6b,0x6c,0x6d,0x6e,0x6f,0x70,0x71,0x72,0x73,0x74,
                      0x75,0x76,0x77,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
                      0x68,0x69
                    };

u_char unix_data[] ={ 0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,
                      0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,
                      0x1c,0x1d,0x1e,0x1f,0x20,0x21,0x22,0x23,0x24,0x25,
                      0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
                      0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37
                    };

u_char cisco_data[]={ 0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd
                     };

u_char shiva_data[]={ 0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,0xab,0xcd,
                      0x00,0x00
                    };

extern u_long gway_ip[9];        
extern struct my_pack packet;
extern u_short is_pattern;
extern u_short resolve;
extern u_short verbose;
extern u_short do_fingerprint;
extern u_short bad_cksum;
extern u_short mimic;
extern u_short set_df;
extern u_short set_rf;
extern int uid;
extern char *vers_date;
extern char *disclaimer;
extern char quiet;
extern char Quiet;
/****************************/
/* ... end global variables */
/****************************/

/***************************/
/* Functions prototypes... */
/***************************/
void add_router(struct my_pack *, u_long, u_long );
int exist_host( char *, u_long * );
int exist_code( char *, char **, int );
void parse_args( int, char **, struct my_pack * );
int are_digits( char * );
void str_tolower( char * );
int vrfy_mac( u_char * );

#ifdef DEBUG
void recorre_lista(struct my_pack *);
#endif

#if (defined(SOLARIS) && !defined(SOLARIS_27))
extern int inet_aton( char *, struct in_addr * );
#endif

extern void ip_opt_control( char * );
extern void go_out( short int, char *, ... );
extern void go_out_error( short int, char * );
extern void help( void );
extern int look4dev( struct mi_ifaz * );
extern void where2route( struct sockaddr_in * );
extern void write_log(u_short, char *,...);
/*******************************/
/* ...end functions prototypes */
/*******************************/

#endif