/***************************************************************************
                           czlib.cpp  -  description
                             -------------------
    begin                : Thu Oct 12 2004
    copyright            : (C) 2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include "czlib.h"

/** */
CZLib::CZLib()
{
	m_bInit = FALSE;
}

/** */
CZLib::~CZLib()
{
	if ( m_bInit )
		inflateEnd(&m_ZStream);
}

/** */
bool CZLib::InflateZBlock( char * in, int * inlen, char * out, int * outlen )
{
	bool res = FALSE;

	int i;
	
	if ( m_bInit == FALSE )
	{
		m_bInit = TRUE;

		m_ZStream.next_in  = 0;
		m_ZStream.avail_in = 0;
		m_ZStream.opaque   = 0;
		m_ZStream.zalloc   = 0;
		m_ZStream.zfree    = 0;

		inflateInit(&m_ZStream);
	}
	
	m_ZStream.next_in   = (Bytef*)in;
	m_ZStream.avail_in  = *inlen;
	m_ZStream.next_out  = (Bytef*)out;
	m_ZStream.avail_out = *outlen;
	m_ZStream.total_out = 0;
	
	i = inflate(&m_ZStream,Z_SYNC_FLUSH);

	if ( (i == Z_OK) || (i == Z_STREAM_END) )
	{
		*outlen = m_ZStream.total_out;
		*inlen  = *inlen - m_ZStream.avail_in;
		
		if ( i == Z_STREAM_END )
		{
			inflateEnd(&m_ZStream);
			m_bInit = FALSE;
		}
		
		res = TRUE;
	}
	else
	{
		inflateEnd(&m_ZStream);
		m_bInit = FALSE;
		*outlen = 0;
	}
/*
	printf("INFLATE: %d %d %d %d\n",
		i,
		m_ZStream.avail_in,
		m_ZStream.avail_out,
		m_ZStream.total_out );
*/
	return res;
}
