/***************************************************************************
                          cstringlist.cpp  -  description
                             -------------------
    begin                : Sat Jun 1 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define HASH_TABLE_SIZE 0x100

#include <stdio.h>
#include <string.h>

#include <dclib/dcos.h>
#include <dclib/core/clist.h>
#include "cstringlist.h"

CStringList::CStringList( int maxdepth, int depth )
{
	m_nDepth    = depth;
	m_nMaxDepth = maxdepth;
	m_nSize     = 0;
	m_nCachePos = 0;
	m_nCacheObj = 0;

	m_pList       = 0;
	m_pStringList = 0;

	if ( m_nDepth == m_nMaxDepth )
	{
		m_pList = new CList<CStringListObject>*[HASH_TABLE_SIZE];
		memset(m_pList, 0, HASH_TABLE_SIZE*sizeof(CList<CStringListObject>*));
	}
	else
	{
		m_pStringList = new CStringList*[HASH_TABLE_SIZE];
		memset(m_pStringList, 0, HASH_TABLE_SIZE*sizeof(CStringList*));
	}
}

CStringList::~CStringList()
{
	Clear();

	if ( m_nDepth == m_nMaxDepth )
		delete [] m_pList;
	else
		delete [] m_pStringList;
}

/** */
int CStringList::Add( const CString & s, CObject * object )
{
	int i = s.GetHash(m_nDepth);

	if ( m_nDepth == m_nMaxDepth )
	{
		CStringListObject * o = new CStringListObject();

		o->m_s = s;
		o->m_pObject = object;

		if ( m_pList[i] == 0 )
			m_pList[i] = new CList<CStringListObject>();

		m_pList[i]->Add(o);
	}
	else
	{
		if ( m_pStringList[i] == 0 )
			m_pStringList[i] = new CStringList(m_nMaxDepth,m_nDepth+1);
		m_pStringList[i]->Add(s,object);
	}

	m_nSize++;

	m_nCachePos = 0;
	m_nCacheObj = 0;

	return 0;
}

/** */
int CStringList::Del( const CString & s, bool bdelobj )
{
	CStringListObject * o = 0;
	int i = s.GetHash(m_nDepth);

	if ( m_nDepth == m_nMaxDepth )
	{
		if ( m_pList[i] == 0 )
			return -1;

		while( (o=m_pList[i]->Next(o)) != 0 )
		{
			if ( s == o->m_s )
				break;
		}

		if (!o)
			return -1;

		m_pList[i]->Remove(o);

		if ( (o->m_pObject) && (bdelobj) )
			delete o->m_pObject;

		delete o;

		if (m_pList[i]->Count() == 0 )
		{
			delete m_pList[i];
			m_pList[i]=0;
		}
	}
	else
	{
		if ( m_pStringList[i] == 0 )
			return -1;
		m_pStringList[i]->Del(s);
	}

	m_nSize--;

	m_nCachePos = 0;
	m_nCacheObj = 0;

	return 0;
}

/** */
int CStringList::Get( const CString & s, CObject *& object )
{
	CStringListObject * o = 0;
	int i = s.GetHash(m_nDepth);

	if ( m_nDepth == m_nMaxDepth )
	{
		if ( !m_pList[i] )
			return -1;

		while( (o=m_pList[i]->Next(o)) != 0 )
		{
			if ( s == o->m_s )
				break;
		}

		if (!o)
			return -1;

		object = o->m_pObject;
	}
	else
	{
		if ( !m_pStringList[i] )
			return -1;

		return m_pStringList[i]->Get(s,object);
	}

	return 0;
}

/** */
void CStringList::Clear()
{
	CStringListObject * o = 0;
	int i;

	for(i=0;i<HASH_TABLE_SIZE;i++)
	{
		if ( m_nDepth == m_nMaxDepth )
		{
			if(m_pList[i])
			{
				while( (o=m_pList[i]->Next(0)) != 0 )
				{
					if ( o->m_pObject )
					{
						delete o->m_pObject;
						o->m_pObject = 0;
					}

					m_pList[i]->Del(o);
				}

				delete m_pList[i];
			}
			m_pList[i]=0;
		}
		else
		{
			if(m_pStringList[i])
				delete m_pStringList[i];
			m_pStringList[i]=0;
		}
	}

	m_nSize     = 0;
	m_nCachePos = 0;
	m_nCacheObj = 0;
}

/** */
int CStringList::Next( CObject *& object )
{
	CString s;

	return Next(s,object);
}

/** */
int CStringList::Next( CString & s, CObject *& object )
{
	int i;
	long l;
	CStringListObject * obj=0;

	if ( object == 0 )
	{
		m_nCachePos = 0;
		m_nCacheObj = 0;
	}

	for(i=0,l=0;(i<HASH_TABLE_SIZE)&&(m_nSize>0);i++)
	{
		if ( m_nDepth == m_nMaxDepth )
		{
			if(!m_pList[i])
				continue;

			// fix cache after del
			if ( (object != 0) && (m_nCacheObj == 0) )
			{
				obj = 0;
				while ( (obj=m_pList[i]->Next(obj)) != 0 )
				{
					m_nCachePos++;
					if ( obj->m_pObject == object )
					{
						m_nCacheObj = obj;
						break;
					}
				}
				obj = 0;
			}
			else if ( (l<=m_nCachePos) && ((l+m_pList[i]->Count())>m_nCachePos) )
			{
				if(l==m_nCachePos)
					m_nCacheObj=0;
				obj = m_pList[i]->Next(m_nCacheObj);
				if ( obj )
					s = obj->m_s;
				else
					printf("WARNING: CStringList::Next nullpointer !\n");
				m_nCachePos++;
				m_nCacheObj = obj;
				break;
			}

			l+=m_pList[i]->Count();
		}
		else
		{
			if(!m_pStringList[i])
				continue;

			if ( (l<=m_nCachePos) && ((l+m_pStringList[i]->Count())>m_nCachePos) )
			{
				if(l==m_nCachePos)
					object=0;
				m_nCachePos++;
				return m_pStringList[i]->Next(object);
			}

			l+=m_pStringList[i]->Count();
		}
	}
	
	if ( obj )
		object = obj->m_pObject;
	else
		object = 0;

	return (obj!=0);
}
