from main import USERHOME

import shelve
import os
import threading
import string



class StateSaverServer(object):

    __STATES_FILE = os.path.join(USERHOME, "states.db")
    __SEPARATOR = ' '


    def __init__(self):

        self.__lock = threading.Lock()
        self.__db = shelve.open(self.__STATES_FILE, flag = 'c')



    def __check_key(self, key):

        assert key
        assert key[0] not in string.digits
        
        for c in key:
            assert c in (string.ascii_letters + string.digits + '_')



    def set_key(self, ident, key, value):

        self.__check_key(key)

        self.__lock.acquire()

        try:
            pk = ident + self.__SEPARATOR + key
            self.__db[pk] = value
        finally:
            self.__lock.release()



    def get_key(self, ident, key, default):

        self.__check_key(key)

        self.__lock.acquire()

        try:
            pk = ident + self.__SEPARATOR + key
            return self.__db.get(pk, default)
        finally:
            self.__lock.release()



    def remove(self, ident):

        self.__lock.acquire()

        try:
            for k in self.__db.keys():
                if k.startswith(ident + self.__SEPARATOR):
                    del self.__db[k]
        finally:
            self.__lock.release()




_SERVER = StateSaverServer()

class StateSaverClient(object):

    __slots__ = "__ident",


    def __init__(self, ident):
        self.__ident = ident

    def set_key(self, key, value):
        _SERVER.set_key(self.__ident, key, value)

    def get_key(self, key, default = None):
        return _SERVER.get_key(self.__ident, key, default)

    def remove(self):
        _SERVER.remove(self.__ident)



StateSaver = StateSaverClient
