/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM Region Manager
 * File: evms2/engine/plugins/lvm/lvm_volumes.h
 */ 

/* Functions exported from lvm_volumes.c */
extern lvm_logical_volume_t * lvm_allocate_logical_volume(lv_disk_t * lv,
							  lvm_volume_group_t * group);
extern void lvm_deallocate_logical_volume(lvm_logical_volume_t * volume);
extern int lvm_create_freespace_volume(lvm_volume_group_t * group);
extern int lvm_update_freespace_volume(lvm_volume_group_t * group);
extern int lvm_update_expanded_volume(lvm_logical_volume_t * volume,
				      lvm_lv_expand_options_t * lv_opts);
extern int lvm_update_shrunk_volume(lvm_logical_volume_t * volume,
				    u_int32_t remove_extents);
extern void lvm_build_le_maps(lvm_volume_group_t * group);
extern void lvm_check_le_maps(lvm_volume_group_t * group,
			      boolean final_call);
extern void lvm_check_for_active_volumes(lvm_volume_group_t * group,
					 boolean final_call);
extern int lvm_export_logical_volumes(list_anchor_t regions,
				      boolean final_call);
extern int lvm_get_freespace_volume(list_anchor_t freespace_region_list,
				    lvm_logical_volume_t ** freespace_volume);
extern int lvm_check_lv_name(char * name,
			     lvm_volume_group_t * group);
extern int lvm_check_lv_size(u_int32_t * lv_size,
			     u_int32_t pe_size);
extern int lvm_compare_lv_size_and_extents(u_int32_t * lv_size,
					   u_int32_t * extents,
					   u_int32_t pe_size);
extern void lvm_check_stripe_size(u_int32_t * stripe_size,
				  u_int32_t pe_size);
extern int lvm_initialize_new_lv(lvm_lv_create_options_t * lv_opts,
				 lvm_volume_group_t * group,
				 lv_disk_t ** lv);
extern int lvm_can_expand_volume(lvm_logical_volume_t * volume);
extern int lvm_can_shrink_volume(lvm_logical_volume_t * volume);
extern int lvm_check_available_extents(lvm_volume_group_t * group,
				       lvm_lv_create_options_t * lv_opts);
extern int lvm_check_available_expand_extents(lvm_logical_volume_t * volume,
					      lvm_lv_expand_options_t * lv_opts);
extern int lvm_allocate_extents_to_volume(lvm_logical_volume_t * volume,
					  lvm_lv_create_options_t * lv_opts);
extern int lvm_allocate_expand_extents_to_volume(lvm_logical_volume_t * volume,
						 lvm_lv_expand_options_t * lv_opts);
extern void lvm_deallocate_extents_from_volume(lvm_logical_volume_t * volume);
extern void lvm_discard_extents_from_volume(lvm_logical_volume_t * volume);
extern void lvm_deallocate_shrink_extents_from_volume(lvm_logical_volume_t * volume,
						      u_int32_t remove_extents);
extern void lvm_clear_lv(lv_disk_t * lv);
extern dm_target_t * lvm_build_volume_targets(lvm_logical_volume_t * volume);
extern inline int lvm_le_is_valid(lvm_logical_volume_t * volume, u_int32_t le);
extern inline int lvm_le_is_scheduled_for_move(lvm_logical_extent_t * le);
extern int lvm_volume_is_on_pv(lvm_logical_volume_t * volume,
			       lvm_physical_volume_t * pv_entry);
extern boolean lvm_volume_is_online(lvm_logical_volume_t * volume);
extern void switch_region_name(storage_object_t *region);
extern void remove_old_region_name(storage_object_t *region);
extern int rename_region(storage_object_t *region);
extern void lvm_set_new_volume_name(lvm_logical_volume_t * volume,
				    char * lv_name);

