/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdos.so
 *
 *   File: discovery.c
 */
#ifndef OS2DLAT_HEADER
#define OS2DLAT_HEADER


DLA_Table_Sector *  Allocate_Dlat( LOGICALDISK *ld );

DLA_Entry *         Get_Dlat_Entry_Matching_DiskSegment( DISKSEG *ebr, DISKSEG *seg );

int                 Add_DiskSegment_To_Dlat( LOGICALDISK *ld, DLA_Table_Sector *dlat, DISKSEG *seg );

DLA_Table_Sector *  Read_Dlat_Sector( LOGICALDISK *ld,  lba_t ebr_lba  );

int                 Write_Dlat_Sector( LOGICALDISK *ld,  DISKSEG *boot_seg, DISKSEG *parent, boolean backup );

boolean             isa_os2_partitioned_disk( LOGICALDISK        *ld,
                                              Master_Boot_Record *mbr,
                                              lba_t               mbr_lba,
                                              lba_t               extd_partition_lba );

#endif
