/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbsd.so
 *
 *   File: helpers.h
 */
#ifndef _BSD_HELPERS_HEADER
	#define _BSD_HELPERS_HEADER 1


DISKSEG *           allocate_bsd_segment( LOGICALDISK *object );

void                free_bsd_segment( DISKSEG *seg);

DISKSEG *           create_bsd_metadata_segment( storage_object_t  *object,
						 lba_t              start,
						 sector_count_t     size,                                                 
						 u_int32_t          flags );

DISKSEG *           create_bsd_data_segment( LOGICALDISK        *ld,
					     lba_t               start,
					     sector_count_t      size, 
					     bsd_partition_t    *p,
					     u_int32_t           minor,
					     u_int32_t           object_flags );

int                 remove_bsd_segment_from_list( list_anchor_t  seglist, DISKSEG *seg );

int                 insert_bsd_segment_into_list( list_anchor_t  seglist, DISKSEG *seg);

int                 insert_bsd_segment_into_ordered_list( list_anchor_t  seglist, DISKSEG *seg);

void                prune_bsd_seg_objects_from_list( list_anchor_t list );



static inline LOGICALDISK * get_logical_disk( storage_object_t *object )
{
	LOGICALDISK  *ld=NULL;

	if (object) {

		if (object->object_type == DISK) {
			ld = object;
		}
		else if (object->object_type == SEGMENT && object->plugin == bsd_plugin) {

			if (object->private_data) {

				if ( ((seg_private_data_t *)object->private_data)->signature == BSD_SEGMENT_PDATA_SIGNATURE ) {

					ld = ((seg_private_data_t *)object->private_data)->logical_disk;

				}

			}

		}

	}

	return ld;
}


static inline boolean isa_bsd_logical_disk( storage_object_t *ld )
{
	disk_private_data_t *pdata;

	if (ld) {

		pdata = get_bsd_disk_private_data(ld);

		if (pdata) {
			return TRUE;
		}

	}

	return FALSE;
}


static inline boolean isa_bsd_segment( storage_object_t *object )
{
	seg_private_data_t *pdata;

	if (object) {

		pdata = (seg_private_data_t *) object->private_data;

		if (pdata) {

			if ( (object->plugin == bsd_plugin) &&                        
			     (pdata->signature == BSD_SEGMENT_PDATA_SIGNATURE)) {
				return TRUE;
			}

		}

	}

	return FALSE;
}


static inline void display_bsd_disklabel( bsd_disklabel_t  *disk_label )
{
	if (disk_label) {
		LOG_DEBUG("BSD Disk Label Info:\n");
		LOG_DEBUG("     geometry:  C= %d   H= %d  S= %d\n", 
			  DISK_TO_CPU32(disk_label->d_ncylinders), 
			  DISK_TO_CPU32(disk_label->d_ntracks), 
			  DISK_TO_CPU32(disk_label->d_nsectors));
		LOG_DEBUG("     sector size = %d\n", 
			  DISK_TO_CPU32(disk_label->d_secsize) );
		LOG_DEBUG("     number of bsd partition table entries: %d\n", 
			  DISK_TO_CPU16(disk_label->d_npartitions) );
		LOG_DEBUG("     size of boot area at sn0 in bytes    : %d\n", 
			  DISK_TO_CPU32(disk_label->d_bbsize) );
		LOG_DEBUG("     max size of fs superblock in bytes   : %d\n", 
			  DISK_TO_CPU32(disk_label->d_sbsize) );
	}
	else {
		LOG_ERROR("display_bsd_header: error, null ptr arg\n");
	}
}


static inline boolean disk_move_pending( storage_object_t *object )
{               
	LOGICALDISK        *ld=get_logical_disk(object);        
	disk_private_data_t *disk_pdata=NULL;

	if ( ld ) {

		disk_pdata = get_bsd_disk_private_data(ld);

		if (disk_pdata) {

			if (disk_pdata->flags & DISK_HAS_MOVE_PENDING) {
				return TRUE;
			}

		}

	}

	return FALSE;
}

#endif

