/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: volume.h
 *
 */

#include "lists.h"

/* Structure for keeping track of volumes that have been renamed */
/* This structure includes the links to put it into a list as if
 * the structure was an element in the list.  It saves the risk of
 * a memory allocation failure when allocating an element to put
 * into the list.
 */
typedef struct rename_volume_s {
	element_t element;
	logical_volume_t * volume;
	char old_vol_name[EVMS_VOLUME_NAME_SIZE+1];
	char new_vol_name[EVMS_VOLUME_NAME_SIZE+1];
} rename_volume_t;


/* External APIs provided by volume.c */

extern int evms_can_create_volume(object_handle_t object);

extern int evms_can_create_compatibility_volume(object_handle_t object);

extern int evms_can_set_volume_name(object_handle_t volume);

extern int evms_create_volume(object_handle_t object,
                              char          * name);

extern int evms_set_volume_name(object_handle_t volume,
                                char          * name);

extern int evms_create_compatibility_volume(object_handle_t object);

extern int evms_can_mkfs(object_handle_t volume,
                         plugin_handle_t fsim);

extern int evms_can_unmkfs(object_handle_t volume);

extern int evms_can_fsck(object_handle_t volume);

extern int evms_mkfs(object_handle_t  volume,
                     plugin_handle_t  fsim,
                     option_array_t * options);

extern int evms_unmkfs(object_handle_t volume);

extern int evms_fsck(object_handle_t  volume,
                     option_array_t * options);

extern int evms_get_volume_list(object_handle_t       fsim_handle,
				object_handle_t       disk_group,
				volume_search_flags_t flags,
				handle_array_t    * * volume_handle_list);

extern int evms_can_convert_to_evms_volume(object_handle_t volume);

extern int evms_convert_to_evms_volume(object_handle_t volume, char * name);

extern int evms_can_convert_to_compatibility_volume(object_handle_t volume);

extern int evms_convert_to_compatibility_volume(object_handle_t volume);

extern int evms_can_add_feature_to_volume(object_handle_t volume,
                                          plugin_handle_t feature);

extern int evms_add_feature_to_volume(object_handle_t  volume,
                                      plugin_handle_t  feature,
                                      option_array_t * options);

extern int evms_can_mount(object_handle_t volume_handle);

extern int evms_mount(object_handle_t volume_handle,
		      char          * mount_point,
		      char          * options);

extern int evms_can_unmount(object_handle_t volume_handle);

extern int evms_unmount(object_handle_t volume_handle);

extern int evms_can_remount(object_handle_t volume_handle);

extern int evms_remount(object_handle_t volume_handle,
			char          * options);

/* Internal functions to share with other Engine source modules */
extern boolean is_kernel_volume_mounted(logical_volume_t * vol,
                                        debug_level_t      log_level);

extern boolean is_mounted(char *   volume_name,
			  int      dev_major,
			  int      dev_minor,
			  char * * mount_name);

extern boolean is_volume_mounted(logical_volume_t * volume);

extern boolean is_volume_opened(logical_volume_t * volume);

extern int make_volume(storage_object_t * obj,
		       char             * name);

extern int add_volume_feature_header_to_object(storage_object_t * object);

extern char * get_volume_prefix(storage_container_t * disk_group);

extern int make_dm_map_for_volume(logical_volume_t * vol);

extern int make_evms_volume_for_object(storage_object_t * obj,
				       char             * vol_name,
				       u_int64_t          serial);

extern int make_compatibility_volume_for_object(storage_object_t * obj);
