/* $Id: netsrvlist.c,v 1.10 2004/05/20 17:50:09 stpohle Exp $
 * netsrvlist.c - shows a list of possible servers.*/
 
#include "basic.h"
#include "bomberclone.h"
#include "basic.h"
#include "bomberclone.h"
#include "network.h"
#include "menu.h"
#include "ogcache-client.h"

_charlist srvlst_text[MAX_SRVLIST];
struct __srvlst_entry {
	char host[LEN_SERVERNAME];
	char port[LEN_PORT];
	char gamename[LEN_GAMENAME];
	int maxplayers;
	int curplayers;
	int ai_family;
} srvlst_dat[MAX_SRVLIST];
int srvlst_cnt = 0;



/* will build up our srvlst list with 
 * all servers we have in there */
void srvlist_rebuildlist () {
	int ogclst, i;
	char text[255];
	
	d_printf ("srvlist_rebuildlist\n");

	/* delete the whole list */
	for (i = 0; i < MAX_SRVLIST; i++) {
		srvlst_text[i].text[0] = 0;
		srvlst_text[i].next = NULL;
		srvlst_dat[i].host[0] = 0;
		srvlst_dat[i].port[0] = 0;
		srvlst_dat[i].gamename[0] = 0;
	}

	srvlst_cnt = 0;
		
	/* add the OpenGameCache Entrys */
	if (bman.notifygamemaster) {
		for (ogclst = 0; (ogclst < MAX_OGC_ENTRYS && srvlst_cnt < MAX_SRVLIST); ogclst++)
			if (ogc_array[ogclst].serial != -1) {
				srvlst_dat[srvlst_cnt].host[0] = 0;
				srvlst_dat[srvlst_cnt].port[0] = 0;
				srvlst_dat[srvlst_cnt].gamename[0] = 0;
				
				srvlst_dat[srvlst_cnt].ai_family = ogc_array[ogclst].ai_family;
				strncpy (srvlst_dat[srvlst_cnt].host,ogc_array[ogclst].host, LEN_SERVERNAME);
				strncpy (srvlst_dat[srvlst_cnt].port,ogc_array[ogclst].port, LEN_PORT);
				strncpy (srvlst_dat[srvlst_cnt].gamename,ogc_array[ogclst].gamename, LEN_GAMENAME);
				srvlst_cnt++;
			}
	}
	if (srvlst_cnt >= MAX_SRVLIST)
		d_fatal ("srvlist_rebuildlist : srvlst_cnt >= MAX_SRVLIST\n");
	
	/* add local server list 
	 *    - this will have to be finished later -*/
	

	/* add broadcasted list
	 *    - this will have to be finished later -*/
	
	/* make the list viewable */
	for (i = 0; i < srvlst_cnt; i++) {
		if (srvlst_dat[i].gamename[0] != 0)  /* gamename is present */
			sprintf (text, "%s", srvlst_dat[i].gamename);
		else
			sprintf (text, "%s:%s", srvlst_dat[i].host, srvlst_dat[i].port);
		strncpy (srvlst_text[i].text, text, LEN_CHARENTRY);
	}
	if (srvlst_cnt == 0)
		strcpy (srvlst_text[0].text, "No Servers Found");
	charlist_fillarraypointer (srvlst_text, srvlst_cnt);
	
};



/* show a list of servers you can select */
void net_getserver () {
    int menuselect = 0, entry = 0;
	_charlist *sel_entry = &srvlst_text[0];
	_menu *menu;
	
	d_printf ("net_getserver\n");
	
	if (bman.servername[0] != 0)
		return; // a server has already been selected
	if (bman.notifygamemaster)
		ogc_browsestart ();

	menu = menu_new ("Join a Game", 500, 400);
	menu_create_list (menu, "Host a Game", -1, 50, 475, 250, srvlst_text, &sel_entry, 1);
	menu_create_entry (menu, "IP :", -1, 320, 475, bman.servername, LEN_SERVERNAME+LEN_PORT + 2, MENU_entrytext, 2);	
	menu_create_button (menu, "OK", -1, 350, 150, 0);
	menu_focus_id (menu, 1);
	
    while (menuselect != -1 && bman.state != GS_quit) {
		srvlist_rebuildlist ();
		menu_reload (menu);
        menuselect = menu_loop (menu);
		
        switch (menuselect) {
		case (0):				// Ok Join Selected Game
			menuselect = -1;
			break;
        case (1):              // Join a Game
			entry = sel_entry - &srvlst_text[0];
            d_printf ("Selected Entry (%d) %s:%s Game:%s\n", entry, srvlst_dat[entry].host, srvlst_dat[entry].port, srvlst_dat[entry].gamename);
			if (srvlst_dat[entry].host[0] != 0 
				&& srvlst_dat[entry].port[0] != 0 
			    && srvlst_dat[entry].gamename[0] != 0) {  /* test if there was a selection */
				  bman.net_ai_family = srvlst_dat[entry].ai_family;
				  sprintf (bman.servername, "%s:%s", srvlst_dat[entry].host, srvlst_dat[entry].port);
			  	  menu_focus_id (menu, 0);
			}
            break;
        }
    }

	if (bman.notifygamemaster)
		ogc_browsestop ();
	menu_delete (menu);
};
