/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.IOException;

import nz.net.catalyst.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;

/**
 * EXPERIMENTAL Utility Functions
 * 
 * NOT TO BE USED IN PRODUCTION
 * 
 * 
 * 
 */

public class EXPERIMENTAL implements IPackage, Constants {
  private final Transmission input;
  private Application application;

  EXPERIMENTAL(Transmission transmission) {
    input = transmission;
  }

  /**
   * 
   * Summary:
   * 
   * Create new directory from "Target" parameter.
   * 
   * Merge specified application's index into above directory. 
   * 
   * @return
   */

  Transmission execute() {
    long queryStart = System.currentTimeMillis();
    Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
    response.setSerial(input.getSerial());

    String appName = input.get(APPLICATION, NO_APP);

    try {
      application = Application.getAppOrDefault(appName);
    } catch (ApplicationMissingException e) {
      return error(e.getMessage());
    }
	
	try {
	    input.setApplication(application);
	    Analyzer analyzer   = Application.getAnalyzer(input); // Don't care which one
	    File luceneStoreDir = Application.getIndexDirectory(application);
	
		if (luceneStoreDir == null) {
			return error("Application's Index Directory could not be retreived.");
		}
	    Log.info(" Index Directory: " + luceneStoreDir );
	    
		WriterControl writerControl      = WriterControl.getWriterControl(luceneStoreDir, analyzer);
		
		Log.info("EXP: got WriterControl.");
		
		IndexWriter writer = writerControl.getIndexWriter();
		
		Log.info("EXP: got IndexWriter.");
	
		Log.info("EXP: about to sleep for 2 minutes.");
	
		Thread.sleep(1000 * 60 * 2);
	
		Log.info("EXP: done sleeping");
		
		writerControl.release();
		
		Log.info("EXP: WriterControl.release'd, exiting.");
	} catch (IOException e) {
		Log.error("EXP: IOError on index writer open");
	} catch (InterruptedException e) {
		Log.error("EXP: Interrupted while sleeping!");
	}
	
    long afterWriterClose = System.currentTimeMillis();
    response.add("Open",  "blah");
    return response;
}

  /**
   * Build an error response for sending back to the client.
   *
   * @param message The text of the error message
   * @return An INDEX-RESPONSE Transmission
   */

  private Transmission error(String message)
  {
    Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
    response.setSerial(input.getSerial());
    response.add(ERROR, message);
    Log.error("ERROR during BACKUP: " + message);
    return response;
  }
}
