/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;

public class RtException
extends RuntimeException {
    private Throwable origin = null;

    public RtException() {
    }

    public RtException(String message) {
        super(message);
        System.err.println("Error occured at " + new Date());
        System.err.println("\tMessage: " + message);
    }

    public RtException(String message, Throwable origin) {
        super(message);
        this.origin = origin;
    }

    public RtException(Throwable origin) {
        this.origin = origin;
    }

    public Throwable getOrigin() {
        return this.origin;
    }

    public synchronized Throwable initOrigin(Throwable origin) {
        if (this.origin != null) {
            throw new IllegalStateException("Can't overwrite origin");
        }
        if (origin == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.origin = origin;
        return this;
    }

    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.origin != null && this.origin != this) {
                s.print("due to: ");
                this.origin.printStackTrace(s);
            }
        }
    }

    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.origin != this && this.origin != this) {
                s.print("due to: ");
                this.origin.printStackTrace(s);
            }
        }
    }
}

