/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSListSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    ValidationState fValidationState = new ValidationState();
    private static final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    private StringBuffer fPattern = new StringBuffer();
    private final XSFacets xsFacets = new XSFacets();

    XSDAbstractTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        this.fSchemaHandler = xSDHandler;
        this.fAttrChecker = xSAttributeChecker;
    }

    void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fValidationState.setExtraChecking(false);
        this.fValidationState.setSymbolTable(symbolTable);
    }

    void traverseAnnotationDecl(Element element, Object[] objectArray, boolean bl, XSDocumentInfo xSDocumentInfo) {
        Object[] objectArray2 = this.fAttrChecker.checkAttributes(element, bl, xSDocumentInfo);
        this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = DOMUtil.getLocalName(element2);
            if (!string.equals(SchemaSymbols.ELT_APPINFO) && !string.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportSchemaError("src-annotation", null, element2);
            }
            objectArray2 = this.fAttrChecker.checkAttributes(element2, true, xSDocumentInfo);
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
    }

    FacetInfo traverseFacets(Element element, Object[] objectArray, String string, XSSimpleType xSSimpleType, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray2;
        int n = 0;
        short s = 0;
        boolean bl = this.containsQName(xSSimpleType);
        Vector<String> vector = new Vector<String>();
        Vector<Object[]> vector2 = bl ? new Vector<Object[]>() : null;
        int n2 = 0;
        while (element != null) {
            Object[] objectArray3;
            Object object;
            objectArray2 = null;
            String string2 = DOMUtil.getLocalName(element);
            if (string2.equals(SchemaSymbols.ELT_ENUMERATION)) {
                Object object2;
                objectArray2 = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo, bl);
                object = (String)objectArray2[XSAttributeChecker.ATTIDX_VALUE];
                objectArray3 = (Object[])objectArray2[XSAttributeChecker.ATTIDX_ENUMNSDECLS];
                if (xSSimpleType.getVariety() == 1 && ((XSAtomicSimpleType)xSSimpleType).getPrimitiveKind() == 19) {
                    xSDocumentInfo.fValidationContext.setNamespaceSupport((NamespaceSupport)objectArray3);
                    try {
                        object2 = (QName)fQNameDV.validate((String)object, xSDocumentInfo.fValidationContext, null);
                        this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 6, (QName)object2, element);
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportSchemaError(invalidDatatypeValueException.getKey(), invalidDatatypeValueException.getArgs(), element);
                    }
                    xSDocumentInfo.fValidationContext.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                }
                vector.addElement((String)object);
                if (bl) {
                    vector2.addElement(objectArray3);
                }
                if ((object2 = DOMUtil.getFirstChildElement(element)) != null) {
                    if (DOMUtil.getLocalName((Node)object2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl((Element)object2, objectArray2, false, xSDocumentInfo);
                        object2 = DOMUtil.getNextSiblingElement((Node)object2);
                    }
                    if (object2 != null && DOMUtil.getLocalName((Node)object2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{"enumeration", "(annotation?)"}, (Element)object2);
                    }
                }
            } else if (string2.equals(SchemaSymbols.ELT_PATTERN)) {
                objectArray2 = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
                if (this.fPattern.length() == 0) {
                    this.fPattern.append((String)objectArray2[XSAttributeChecker.ATTIDX_VALUE]);
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append((String)objectArray2[XSAttributeChecker.ATTIDX_VALUE]);
                    object = DOMUtil.getFirstChildElement(element);
                    if (object != null) {
                        if (DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl((Element)object, objectArray2, false, xSDocumentInfo);
                            object = DOMUtil.getNextSiblingElement((Node)object);
                        }
                        if (object != null && DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            objectArray3 = new Object[]{"Pattern facet has more than one annotation."};
                            this.reportSchemaError("s4s-elt-must-match", new Object[]{"pattern", "(annotation?)"}, (Element)object);
                        }
                    }
                }
            } else {
                if (string2.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    n2 = 2;
                } else if (string2.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    n2 = 4;
                } else if (string2.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    n2 = 128;
                } else if (string2.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    n2 = 64;
                } else if (string2.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    n2 = 256;
                } else if (string2.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    n2 = 512;
                } else if (string2.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    n2 = 1024;
                } else if (string2.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    n2 = 2048;
                } else if (string2.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    n2 = 32;
                } else {
                    if (!string2.equals(SchemaSymbols.ELT_LENGTH)) break;
                    n2 = 1;
                }
                objectArray2 = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
                if ((n & n2) != 0) {
                    this.reportSchemaError("src-single-facet-value", new Object[]{"The facet '" + string2 + "' is defined more than once."}, element);
                } else if (objectArray2[XSAttributeChecker.ATTIDX_VALUE] != null) {
                    n = (short)(n | n2);
                    if (((Boolean)objectArray2[XSAttributeChecker.ATTIDX_FIXED]).booleanValue()) {
                        s = (short)(s | n2);
                    }
                    switch (n2) {
                        case 2: {
                            this.xsFacets.minLength = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 4: {
                            this.xsFacets.maxLength = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 128: {
                            this.xsFacets.maxExclusive = (String)objectArray2[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 64: {
                            this.xsFacets.maxInclusive = (String)objectArray2[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 256: {
                            this.xsFacets.minExclusive = (String)objectArray2[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 512: {
                            this.xsFacets.minInclusive = (String)objectArray2[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 1024: {
                            this.xsFacets.totalDigits = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 2048: {
                            this.xsFacets.fractionDigits = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 32: {
                            this.xsFacets.whiteSpace = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).shortValue();
                            break;
                        }
                        case 1: {
                            this.xsFacets.length = ((XInt)objectArray2[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                        }
                    }
                }
                object = DOMUtil.getFirstChildElement(element);
                if (object != null) {
                    if (DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl((Element)object, objectArray2, false, xSDocumentInfo);
                        object = DOMUtil.getNextSiblingElement((Node)object);
                    }
                    if (object != null && DOMUtil.getLocalName((Node)object).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{string2, "(annotation?)"}, (Element)object);
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(objectArray2, xSDocumentInfo);
            element = DOMUtil.getNextSiblingElement(element);
        }
        if (vector.size() > 0) {
            n = (short)(n | 0x10);
            this.xsFacets.enumeration = vector;
            this.xsFacets.enumNSDecls = vector2;
        }
        if (this.fPattern.length() != 0) {
            n = (short)(n | 8);
            this.xsFacets.pattern = this.fPattern.toString();
        }
        this.fPattern.setLength(0);
        objectArray2 = new FacetInfo();
        objectArray2.facetdata = this.xsFacets;
        objectArray2.nodeAfterFacets = element;
        objectArray2.fPresentFacets = (short)n;
        objectArray2.fFixedFacets = s;
        return objectArray2;
    }

    private boolean containsQName(XSSimpleType xSSimpleType) {
        if (xSSimpleType.getVariety() == 1) {
            short s = ((XSAtomicSimpleType)xSSimpleType).getPrimitiveKind();
            return s == 18 || s == 19;
        }
        if (xSSimpleType.getVariety() == 2) {
            return this.containsQName(((XSListSimpleType)xSSimpleType).getItemType());
        }
        if (xSSimpleType.getVariety() == 3) {
            XSSimpleType[] xSSimpleTypeArray = ((XSUnionSimpleType)xSSimpleType).getMemberTypes();
            int n = 0;
            while (n < xSSimpleTypeArray.length) {
                if (this.containsQName(xSSimpleTypeArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    Element traverseAttrsAndAttrGrps(Element element, XSAttributeGroupDecl xSAttributeGroupDecl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object object;
        String string;
        Element element2 = null;
        XSAttributeGroupDecl xSAttributeGroupDecl2 = null;
        XSAttributeUse xSAttributeUse = null;
        element2 = element;
        while (element2 != null) {
            string = DOMUtil.getLocalName(element2);
            if (string.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                xSAttributeUse = this.fSchemaHandler.fAttributeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
                if (xSAttributeUse == null) break;
                if (xSAttributeGroupDecl.getAttributeUse(xSAttributeUse.fAttrDecl.fTargetNamespace, xSAttributeUse.fAttrDecl.fName) == null) {
                    object = xSAttributeGroupDecl.addAttributeUse(xSAttributeUse);
                    if (object != null) {
                        this.reportSchemaError("cvc-complex-type.5.3", new Object[]{xSAttributeUse.fAttrDecl.fName, object}, element2);
                    }
                } else {
                    this.reportSchemaError("ct-props-correct.4", new Object[]{"Duplicate attribute " + xSAttributeUse.fAttrDecl.fName + " found "}, element2);
                }
            } else {
                if (!string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (xSAttributeGroupDecl2 = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar)) == null) break;
                object = xSAttributeGroupDecl2.getAttributeUses();
                XSAttributeUse xSAttributeUse2 = null;
                int n = 0;
                while (n < ((XSAttributeUse[])object).length) {
                    xSAttributeUse2 = xSAttributeGroupDecl.getAttributeUse(object[n].fAttrDecl.fTargetNamespace, object[n].fAttrDecl.fName);
                    if (xSAttributeUse2 == null) {
                        String string2 = xSAttributeGroupDecl.addAttributeUse(object[n]);
                        if (string2 != null) {
                            this.reportSchemaError("cvc-complex-type.5.3", new Object[]{object[n].fAttrDecl.fName, string2}, element2);
                        }
                    } else {
                        this.reportSchemaError("ct-props-correct.4", new Object[]{"Duplicate attribute " + xSAttributeUse2.fAttrDecl.fName + " found "}, element2);
                    }
                    ++n;
                }
                if (xSAttributeGroupDecl2.fAttributeWC != null) {
                    if (xSAttributeGroupDecl.fAttributeWC == null) {
                        xSAttributeGroupDecl.fAttributeWC = xSAttributeGroupDecl2.fAttributeWC;
                    } else {
                        xSAttributeGroupDecl.fAttributeWC = xSAttributeGroupDecl.fAttributeWC.performIntersectionWith(xSAttributeGroupDecl2.fAttributeWC, xSAttributeGroupDecl.fAttributeWC.fProcessContents);
                        if (xSAttributeGroupDecl.fAttributeWC == null) {
                            this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"}, element2);
                        }
                    }
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        if (element2 != null && (string = DOMUtil.getLocalName(element2)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            object = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(element2, xSDocumentInfo, schemaGrammar);
            if (xSAttributeGroupDecl.fAttributeWC == null) {
                xSAttributeGroupDecl.fAttributeWC = object;
            } else {
                xSAttributeGroupDecl.fAttributeWC = object.performIntersectionWith(xSAttributeGroupDecl.fAttributeWC, object.fProcessContents);
                if (xSAttributeGroupDecl.fAttributeWC == null) {
                    this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"}, element2);
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        return element2;
    }

    void reportSchemaError(String string, Object[] objectArray, Element element) {
        this.fSchemaHandler.reportSchemaError(string, objectArray, element);
    }

    void checkNotationType(String string, XSTypeDecl xSTypeDecl, Element element) {
        if (xSTypeDecl.getXSType() == 2 && ((XSSimpleType)xSTypeDecl).getVariety() == 1 && ((XSAtomicSimpleType)xSTypeDecl).getPrimitiveKind() == 19 && (((XSSimpleType)xSTypeDecl).getDefinedFacets() & 0x10) == 0) {
            this.reportSchemaError("dt-enumeration-notation", new Object[]{string}, element);
        }
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl xSParticleDecl, String string, Element element, int n, long l) {
        Object object;
        boolean bl;
        int n2 = xSParticleDecl.fMinOccurs;
        int n3 = xSParticleDecl.fMaxOccurs;
        boolean bl2 = (l & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean bl3 = (l & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean bl4 = (n & 1) != 0;
        boolean bl5 = (n & 8) != 0;
        boolean bl6 = (n & 2) != 0;
        boolean bl7 = bl = (n & 4) != 0;
        if (!(!bl || bl2 && bl3)) {
            object = new Object[]{element.getAttribute(SchemaSymbols.ATT_NAME), string};
            this.reportSchemaError("MinMaxOnGroupChild", (Object[])object, element);
            n3 = 1;
            n2 = 1;
        }
        if (n2 == 0 && n3 == 0) {
            xSParticleDecl.fType = 0;
            return null;
        }
        if (bl4 || bl6 || bl5) {
            Object[] objectArray;
            if ((bl5 || bl6 || n2 != 0) && n2 != 1) {
                object = bl4 ? "BadMinMaxForAllElem" : (bl5 ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                objectArray = new Object[]{"minOccurs", Integer.toString(n2)};
                this.reportSchemaError((String)object, objectArray, element);
                n2 = 1;
            }
            if (n3 != 1) {
                object = bl4 ? "BadMinMaxForAllElem" : (bl5 ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                objectArray = new Object[]{"maxOccurs", Integer.toString(n3)};
                this.reportSchemaError((String)object, objectArray, element);
                n3 = 1;
            }
        }
        xSParticleDecl.fMaxOccurs = n2;
        xSParticleDecl.fMaxOccurs = n3;
        return xSParticleDecl;
    }

    class FacetInfo {
        XSFacets facetdata;
        Element nodeAfterFacets;
        short fPresentFacets;
        short fFixedFacets;

        FacetInfo() {
        }
    }
}

