/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.Vector;

class CbColorWindow
extends FixedFrame
implements CbButtonCallback {
    CbColorWindowCallback callback;
    Color col;
    Vector pal;
    static Vector defpal = new Vector();
    Image[] palimg = new Image[12];
    CbButton[] palbut = new CbButton[12];
    int curpal = -1;
    CbButton ok;
    CbButton cancel;
    CbColorWindowCube ccube;

    CbColorWindow(Color color, CbColorWindowCallback cbColorWindowCallback) {
        int n;
        this.col = color;
        this.callback = cbColorWindowCallback;
        this.pal = this.callback.palette(this);
        if (this.pal == null) {
            this.pal = defpal;
        } else if (this.pal.size() == 0) {
            n = 0;
            while (n < 12) {
                this.pal.addElement(defpal.elementAt(n));
                ++n;
            }
        }
        n = 0;
        while (n < 12) {
            this.palimg[n] = Util.createImage(16, 16);
            this.updatePal(n);
            ++n;
        }
        this.setLayout(new BorderLayout());
        GrayPanel grayPanel = new GrayPanel();
        grayPanel.setLayout(new FlowLayout(2));
        this.ok = new CbButton("Ok", (CbButtonCallback)this);
        grayPanel.add(this.ok);
        this.cancel = new CbButton("Cancel", (CbButtonCallback)this);
        grayPanel.add(this.cancel);
        this.add("South", grayPanel);
        BorderPanel borderPanel = new BorderPanel(1);
        borderPanel.setLayout(new BorderLayout());
        GrayPanel grayPanel2 = new GrayPanel();
        grayPanel2.setLayout(new GridLayout(2, 6, 4, 4));
        CbButtonGroup cbButtonGroup = new CbButtonGroup();
        int n2 = 0;
        while (n2 < 12) {
            this.palbut[n2] = new CbButton(this.palimg[n2], (CbButtonCallback)this);
            grayPanel2.add(this.palbut[n2]);
            this.palbut[n2].setGroup(cbButtonGroup);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 12) {
            if (color.equals(this.pal.elementAt(n3))) {
                this.curpal = n3;
                this.palbut[n3].select();
                break;
            }
            ++n3;
        }
        borderPanel.add("South", grayPanel2);
        this.ccube = new CbColorWindowCube(this);
        borderPanel.add("North", this.ccube);
        this.add("Center", borderPanel);
        this.pack();
        this.show();
        this.setTitle("Choose Color...");
    }

    void updatePal(int n) {
        Graphics graphics = this.palimg[n].getGraphics();
        graphics.setColor((Color)this.pal.elementAt(n));
        graphics.fillRect(0, 0, 16, 16);
        if (this.palbut[n] != null) {
            this.palbut[n].repaint();
        }
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.ok) {
            this.callback.chosen(this, this.col);
            super.dispose();
            return;
        }
        if (cbButton == this.cancel) {
            this.dispose();
            return;
        }
        int n = 0;
        while (n < 12) {
            if (cbButton == this.palbut[n]) {
                this.curpal = n;
                this.col = (Color)this.pal.elementAt(n);
                this.ccube.red.setPosition(this.col.getRed());
                this.ccube.blue.setPosition(this.col.getBlue());
                this.ccube.green.setPosition(this.col.getGreen());
                this.ccube.swatch.setColor(this.col);
            }
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
        this.callback.chosen(this, null);
    }

    public boolean isResizable() {
        return false;
    }

    static {
        defpal.addElement(Color.black);
        defpal.addElement(Color.blue);
        defpal.addElement(Color.cyan);
        defpal.addElement(Color.gray);
        defpal.addElement(Color.green);
        defpal.addElement(Color.darkGray);
        defpal.addElement(Color.magenta);
        defpal.addElement(Color.orange);
        defpal.addElement(Color.pink);
        defpal.addElement(Color.red);
        defpal.addElement(Color.white);
        defpal.addElement(Color.yellow);
    }
}

