\name{getMenuBar.ggobi}
\alias{getMenuBar.ggobi}
\title{Get GGobi control panel's menubar widget}
\description{
  This retrieves a reference to the menubar widget
  in the control panel/window of the specified GGobi
  instance. One can use this to add new menus, etc.
}
\usage{
getMenuBar.ggobi(.gobi = getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the GGobi instance in which to locate the control panel
    and its menubar. This can be given by index or explicit reference
     to the C structure representing the GGobi instance.}
 }
\details{
  This uses the RGtk package to determine the
  class of the Gtk widget.
} 
\value{
 An object of class GtkWidget.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\seealso{
  \code{\link[RGtk]{gtkMenubarNew}}
  \code{\link[RGtk]{gtkMenubarAppend}}
}
\examples{
data(mtcars)
g = ggobi(mtcars)
mbar = g$getMenuBar()

menu = gtkMenu()
item = gtkMenuItem("My action")
item$AddCallback("activate",
                 function(label, mitem) {
                     cat(label, "\n")
                 }, "My action")

menu$Append(item)

item = gtkMenuItem("R tools")
item$SetSubmenu(menu)

mbar$Append(item)
}
\keyword{interface}

