#include <glib.h>
#include "edv_types.h"
#include "edv_context.h"
#include "edv_history.h"
#include "config.h"


void EDVHistoryAppend(
	edv_context_struct *ctx,
	edv_history_type type,	/* One of EDV_HISTORY_* */
	gulong time_start,	/* Time the operation first started */
	gulong time_end,	/* Time the operation ended */
	gint status,		/* Result of operation */
	const gchar *source,	/* Source Object/Operation/Value */
	const gchar *target,	/* Target Object/Operation/Value */
	const gchar *comments	/* Comments */
);


#define ATOI(s)         (((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)         (((s) != NULL) ? atol(s) : 0)
#define ATOF(s)         (((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)       (((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define STRLEN(s)       (((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)   (((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Appends a new History Event to Endeavour's history list.
 */
void EDVHistoryAppend(
	edv_context_struct *ctx,
	edv_history_type type,	/* One of EDV_HISTORY_* */
	gulong time_start,	/* Time the operation first started */
	gulong time_end,	/* Time the operation ended */
	gint status,		/* Result of operation */
	const gchar *source,	/* Source Object/Operation/Value */
	const gchar *target,	/* Target Object/Operation/Value */
	const gchar *comments	/* Comments */
)
{
	gchar *cmd;

	if(ctx == NULL)
	    return;

	cmd = g_strdup_printf(
	    "append_history %i %ld %ld %i \"%s\" \"%s\" \"%s\"",
	    type,
	    time_start, time_end,
	    status,
	    (source != NULL) ? source : "",
	    (target != NULL) ? target : "",
	    (comments != NULL) ? comments : ""
	);
	EDVContextQueueCommand(ctx, cmd);
	g_free(cmd);
}

