/*
                                Find Window
 */

#ifndef FIND_WIN_H
#define FIND_WIN_H

#include <gtk/gtk.h>
#include "pulist.h"
#include "edv_types.h"
#include "edv_status_bar.h"


typedef struct _edv_find_win_struct	edv_find_win_struct;
#define EDV_FIND_WIN(p)			((edv_find_win_struct *)(p))


/*
 *	Find Window Operations:
 */
typedef enum {
	EDV_FIND_WIN_FIND_OBJECT_NAME,
	EDV_FIND_WIN_FIND_OBJECT_CONTENT
} edv_findwin_operation;

/*
 *	Find Window Roles:
 */
typedef enum {
	EDV_FIND_WIN_ROLE_DISK_OBJECT,
	EDV_FIND_WIN_ROLE_RECYCLED_OBJECT,
	EDV_FIND_WIN_ROLE_ARCHIVE_OBJECT
} edv_findwin_role;


/*
 *	Maximum columns on the results clist:
 */
#define DEV_FINDWIN_RESULTS_LIST_COLUMNS_MAX	5

/*
 *	Find Window:
 */
struct _edv_find_win_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count;
	edv_core_struct *core;

	gint		stop_count;

	gboolean	status_bar_map_state;

	GtkWidget	*main_vbox;
	pulistbox_struct	*find_op_pulistbox;
	GtkWidget	*search_combo,
			*location_combo,

			*case_sensitive_check,
			*recursive_check,

			*search_btn, *stop_btn, *clear_btn, *close_btn,

			*results_clist,

			*open_btn, *open_with_btn, *goto_btn;

	/* Results clist right click menu */
	GtkWidget	*results_clist_menu,
			*results_clist_open_mi,
			*results_clist_open_with_mi,
			*results_clist_goto_mi;

	/* Status Bar */
	edv_status_bar_struct *status_bar;

	/* Reference to the window that created this find window
	 *
	 * Only of the indexes can be non-negative
	 */
	gint		browser_num,
			imbr_num,
			recbin_num,
			archiver_num;

	/* Find role code, one of EDV_FNIDWIN_ROLE_* */
	edv_findwin_role	role;

	/* Find operation code, one of EDV_FIND_WIN_FIND_* */
	edv_findwin_operation	find_op;

	/* Last known write protect state, can be -1 to indicate
	 * undefined
	 */
	gint		last_write_protect_state;

};


/* find_win.c */
extern const gchar *EDVFindWinCurrentSearch(edv_find_win_struct *fw);
extern void EDVFindWinSetSearch(
	edv_find_win_struct *fw, const gchar *s,
	const gboolean record_history
);

extern const gchar *EDVFindWinCurrentLocation(edv_find_win_struct *fw);
extern void EDVFindWinSetLocation(
	edv_find_win_struct *fw, const gchar *path,
	const gboolean record_history
);

extern edv_findwin_operation EDVFindWinCurrentOperation(
	edv_find_win_struct *fw
);

extern void EDVFindWinSetReferenceWindow(
	edv_find_win_struct *fw,
	const gint browser_num,
	const gint imbr_num,
	const gint recbin_num,
	const gint archive_num
);

extern void EDVFindWinListResetColumns(
	edv_find_win_struct *fw, const edv_findwin_operation operation
);
extern void EDVFindWinListAppend(
	edv_find_win_struct *fw,
	const gchar *path, const struct stat *lstat_buf,
	const gchar *excerpt, const gint line_index
);
extern void EDVFindWinListClear(edv_find_win_struct *fw);

extern void EDVFindWinSyncConfiguration(edv_find_win_struct *fw);

extern edv_find_win_struct *EDVFindWinNew(edv_core_struct *core);
extern void EDVFindWinUpdateMenus(edv_find_win_struct *fw);
extern void EDVFindWinSetBusy(edv_find_win_struct *fw, const gboolean is_busy);
extern gboolean EDVFindWinIsMapped(edv_find_win_struct *fw);
extern void EDVFindWinMap(edv_find_win_struct *fw);
extern void EDVFindWinUnmap(edv_find_win_struct *fw);
extern void EDVFindWinDelete(edv_find_win_struct *fw);


#endif	/* FIND_WIN_H */
