#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#if defined(_WIN32)
# include <gdk/gdkwin32.h>
# define HAVE_WIN32
#else
# include <gdk/gdkx.h>
# define HAVE_X
#endif
#include <unistd.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"
#include "pulist.h"

#include "cfg.h"
#include "cfg_fio.h"
#include "edv_types.h"
#include "edv_id.h"
#include "edv_pixmap.h"
#include "edv_cursor.h"
#include "edv_obj.h"
#include "edv_recycled_obj.h"
#include "edv_date.h"
#include "edv_history.h"
#include "edv_obj.h"
#include "edv_recbin_index.h"
#include "edv_device.h"
#include "edv_devices_list.h"
#include "edv_mime_type.h"
#include "edv_mime_types_list.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "recbin.h"
#include "recbin_desktop_icon.h"
#include "find_win.h"
#include "prop_dlg.h"
#include "history_win.h"
#include "run_dlg.h"
#include "edv_generic_options_win.h"
#include "endeavour2.h"
#include "edv_cb.h"
#include "edv_op.h"
#include "edv_interps.h"
#include "edv_utils.h"
#include "edv_utils_gtk.h"

#define NEED_EDV_CFG_LIST_SOURCE
#include "edv_cfg_list.h"
#include "config.h"


static GList *g_list_new_length(guint length, gpointer datas);
static void g_list_set_nth_data(GList *glist, guint n, gpointer data);

static cfg_item_struct *EDVNewDefaultConfigurationList(
        const gchar *startup_path,
        const gchar *home_path
);
static void EDVCreateStandardCursors(edv_core_struct *core);

edv_core_struct *EDVNew(
	gint argc, gchar *argv[],
	gint *error_rtn
);
void EDVDelete(
	edv_core_struct *core,
	const gboolean save_config
);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new GList of the specified length.
 */
static GList *g_list_new_length(guint length, gpointer datas)
{
	gint i;
	GList *glist = NULL;

	for(i = 0; i < length; i++)
	    glist = g_list_append(glist, datas);

	return(glist);
}

/*
 *	Sets the data of the nth item in the GList.
 */
static void g_list_set_nth_data(GList *glist, guint n, gpointer data)
{
	glist = g_list_nth(glist, n);
	if(glist != NULL)
	    glist->data = data;
}


/*
 *	Creates a new configuration list with default values.
 */
static cfg_item_struct *EDVNewDefaultConfigurationList(
	const gchar *startup_path,
	const gchar *home_path
)
{
	gchar	*tmp_dir,
		*global_data_dir,
		*local_data_dir,
		*global_config_dir;
	GList *glist;
	cfg_intlist_struct *intlist;
	cfg_color_struct *color;
	cfg_accelkey_list_struct *ak_list;
	const cfg_item_struct src_cfg_list[] = EDV_CONFIGURATION_LIST;

	/* Create a new configuration list with all the parameters but
	 * no associated values
	 */
	cfg_item_struct *cfg_list = CFGItemListCopyList(src_cfg_list);
	if(cfg_list == NULL)
	    return(NULL);

	if(startup_path == NULL)
#if defined(_WIN32)
	    startup_path = "\\";
#else
	    startup_path = "/";
#endif

	if(home_path == NULL)
#if defined(_WIN32)
	    home_path = "\\";
#else
	    home_path = "/";
#endif


	/* Get the default values */
	global_data_dir = STRDUP(EDV_DEF_GLOBAL_DATA_DIR);

	/* Local Data Directory */
	local_data_dir = STRDUP(PrefixPaths(
	    home_path, EDV_DEF_LOCAL_DATA_DIR
	));

	/* Global Configuration Directory */
	global_config_dir = STRDUP(EDV_DEF_GLOBAL_CONFIG_DIR);

	/* Tempory Directory */
	tmp_dir = STRDUP(g_getenv(ENV_VAR_NAME_TMPDIR));
	if(tmp_dir == NULL)
#if defined(P_tmpdir)
	    tmp_dir = STRDUP(P_tmpdir);
#elif defined(_WIN32)
	    tmp_dir = STRDUP("C:\\TEMP");
#else
	    tmp_dir = STRDUP("/tmp");
#endif


	/* Begin setting default configuration values */

	/* Version */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);

	/* Directories */
	EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_path);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL, global_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_LOCAL, local_data_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_GLOBAL_CONFIG, global_config_dir);
	EDV_SET_S(EDV_CFG_PARM_DIR_TMP, tmp_dir);

	/* Files */
	/* Recycled Objects Index */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_RECYCLE_BIN_INDEX,
	    PrefixPaths(local_data_dir, EDV_DEF_RECYCLED_INDEX_FILE)
	);
	/* MIME Types (Local) */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_MIME_TYPES,
	    PrefixPaths(local_data_dir, EDV_DEF_MIMETYPES_FILE)
	);
	/* MIME Types (Global) */
#if defined(DEBIAN)
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL,
	    PrefixPaths(global_config_dir, EDV_DEF_MIMETYPES_FILE)
	);
#else
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL,
	    PrefixPaths(global_data_dir, EDV_DEF_MIMETYPES_FILE)
	);
#endif
	/* Devices */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_DEVICES,
	    PrefixPaths(local_data_dir, EDV_DEF_DEVICES_FILE)
	);
	/* History file */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_HISTORY_FILE)
	);
	/* Browser Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_BROWSER_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_BROWSER_LOCATION_HISTORY_FILE)
	);
	/* Image Browser Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_IMBR_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_IMBR_LOCATION_HISTORY_FILE)
	);
	/* Archiver Location History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_ARCHIVER_LOCATION_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_ARCHIVER_LOCATION_HISTORY_FILE)
	);
	/* Run Dialog History */
	EDV_SET_S(
	    EDV_CFG_PARM_FILE_RUNDLG_HISTORY,
	    PrefixPaths(local_data_dir, EDV_DEF_RUN_HISTORY_FILE)
	);

	/* Programs */
	/* Default Viewer */
	EDV_SET_S(EDV_CFG_PARM_PROG_DEF_VIEWER, EDV_DEF_VIEWER_CMD);
	/* Terminal */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL, EDV_DEF_TERMINAL_PROG);
	/* Run In Terminal Command */
	EDV_SET_S(EDV_CFG_PARM_PROG_TERMINAL_RUN, EDV_DEF_RUN_IN_TERMINAL_CMD);
	/* ARJ Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ARJ, "/usr/bin/arj");
	/* LHA Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_LHA, "/usr/bin/lha");
	/* RAR Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RAR, "/usr/bin/rar_static");
	/* RedHat Program Manager Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_RPM, "/bin/rpm");
	/* Tape Archive Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_TAR, "/bin/tar");
	/* PKZip Archiver */
	EDV_SET_S(EDV_CFG_PARM_PROG_ZIP, "/usr/bin/zip");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNZIP, "/usr/bin/unzip");
	/* Compress */
	EDV_SET_S(EDV_CFG_PARM_PROG_COMPRESS, "/usr/bin/compress");
	EDV_SET_S(EDV_CFG_PARM_PROG_UNCOMPRESS, "/usr/bin/uncompress");
	/* GZip */
	EDV_SET_S(EDV_CFG_PARM_PROG_GZIP, "/bin/gzip");
	EDV_SET_S(EDV_CFG_PARM_PROG_GUNZIP, "/bin/gunzip");
	/* BZip2 */
	EDV_SET_S(EDV_CFG_PARM_PROG_BZIP2, "/bin/bzip2");
	EDV_SET_S(EDV_CFG_PARM_PROG_BUNZIP2, "/bin/bunzip2");
	/* Download Front End */
	EDV_SET_S(EDV_CFG_PARM_PROG_NET_DOWNLOAD, EDV_DEF_DOWNLOAD_FRONT_PROG);
	/* E-Mail Client */
	EDV_SET_S(EDV_CFG_PARM_PROG_MAIL_CLIENT, EDV_DEF_MAIL_CLIENT_PROG);

	/* GTK Style Override */
	EDV_SET_B(EDV_CFG_PARM_GTK_STYLE_OVERRIDE, FALSE);

	/* Master Write Protect */
	EDV_SET_B(EDV_CFG_PARM_WRITE_PROTECT, TRUE);

	/* Record Start Up Directory */
	EDV_SET_B(EDV_CFG_PARM_RECORD_START_UP_DIR, TRUE);

	/* Lists Middle Click Scroll */
	EDV_SET_B(EDV_CFG_PARM_LISTS_MIDDLE_CLICK_SCROLL, FALSE);

	/* Right Click Menus Selects */
	EDV_SET_B(EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS, TRUE);

	/* Date Relativity */
	EDV_SET_I(EDV_CFG_PARM_DATE_RELATIVITY, (gint)EDV_DATE_RELATIVITY_ABSOLUTE);
	/* Date Format (see strftime()) */
	EDV_SET_S(EDV_CFG_PARM_DATE_FORMAT, "%b %d %H:%M");

	/* Conserve Memory */
	EDV_SET_B(EDV_CFG_PARM_CONSERVE_MEMORY, FALSE);

	/* Image Quality (0=poor/fastest 1=standard/optimul 2=best/slowest) */
	EDV_SET_I(EDV_CFG_PARM_IMAGE_QUALITY, 1);

	/* Lists Double Buffer */
	EDV_SET_B(EDV_CFG_PARM_LISTS_DOUBLE_BUFFER, TRUE);

	/* Lists Animate Updates */
	EDV_SET_B(EDV_CFG_PARM_LISTS_ANIMATE_UPDATES, TRUE);

	/* Tree Expand Optimize Position */
	EDV_SET_B(EDV_CFG_PARM_TREE_EXPAND_OPTIMIZE_POS, TRUE);

	/* Show Tooltips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TOOLTIPS, TRUE);

	/* Show Texttips */
	EDV_SET_B(EDV_CFG_PARM_SHOW_TEXTTIPS, TRUE);

	/* Window Cascade Offset */
	EDV_SET_I(
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_X,
	    EDV_DEF_WINDOW_CASCADE_OFFSET_X
	);
	EDV_SET_I(
	    EDV_CFG_PARM_WINDOW_CASCADE_OFFSET_Y,
	    EDV_DEF_WINDOW_CASCADE_OFFSET_Y
	);


	/* Confirm Copy */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_COPY, TRUE);
	/* Confirm Move */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_MOVE, TRUE);
	/* Confirm Link */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_LINK, TRUE);
	/* Confirm Delete */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DELETE, TRUE);
	/* Confirm Add To Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD, TRUE);
	/* Confirm Extract From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT, TRUE);
	/* Confirm Delete From Archive */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE, TRUE);
	/* Confirm Recover */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_RECOVER, TRUE);
	/* Confirm Purge */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_PURGE, TRUE);
	/* Confirm Downloads */
	EDV_SET_B(EDV_CFG_PARM_CONFIRM_DOWNLOAD, TRUE);

	/* Maximum History Events */
	EDV_SET_I(EDV_CFG_PARM_HISTORY_EVENTS_MAX, 500);

	/* Recycle Bin Size Warn (in bytes) */
	EDV_SET_UL(EDV_CFG_PARM_RECBIN_SIZE_WARN, 10000000l);

	/* Delete Method (Recycle or Purge on delete) */
	EDV_SET_I(EDV_CFG_PARM_DELETE_METHOD, (gint)EDV_DELETE_METHOD_RECYCLE);

	/* Add To Archive */
	/* Compression Level (0 to 100) */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION, 100);
	/* Recursive */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE, TRUE);
	/* Dereference Links */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS, FALSE);

	/* Extract From Archive */
	/* Preserve Directories */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR, TRUE);
	/* Preserve Time Stamps */
	EDV_SET_B(EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_TIMESTAMPS, TRUE);

	/* Mailcap Import Options */
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MAILCAP_IMPORT_ONLY_NEWER, TRUE);
	/* Media Types Import Options */
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MEDIA_TYPES_IMPORT_ONLY_NEWER, TRUE);
	/* MIME Types Import Options */
	EDV_SET_B(EDV_CFG_PARM_MIME_TYPES_IMPORT_UPDATE, TRUE);
	EDV_SET_B(EDV_CFG_PARM_MIME_TYPES_IMPORT_ONLY_NEWER, TRUE);

	/* Sounds */
	EDV_SET_B(EDV_CFG_PARM_SOUND_USE_SYSTEM, TRUE);
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_BEEP, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_INFO, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_QUESTION, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_WARNING, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_ERROR, "");
	EDV_SET_S(EDV_CFG_PARM_SOUND_PLAY_COMPLETED, "");

	/* Startup Window */
	EDV_SET_B(EDV_CFG_PARM_STARTUP_BROWSER, TRUE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_IMBR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_ARCHIVER, FALSE);
	EDV_SET_B(EDV_CFG_PARM_STARTUP_RECBIN, FALSE);


	/* File Browser Geometry */
	EDV_SET_I(EDV_CFG_PARM_BROWSER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_WIDTH, EDV_DEF_BROWSER_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_HEIGHT, EDV_DEF_BROWSER_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_BROWSER_PANED_POSITION, EDV_DEF_BROWSER_PANED_POSITION);

	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_DIRECTORY_TREE_ORIGIN);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_RENAME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_OP_RECYCLE_BIN);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_BROWSER_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_S(EDV_CFG_PARM_BROWSER_DIR_TREE_ORIGIN, "/");

	EDV_SET_S(EDV_CFG_PARM_BROWSER_CONTENTS_LIST_FILTER, "*");
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_BROWSER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Browser Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_HARD_LINKS);
	glist = g_list_append(glist, (gpointer)EDV_BROWSER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Browser Contents Column Widths */
	glist = g_list_new_length(
	    EDV_BROWSER_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_HARD_LINKS, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DEVICE_INDEX, (gpointer)60
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_INDEX, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_DEVICE_TYPE, (gpointer)90
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_BLOCK_SIZE, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_BROWSER_COLUMN_TYPE_BLOCKS, (gpointer)60
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_BROWSER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_BROWSER_SHOW_OBJECT_NOACCESS, TRUE);

	/* Accelerator Keys */
	ak_list = EDVBrowserAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_BROWSER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser Geometry */
	EDV_SET_I(EDV_CFG_PARM_IMBR_X, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_IMBR_WIDTH, EDV_DEF_IMBR_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_HEIGHT, EDV_DEF_IMBR_HEIGHT);
	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_PANED_POSITION,
	    EDV_DEF_IMBR_PANED_POSITION
	);

	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_MOUNT_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_GOTO_PARENT);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_GOTO_HOME);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_MOVE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_COPY);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_PROPERTIES);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_STOP);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_CONTINUE);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_NEW_BROWSER);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_NEW_IMBR);
	glist = g_list_append(glist, (gpointer)EDV_IMBR_OP_RECYCLE_BIN);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_IMBR_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_IMBR_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	color = CFGColorNew(0.0f, 0.0f, 0.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_FG, color);
	CFGColorDelete(color);
	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_BG, color);
	CFGColorDelete(color);
	color = CFGColorNew(0.0f, 0.0f, 0.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_IMBR_COLOR_BORDER, color);
	CFGColorDelete(color);

	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_LIST_HORIZONTAL, FALSE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_FRAMES, TRUE);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_SHOW_LABELS, TRUE);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_WIDTH, DEF_IMBR_THUMB_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_HEIGHT, DEF_IMBR_THUMB_HEIGHT);
	EDV_SET_I(EDV_CFG_PARM_IMBR_THUMB_BORDER, DEF_IMBR_THUMB_BORDER);
	EDV_SET_B(EDV_CFG_PARM_IMBR_THUMB_NO_ENLARGE, TRUE);

	EDV_SET_S(EDV_CFG_PARM_IMBR_THUMBS_LIST_FILTER, "*");

	/* Show Hidden Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_HIDDEN, TRUE);
	/* Show No Access Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NOACCESS, TRUE);
	/* Show Non-Image Objects */
	EDV_SET_B(EDV_CFG_PARM_IMBR_SHOW_OBJECT_NONIMAGE, TRUE);

	/* Accelerator Keys */
	ak_list = EDVImbrAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_IMBR_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Image Browser Presentation Mode */
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SHOW_NAVIGATOR, TRUE);
	EDV_SET_S(
	    EDV_CFG_PARM_PRESENTATION_FONT,
	    DEF_PRESENTATION_FONT
	);
	color = CFGColorNew(1.0f, 1.0f, 1.0f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_FG, color);
	CFGColorDelete(color);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_COLOR_FG_INVERT, TRUE);
	color = CFGColorNew(0.0f, 0.0f, 0.5f, 1.0f);
	EDV_SET_COLOR(EDV_CFG_PARM_PRESENTATION_COLOR_BG, color);
	CFGColorDelete(color);
	EDV_SET_I(EDV_CFG_PARM_PRESENTATION_HIDE_POINTER_DELAY, 3);
	EDV_SET_B(EDV_CFG_PARM_PRESENTATION_SLIDESHOW, FALSE);
	EDV_SET_I(EDV_CFG_PARM_PRESENTATION_SLIDESHOW_DELAY, 3);

	/* Archiver Geometry */
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_X, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_WIDTH, EDV_DEF_ARCHIVER_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_ARCHIVER_HEIGHT, EDV_DEF_ARCHIVER_HEIGHT);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_ARCHIVE_INFO_ON_OPEN, TRUE);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_LOCATION_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_OPEN);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_ADD);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_EXTRACT_ALL);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_DELETE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_REFRESH);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_OP_COMMENT_AND_STATISTICS);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_ARCHIVER_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_ARCHIVER_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Archiver Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED);
	glist = g_list_append(glist, (gpointer)EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Archiver Contents Column Widths */
	glist = g_list_new_length(
	    EDV_ARCHIVER_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSED_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_LOCATION, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_DEVICE_TYPE, (gpointer)90
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_COMPRESSION, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_METHOD, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_ARCHIVER_COLUMN_TYPE_CRC, (gpointer)80
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_ARCHIVER_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_S(EDV_CFG_PARM_ARCHIVER_CONTENTS_LIST_FILTER, "*");

	/* Accelerator Keys */
	ak_list = EDVArchiverAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_ARCHIVER_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Recycle Bin Geometry */
	EDV_SET_I(EDV_CFG_PARM_RECBIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_WIDTH, EDV_DEF_RECBIN_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_HEIGHT, EDV_DEF_RECBIN_HEIGHT);

	/* Recycle Bin Desktop Icon */
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON, FALSE);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RECBIN_DESKTOP_ICON_Y, 0);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_TOOL_BAR, TRUE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_FIND_BAR, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_SHOW_STATUS_BAR, TRUE);

	/* Tool Bar */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_RECOVER);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_PURGE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_PURGE_ALL);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_SEPARATOR);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_OP_REFRESH);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_TOOL_BAR, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_DISPLAY,
	    (gint)TOOLBAR_DISPLAY_PICTURES_AND_TEXT
	);
	EDV_SET_I(
	    EDV_CFG_PARM_RECBIN_TOOL_BAR_RELIEF,
	    (gint)TOOLBAR_RELIEF_NONE
	);

	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_DIR_SIZE, FALSE);
	EDV_SET_B(EDV_CFG_PARM_RECBIN_CONTENTS_HIDE_LINK_PERMISSIONS, FALSE);

	/* Recycle Bin Contents Columns */
	glist = NULL;
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_NAME);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_SIZE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_TYPE);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_PERMISSIONS);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_OWNER);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_GROUP);
	glist = g_list_append(glist, (gpointer)EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN, intlist);
	CFGIntListDelete(intlist);

	/* Recycle Bin Contents Column Widths */
	glist = g_list_new_length(
	    EDV_RECBIN_CONTENTS_CLIST_COLUMNS_MAX,
	    (gpointer)0
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_NAME, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_SIZE, (gpointer)70
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_TYPE, (gpointer)100
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_PERMISSIONS, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_OWNER, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_GROUP, (gpointer)80
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_ACCESS, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_MODIFIED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_CHANGED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_DATE_DELETED, (gpointer)120
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_LINKED_TO, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_ORIGINAL_LOCATION, (gpointer)150
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_INDEX, (gpointer)60
	);
	g_list_set_nth_data(glist,
	    EDV_RECBIN_COLUMN_TYPE_CAPACITY_USED, (gpointer)85
	);
	intlist = CFGIntListNew(glist);
	g_list_free(glist);
	EDV_SET_INTLIST(EDV_CFG_PARM_RECBIN_CONTENTS_COLUMN_WIDTH, intlist);
	CFGIntListDelete(intlist);

	EDV_SET_S(EDV_CFG_PARM_RECBIN_CONTENTS_LIST_FILTER, "*");

	/* Accelerator Keys */
	ak_list = EDVRecBinAccelkeysListNewDefault();
	EDV_SET_ACCELKEY_LIST(EDV_CFG_PARM_RECBIN_ACCELERATOR_KEYS, ak_list);
	CFGAccelkeyListDelete(ak_list);


	/* Find Window Geometry */
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_X, 0);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_Y, 0);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_WIDTH, EDV_DEF_FINDWIN_WIDTH);
	EDV_SET_I(EDV_CFG_PARM_FINDWIN_HEIGHT, EDV_DEF_FINDWIN_HEIGHT);

	/* Find Window Search String */
	EDV_SET_S(EDV_CFG_PARM_FINDWIN_SEARCH_STRING, "");
	/* Find Window Operation */
	EDV_SET_I(
	    EDV_CFG_PARM_FINDWIN_FIND_OP,
	    (gint)EDV_FIND_WIN_FIND_OBJECT_NAME
	);
	/* Find Window Case Sensitive */
	EDV_SET_B(EDV_CFG_PARM_FINDWIN_CASE_SENSITIVE, FALSE);
	/* Find Window Recursive */
	EDV_SET_B(EDV_CFG_PARM_FINDWIN_RECURSIVE, FALSE);


	/* Run Dialog Geometry */
	EDV_SET_I(EDV_CFG_PARM_RUNDLG_X, 0);
	EDV_SET_I(EDV_CFG_PARM_RUNDLG_Y, 0);

	/* Rin Dialog Run In Terminal */
	EDV_SET_B(EDV_CFG_PARM_RUNDLG_RUN_IN_TERMINAL, FALSE);
	/* Run Dialog Keep Dialog */
	EDV_SET_B(EDV_CFG_PARM_RUNDLG_KEEP_DIALOG, FALSE);
	/* Run Dialog Working Directory */
	EDV_SET_S(EDV_CFG_PARM_RUNDLG_LAST_WORKING_DIR, home_path);


	g_free(tmp_dir);
	g_free(global_data_dir);
	g_free(local_data_dir);
	g_free(global_config_dir);

	return(cfg_list);
}

/*
 *	Creates a standard list of cursors on the core.
 */
static void EDVCreateStandardCursors(edv_core_struct *core)
{
	GdkWindow *root = GDK_ROOT_PARENT();
	GdkColor	c_fg = { 0, 0xffff, 0xffff, 0xffff },
			c_bg = { 0, 0x0000, 0x0000, 0x0000 };

#define APPEND_CURSOR(_cursor_)		{		\
 const gint i = MAX(core->total_cursors, 0);	\
 core->total_cursors = i + 1;			\
							\
 core->cursor = (edv_cursor_struct **)g_realloc(	\
  core->cursor,					\
  core->total_cursors * sizeof(edv_cursor_struct *)	\
 );							\
 if(core->cursor == NULL) {				\
  core->total_cursors = 0;				\
  EDVCursorDelete(_cursor_);				\
 } else {						\
  core->cursor[i] = (_cursor_);			\
 }							\
}
#define APPEND_CURSOR_PRESET(_code_,_gdk_type_)	{	\
 edv_cursor_struct *cursor = EDVCursorNewGDKPreset(	\
  (_code_), (_gdk_type_)				\
 );							\
 APPEND_CURSOR(cursor);					\
}
#define APPEND_CURSOR_PIXMAP(_code_,_cm_,_tm_,_hx_,_hy_) {	\
 APPEND_CURSOR(EDVCursorNew(				\
  (_code_),						\
  gdk_cursor_new_from_pixmap(				\
   (_cm_), (_tm_), &c_fg, &c_bg, (_hx_), (_hy_)		\
  )							\
 ));							\
}

	/* Begin creating cursors */

	if(FALSE)
	{
	    const gint width = 20, height = 20;
	    const gchar color_mask_data[] = {
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfc, 0x01, 0x00,
0xac, 0x01, 0x00,
0xd8, 0x00, 0x00,
0x70, 0x00, 0x00,
0x20, 0x00, 0x00,
0x50, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xdc, 0x01, 0x00,
0xac, 0x01, 0x00,
0x54, 0x01, 0x00,
0x00, 0x00, 0x00,
0xfe, 0x03, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
	    };
	    const gchar trans_mask_data[] = {
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfc, 0x01, 0x00,
0xf8, 0x00, 0x00,
0x70, 0x00, 0x00,
0xf8, 0x00, 0x00,
0xfc, 0x01, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xfe, 0x03, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0xff, 0x07, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00,
0x00, 0x00, 0x00
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_BUSY,
		color_mask, trans_mask, 5, 8
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
	    APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	if(TRUE)
	{
	    const gint width = 24, height = 24;
	    const gchar color_mask_data[] = {
0x03, 0x00, 0x00,
0x05, 0x00, 0x00,
0x09, 0x00, 0x00,
0x11, 0x00, 0x00,
0x21, 0x00, 0x00,
0x41, 0x00, 0x00,
0x81, 0x00, 0x00,
0x01, 0x01, 0x00,
0x01, 0xc2, 0x7f,
0xc1, 0x03, 0x00,
0x49, 0x80, 0x3f,
0x95, 0x80, 0x3f,
0x93, 0x80, 0x35,
0x20, 0x01, 0x1b,
0x20, 0x01, 0x0e,
0xc0, 0x00, 0x04,
0x00, 0x00, 0x0a,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3b,
0x00, 0x80, 0x35,
0x00, 0x80, 0x2a,
0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f,
0x00, 0x00, 0x00
	    };
	    const gchar trans_mask_data[] = {
0x03, 0x00, 0x00,
0x07, 0x00, 0x00,
0x0f, 0x00, 0x00,
0x1f, 0x00, 0x00,
0x3f, 0x00, 0x00,
0x7f, 0x00, 0x00,
0xff, 0x00, 0x00,
0xff, 0xe1, 0xff,
0xff, 0xe3, 0xff,
0xff, 0xe3, 0xff,
0x7f, 0xc0, 0x7f,
0xf7, 0xc0, 0x7f,
0xf3, 0xc0, 0x7f,
0xe0, 0x81, 0x3f,
0xe0, 0x01, 0x1f,
0xc0, 0x00, 0x0e,
0x00, 0x00, 0x1f,
0x00, 0x80, 0x3f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xc0, 0x7f,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff,
0x00, 0xe0, 0xff
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_PASSIVE_BUSY,
		color_mask, trans_mask, 0, 0
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}
	else
	{
	    APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_BUSY, GDK_WATCH);
	}

	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TEXT, GDK_XTERM);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_HAND, GDK_HAND2);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_TRANSLATE, GDK_FLEUR);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_RESIZE, GDK_SIZING);
	APPEND_CURSOR_PRESET(EDV_CURSOR_CODE_CROSSHAIR, GDK_TCROSS);

	if(TRUE)
	{
	    const gint width = 16, height = 16;
	    const gchar color_mask_data[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
	    };
	    const gchar trans_mask_data[] = {
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00
	    };
	    GdkBitmap *color_mask = gdk_bitmap_create_from_data(
		root, color_mask_data, width, height
	    );
	    GdkBitmap *trans_mask = gdk_bitmap_create_from_data(
		root, trans_mask_data, width, height
	    );
	    APPEND_CURSOR_PIXMAP(
		EDV_CURSOR_CODE_INVISIBLE,
		color_mask, trans_mask, 0, 0
	    );
	    GDK_BITMAP_UNREF(color_mask);
	    GDK_BITMAP_UNREF(trans_mask);
	}


#undef APPEND_CURSOR_PRESET
#undef APPEND_CURSOR_PIXMAP
#undef APPEND_CURSOR
}


/*
 *	Creates a new Endeavour core and performs the startup procedure.
 *
 *	The argc and argv specifies the command line arguments.
 *
 *	If error_rtn is not NULL then *error_rtn will be set to one of
 *	the following error codes:
 *
 *	0	Success (or issued InterPS command and returned NULL).
 *	-1	General error.
 *	-2	Invalid value.
 *	-3	Systems error or memory allocation error.
 *	-4	User aborted.
 *
 *	The startup procedure is as follows:
 *
 *	1. Set the default configuration values.
 *
 *	2. Parse and handle the command line arguments.
 *
 *	3. Open the Users and Groups ID list files.
 *
 *	4. Open the configuration file if it exists, if it does not
 *	   exist then save the configuration from file (thus
 *	   generating a new configuration file with the default
 *	   values).
 *
 *	5. Check if an InterPS lock link exists in the local data
 *	   directory and if it does then send the commands from
 *	   command line to the current running process specified by
 *	   the InterPS lock link and return NULL with *error_rtn set
 *	   to 0.
 *
 *	6. Create the InterPS lock link with this PID as its value.
 *
 *	7. Open the Devices list and MIME Types list files.
 *
 *	8. Compare this version with the version from the configuration
 *	   file, if there is a change then notify the user that this
 *	   is a new version.
 *
 *	9. Create the initial window as specified by either from the
 *	   command line or (if not from the command line) from the
 *	   configuration.
 *
 *	Returns the new Endeavour core or NULL on error.
 */
edv_core_struct *EDVNew(gint argc, gchar *argv[], gint *error_rtn)
{
	gint i, p;
	const gchar *s, *arg;
	gboolean cfg_version_different;
	gint cfg_file_load_status;
	gint		old_version_major,
			old_version_minor,
			old_version_release;
	gboolean	no_splash = FALSE,
			startup_browser,
			startup_imbr,
			startup_archiver,
			startup_recbin;
	const gchar	*window_name = NULL,
			*arg_extra = NULL,
			*recbin_index_file,
			*alternate_config_file = NULL,
			*startup_path = NULL;
	gchar		*cwd,
			*startup_full_path = NULL,
			hostname[64 + 1];
	cfg_item_struct	*cfg_list;
	edv_core_struct *core = EDV_CORE(
	    g_malloc0(sizeof(edv_core_struct))
	);
	if(core == NULL)
	{
	    if(error_rtn != NULL)
		*error_rtn = -3;
	    return(core);
	}


	if(error_rtn != NULL)
	    *error_rtn = 0;

#define DO_FREE_LOCALS	{		\
 g_free(cwd);				\
 g_free(startup_full_path);		\
}

	/* Get the current working directory */
	cwd = EDVGetCWD();
	if(cwd == NULL)
#if defined(_WIN32)
	    cwd = STRDUP("\\");
#else
	    cwd = STRDUP("/");
#endif

	/* Begin resetting values */
	core->cfg_file = NULL;
	core->cfg_list = NULL;

	core->pixmap_list = NULL;

	core->browser = NULL;
	core->total_browsers = 0;

	core->imbr = NULL;
	core->total_imbrs = 0;

	core->recbin = NULL;
	core->recbin_deskicon = NULL;
	core->last_recbin_items = 0;

	core->find_win = NULL;

	core->propdlg = NULL;
	core->total_propdlgs = 0;

	core->options_window = NULL;
	core->customize_window = NULL;

	core->about_dlg = NULL;


	core->manage_toid = 0;
	core->check_devices_toid = 0;

	core->pending_flags = 0;

	core->interps_signal_count = 0;


	core->pid = getpid();
	core->prog_file = NULL;
	core->home_dir = STRDUP(g_getenv(ENV_VAR_NAME_HOME));

	core->user_id = getuid();
	core->effective_user_id = geteuid();
	core->group_id = getgid();
	core->effective_group_id = getegid();

	core->uid = NULL;
	core->total_uids = 0;
	core->users_pulist = NULL;
	core->gid = NULL;
	core->total_gids = 0;
	core->groups_pulist = NULL;

	core->effective_user_id_str = NULL;
	core->effective_user_id_host_str = NULL;

	core->cursor = NULL;
	core->total_cursors = 0;

	core->device = NULL;
	core->total_devices = 0;
	core->devices_pulist = NULL;

	core->mimetype = NULL;
	core->total_mimetypes = 0;
	core->open_with_pulist = NULL;

	core->mimetype_system_index_first = -1;
	core->mimetype_system_index_last = -1;
	core->mimetype_format_index_first = -1;
	core->mimetype_format_index_last = -1;
	core->mimetype_program_index_first = -1;
	core->mimetype_program_index_last = -1;
	core->mimetype_unique_index_first = -1;
	core->mimetype_unique_index_last = -1;


	core->geometry_set = FALSE;
	memset(&core->geometry, 0x00, sizeof(GdkRectangle));
	core->font_name = NULL;
	core->font = NULL;
	core->fg_color_name = NULL;
	core->bg_color_name = NULL;
	core->sfg_color_name = NULL;
	core->sbg_color_name = NULL;
	core->cfg_color_name = NULL;
	core->cbg_color_name = NULL;
	core->bg_pixmap_path = NULL;
	core->sbg_pixmap_path = NULL;
	core->wm_name = NULL;
	core->wm_class = NULL;
	core->title = NULL;

	core->standard_rcstyle = NULL;
	core->lists_rcstyle = NULL;


	/* Parse arguments */
	for(i = 1; i < argc; i++)
	{
	    arg = argv[i];
	    if(arg == NULL)
		continue;

	    /* Alternate configuration file? */
	    if(!g_strcasecmp(arg, "--config") ||
	       !g_strcasecmp(arg, "-config") ||
	       !g_strcasecmp(arg, "--rcfile") ||
	       !g_strcasecmp(arg, "-rcfile") ||
	       !g_strcasecmp(arg, "--f") ||
	       !g_strcasecmp(arg, "-f")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    alternate_config_file = arg;
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* No Splash? */
	    else if(!g_strcasecmp(arg, "--no-splash") ||
		    !g_strcasecmp(arg, "-no-splash") ||
		    !g_strcasecmp(arg, "--no_splash") ||
		    !g_strcasecmp(arg, "-no_splash")
	    )
	    {
		no_splash = TRUE;
	    }
	    /* Startup with File Browser? */
	    else if(!g_strcasecmp(arg, "--file_browser") ||
		    !g_strcasecmp(arg, "--file-browser") ||
		    !g_strcasecmp(arg, "-file_browser") ||
		    !g_strcasecmp(arg, "-file-browser") ||
		    !g_strcasecmp(arg, "--browser") ||
		    !g_strcasecmp(arg, "-browser")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Image Browser? */
	    else if(!g_strcasecmp(arg, "--image_browser") ||
		    !g_strcasecmp(arg, "--image-browser") ||
		    !g_strcasecmp(arg, "-image_browser") ||
		    !g_strcasecmp(arg, "-image-browser") ||
		    !g_strcasecmp(arg, "--imbr") ||
		    !g_strcasecmp(arg, "-imbr")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Archiver? */
	    else if(!g_strcasecmp(arg, "--archiver") ||
		    !g_strcasecmp(arg, "-archiver")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Recycle Bin? */
	    else if(!g_strcasecmp(arg, "--recycle_bin") ||
		    !g_strcasecmp(arg, "--recycle-bin") ||
		    !g_strcasecmp(arg, "-recycle_bin") ||
		    !g_strcasecmp(arg, "-recycle-bin") ||
		    !g_strcasecmp(arg, "--recbin") ||
		    !g_strcasecmp(arg, "-recbin")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Properties Dialog? */
	    else if(!g_strcasecmp(arg, "--properties_dialog") ||
		    !g_strcasecmp(arg, "-properties_dialog") ||
		    !g_strcasecmp(arg, "--properties-dialog") ||
		    !g_strcasecmp(arg, "-properties-dialog") ||
		    !g_strcasecmp(arg, "--properties") ||
		    !g_strcasecmp(arg, "-properties") ||
		    !g_strcasecmp(arg, "--propdlg") ||
		    !g_strcasecmp(arg, "-propdlg")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Options Window? */
	    else if(!g_strcasecmp(arg, "--options") ||
		    !g_strcasecmp(arg, "-options")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Customize Window? */
	    else if(!g_strcasecmp(arg, "--customize") ||
		    !g_strcasecmp(arg, "-customize")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Devices List Window? */
	    else if(!g_strcasecmp(arg, "--devices") ||
		    !g_strcasecmp(arg, "-devices")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the MIME Types List Window? */
	    else if(!g_strcasecmp(arg, "--mimetypes") ||
		    !g_strcasecmp(arg, "-mimetypes")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Run Dialog? */
	    else if(!g_strcasecmp(arg, "--run_dialog") ||
		    !g_strcasecmp(arg, "--run-dialog") ||
		    !g_strcasecmp(arg, "-run_dialog") ||
		    !g_strcasecmp(arg, "-run-dialog") ||
		    !g_strcasecmp(arg, "--run_dlg") ||
		    !g_strcasecmp(arg, "--run-dlg") ||
		    !g_strcasecmp(arg, "-run_dlg") ||
		    !g_strcasecmp(arg, "-run-dlg") ||
		    !g_strcasecmp(arg, "--rundlg") ||
		    !g_strcasecmp(arg, "-rundlg") ||
		    !g_strcasecmp(arg, "--run") ||
		    !g_strcasecmp(arg, "-run")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the Find Window? */
	    else if(!g_strcasecmp(arg, "--find_win") ||
		    !g_strcasecmp(arg, "--find-win") ||
		    !g_strcasecmp(arg, "-find_win") ||
		    !g_strcasecmp(arg, "-find-win") ||
		    !g_strcasecmp(arg, "--find_dlg") ||
		    !g_strcasecmp(arg, "--find-dlg") ||
		    !g_strcasecmp(arg, "-find_dlg") ||
		    !g_strcasecmp(arg, "-find-dlg") ||
		    !g_strcasecmp(arg, "--find") ||
		    !g_strcasecmp(arg, "-find")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }
	    /* Startup with the About Dialog? */
	    else if(!g_strcasecmp(arg, "--about_dialog") ||
		    !g_strcasecmp(arg, "--about-dialog") ||
		    !g_strcasecmp(arg, "-about_dialog") ||
		    !g_strcasecmp(arg, "-about-dialog") ||
		    !g_strcasecmp(arg, "--about_dlg") ||
		    !g_strcasecmp(arg, "--about-dlg") ||
		    !g_strcasecmp(arg, "-about_dlg") ||
		    !g_strcasecmp(arg, "-about-dlg") ||
		    !g_strcasecmp(arg, "--aboutdlg") ||
		    !g_strcasecmp(arg, "-aboutdlg") ||
		    !g_strcasecmp(arg, "--about") ||
		    !g_strcasecmp(arg, "-about")
	    )
	    {
		window_name = arg;
		while(*window_name == '-')
		    window_name++;
	    }

	    /* Geometry? */
	    else if(!g_strcasecmp(arg, "--geometry") ||
		    !g_strcasecmp(arg, "-geometry")
	    )
	    {
		i++;
		arg = (i < argc) ? argv[i] : NULL;
		if(!STRISEMPTY(arg))
		{
		    gint x, y, width, height;
		    GdkRectangle *rect = &core->geometry;
		    GdkGeometryFlags status = gdk_parse_geometry(
			arg, &x, &y, &width, &height
		    );
		    core->geometry_set = status ? TRUE : FALSE;
		    rect->x = (status & GDK_GEOMETRY_X) ? x : 0;
		    rect->y = (status & GDK_GEOMETRY_Y) ? y : 0;
		    rect->width = (status & GDK_GEOMETRY_WIDTH) ? width : 0;
		    rect->height = (status & GDK_GEOMETRY_HEIGHT) ? height : 0;
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			argv[i - 1]
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}		
	    }
	    /* Font name? */
	    else if(!g_strcasecmp(arg, "--font") ||
		    !g_strcasecmp(arg, "-font") ||
		    !g_strcasecmp(arg, "--fn") ||
		    !g_strcasecmp(arg, "-fn")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->font_name);
		    core->font_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Foreground color name? */
	    else if(!g_strcasecmp(arg, "--foreground") ||
		    !g_strcasecmp(arg, "-foreground") ||
		    !g_strcasecmp(arg, "--fg") ||
		    !g_strcasecmp(arg, "-fg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->fg_color_name);
		    core->fg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Background color name? */
	    else if(!g_strcasecmp(arg, "--background") ||
		    !g_strcasecmp(arg, "-background") ||
		    !g_strcasecmp(arg, "--bg") ||
		    !g_strcasecmp(arg, "-bg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->bg_color_name);
		    core->bg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected foreground color name? */
	    else if(!g_strcasecmp(arg, "--sforeground") ||
		    !g_strcasecmp(arg, "-sforeground") ||
		    !g_strcasecmp(arg, "--sfg") ||
		    !g_strcasecmp(arg, "-sfg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->sfg_color_name);
		    core->sfg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected background color name? */
	    else if(!g_strcasecmp(arg, "--sbackground") ||
		    !g_strcasecmp(arg, "-sbackground") ||
		    !g_strcasecmp(arg, "--sbg") ||
		    !g_strcasecmp(arg, "-sbg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->sbg_color_name);
		    core->sbg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Pointer cursor foreground color name? */
	    else if(!g_strcasecmp(arg, "--cforeground") ||
		    !g_strcasecmp(arg, "-cforeground") ||
		    !g_strcasecmp(arg, "--cfg") ||
		    !g_strcasecmp(arg, "-cfg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->cfg_color_name);
		    core->cfg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Pointer cursor background color name? */
	    else if(!g_strcasecmp(arg, "--cbackground") ||
		    !g_strcasecmp(arg, "-cbackground") ||
		    !g_strcasecmp(arg, "--cbg") ||
		    !g_strcasecmp(arg, "-cbg")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->cbg_color_name);
		    core->cbg_color_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Background pixmap path? */
	    else if(!g_strcasecmp(arg, "--background-pixmap") ||
		    !g_strcasecmp(arg, "-background-pixmap") ||
		    !g_strcasecmp(arg, "--bg-pixmap") ||
		    !g_strcasecmp(arg, "-bg-pixmap")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->bg_pixmap_path);
		    core->bg_pixmap_path = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Selected background pixmap path? */
	    else if(!g_strcasecmp(arg, "--sbackground-pixmap") ||
		    !g_strcasecmp(arg, "-sbackground-pixmap") ||
		    !g_strcasecmp(arg, "--sbg-pixmap") ||
		    !g_strcasecmp(arg, "-sbg-pixmap")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->sbg_pixmap_path);
		    core->sbg_pixmap_path = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }

	    /* Name? */
	    else if(!g_strcasecmp(arg, "--name") ||
		    !g_strcasecmp(arg, "-name")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->wm_name);
		    core->wm_name = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Class? */
	    else if(!g_strcasecmp(arg, "--class") ||
		    !g_strcasecmp(arg, "-class")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->wm_class);
		    core->wm_class = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Title? */
	    else if(!g_strcasecmp(arg, "--title") ||
		    !g_strcasecmp(arg, "-title")
	    )
	    {
		i++;
		if(i < argc)
		{
		    arg = argv[i];
		    g_free(core->title);
		    core->title = STRDUP(arg);
		}
		else
		{
		    g_printerr(
			"%s: Requires argument.\n",
			arg
		    );
		    EDVDelete(core, FALSE);
		    DO_FREE_LOCALS
		    if(error_rtn != NULL)
			*error_rtn = -2;
		    return(NULL);
		}
	    }
	    /* Non-switch argument? */
	    else if((*arg != '-') && (*arg != '+'))
	    {
		/* Get each non-switch argument in the order of
		 * startup_path and arg_extra
		 */
		if(startup_path == NULL)
		{
		    startup_path = arg;

		    /* The startup_path may be a relative path so
		     * complete it as needed as startup_full_path
		     */
		    startup_full_path = EDVEvaluatePath(cwd, startup_path);
		}
		else if(arg_extra == NULL)
		{
		    arg_extra = arg;
		}
	    }
	}


	/* Record the path to the program file from the specified
	 * command line arguments
	 */
	if(argc > 0)
	{
	    g_free(core->prog_file);
	    core->prog_file = STRDUP(argv[0]);
	}

	/* Get the Host's Name */
	if(gethostname((char *)hostname, sizeof(hostname)))
	    *hostname = '\0';
	else
	    hostname[sizeof(hostname) - 1] = '\0';

	/* Open the User & Group IDs list files */
	core->uid = EDVUIDGetSystem(&core->total_uids);
	core->gid = EDVGIDGetSystem(&core->total_gids);

	/* Get the Effective User ID string */
	s = EDVUIDGetNameFromUID(
	    core->uid, core->total_uids,
	    core->effective_user_id, NULL
	);
	g_free(core->effective_user_id_str);
	core->effective_user_id_str = STRDUP(
	    !STRISEMPTY(s) ? s : "anonymous"
	);

	/* Get the Effective User ID & Hostname string */
	g_free(core->effective_user_id_host_str);
	core->effective_user_id_host_str = g_strdup_printf(
	    "%s@%s",
	    !STRISEMPTY(s) ? s : "anonymous",
	    !STRISEMPTY(hostname) ? hostname : "unknown"
	);

	/* Set the configuration to default values */
	core->cfg_list = cfg_list = EDVNewDefaultConfigurationList(
	    startup_path,
	    core->home_dir
	);

	/* Need to set an alternate configuration file path? */
	if(alternate_config_file != NULL)
	{
	    g_free(core->cfg_file);
	    core->cfg_file = STRDUP(alternate_config_file);
	}
	else
	{
	    /* Set the configuration file from the environment? */
	    const gchar *env_config_file = g_getenv(ENV_VAR_NAME_EDVCFGFILE);
	    if(env_config_file != NULL)
	    {
		g_free(core->cfg_file);
		core->cfg_file = STRDUP(env_config_file);
	    }
	    else
	    {
		/* Set the configuration file as the one in the local
		 * data directory
		 */
		g_free(core->cfg_file);
		core->cfg_file = STRDUP(PrefixPaths(
		    EDV_GET_S(EDV_CFG_PARM_DIR_LOCAL),
		    EDV_DEF_CONFIG_FILE
		));
	    }
	}
	/* Open the configuration from file, overwriting any existing
	 * configuration values in the existing configuration list
	 */
	cfg_file_load_status = CFGFileOpen(
	    core->cfg_file, cfg_list
	);

	/* Get the version of the configuration file */
	old_version_major = EDV_GET_I(EDV_CFG_PARM_VERSION_MAJOR);
	old_version_minor = EDV_GET_I(EDV_CFG_PARM_VERSION_MINOR);
	old_version_release = EDV_GET_I(EDV_CFG_PARM_VERSION_RELEASE);

	/* Is version from the configuration different than the
	 * compile time version?
	 */
	cfg_version_different = FALSE;
	if(old_version_major != PROG_VERSION_MAJOR)
	    cfg_version_different = TRUE;
	else if(old_version_minor != PROG_VERSION_MINOR)
	    cfg_version_different = TRUE;
	else if(old_version_release != PROG_VERSION_RELEASE)
	    cfg_version_different = TRUE;

	/* Now set the new version to the configuration since the
	 * version just fetched may be old
	 */
	EDV_SET_I(EDV_CFG_PARM_VERSION_MAJOR, PROG_VERSION_MAJOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_MINOR, PROG_VERSION_MINOR);
	EDV_SET_I(EDV_CFG_PARM_VERSION_RELEASE, PROG_VERSION_RELEASE);

#if 0
	/* Override the startup directory from command line? */
	if(startup_path != NULL)
	    EDV_SET_S(EDV_CFG_PARM_DIR_START_UP, startup_path);
#endif

	/* Get the startup window options */
	startup_browser = EDV_GET_B(EDV_CFG_PARM_STARTUP_BROWSER);
	startup_imbr = EDV_GET_B(EDV_CFG_PARM_STARTUP_IMBR);
	startup_archiver = EDV_GET_B(EDV_CFG_PARM_STARTUP_ARCHIVER);
	startup_recbin = EDV_GET_B(EDV_CFG_PARM_STARTUP_RECBIN);

	/* If the configuration file did not exist, then save it
	 *
	 * This is useful for creating the user's home directory for
	 * the first time
	 */
	if(cfg_file_load_status != 0)
	{
	    CFGFileSave(core->cfg_file, cfg_list);
	}

	/* Check if the InterPS lock link exists, the process is
	 * actually already running, and it is not this process
	 *
	 * Note that EDVInterPSGetLock() will only return non-zero if
	 * the process indicated by the lock link is actually running
	 */
	p = EDVInterPSGetLock(cfg_list);
	if((p != 0) && (p != core->pid))
	{
	    /* Issue a command to the already running process */
	    gchar *cmd, *cmd_list[2];

	    /* If no window name was specified at startup then use
	     * the one specified from the configuration
	     */
	    if(STRISEMPTY(window_name))
	    {
		if(startup_browser)
		    window_name = "file_browser";
		else if(startup_imbr)
		    window_name = "image_browser";
		else if(startup_archiver)
		    window_name = "archiver";
		else if(startup_recbin)
		    window_name = "recycle_bin";
		else
		    window_name = "file_browser";
	    }

	    /* Format the command to create a new window and then
	     * send that command to the already running process
	     */
	    cmd_list[0] = cmd = g_strdup_printf(
"new_window \"%s\" \"%s\" \"%s\"",
		window_name,
		(startup_full_path != NULL) ? startup_full_path : "",
		(arg_extra != NULL) ? arg_extra : ""
	    );
	    cmd_list[1] = NULL;
	    EDVInterPSSendCommandsList(cfg_list, p, cmd_list);
	    g_free(cmd);

	    EDVDelete(core, FALSE);
	    DO_FREE_LOCALS
	    return(NULL);
	}

	/* (Re)create InterPS lock link and remove any queued
	 * interprocess commands
	 */
	switch(EDVInterPSMakeLock(cfg_list, core->pid, TRUE))
	{
	  case 0:
	    break;
	  default:
	    if(cfg_list != NULL)
	    {
		const gchar *s = CFGItemListGetValueS(
		    cfg_list, EDV_CFG_PARM_DIR_LOCAL
		);
		gchar *lock_link = g_strdup_printf(
		    "%s%c%s",
		    (s != NULL) ? s : "/",
		    G_DIR_SEPARATOR,
		    EDV_INTERPS_LOCK_LINK
		);
		g_printerr(
"Unable to create the process ID lock \"%s\".\n",
		    lock_link
		);
		g_free(lock_link);
	    }
	    else
	    {
		g_printerr(
"Unable to create the process ID lock: The configuration list was not defined.\n"
		);
	    }
	    break;
	}
	EDVInterPSRemoveCommandsList(cfg_list);


	/* Get the full path to the recycle bin index file */
	recbin_index_file = EDV_GET_S(EDV_CFG_PARM_FILE_RECYCLE_BIN_INDEX);

	/* Get the number of recycled objects in the recycle bin */
	core->last_recbin_items = EDVRecBinIndexGetTotal(
	    recbin_index_file
	);

	/* Load the default font if specified */
	if(!STRISEMPTY(core->font_name))
	{
	    core->font = gdk_font_load(core->font_name);
	}

	/* Create the RC styles */
	EDVUpdateRCStyles(core);

	/* Update the global tooltips state */
	GUISetGlobalTipsState(EDV_GET_B(EDV_CFG_PARM_SHOW_TOOLTIPS));

	/* Create the standard cursors */
	EDVCreateStandardCursors(core);




	/* Open the devices from the system, then open devices from
	 * the local devices file
	 */
	EDVDevicesListLoadFromSystem(
	    &core->device, &core->total_devices,
	    NULL, core
	);
	EDVDevicesListFileOpen(
	    EDV_GET_S(EDV_CFG_PARM_FILE_DEVICES),
	    &core->device, &core->total_devices,
	    NULL, core
	);
	/* Get the device mount states & stats */
	EDVDevicesListUpdateMountStates(
	    core->device, core->total_devices
	);
	EDVDevicesListUpdateStats(
	    core->device, core->total_devices
	);


	/* Open the MIME Types from the system, then open MIME Types
	 * from the local and then global MIME Types files
	 */
	EDVMimeTypesListSystemFileOpen(
	    &core->mimetype, &core->total_mimetypes,
	    -1,			/* Append */
	    NULL, core,
	    NULL, core,
	    TRUE		/* Read only */
	);
	EDVMimeTypesListFileOpen(
	    EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES),
	    &core->mimetype, &core->total_mimetypes,
	    -1,			/* Append */
	    FALSE,		/* Do not update */
	    FALSE,		/* Not only newer */
	    NULL, core,
	    NULL, core,
	    NULL, core,
	    FALSE		/* Not read only */
	);
	EDVMimeTypesListFileOpen(
	    EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES_GLOBAL),
	    &core->mimetype, &core->total_mimetypes,
	    -1,			/* Append */
	    FALSE,		/* Do not update */
	    FALSE,		/* Not only newer */
	    NULL, core,
	    NULL, core,
	    NULL, core,
	    TRUE		/* Read only */
	);
	/* Update the MIME Types class list index hints */
	EDVUpdateMIMETypeHintIndices(core);


	/* Create the Users & Groups popup lists */
	EDVUpdateIDPULists(core);

	/* Create the Devices popup list */
	EDVUpdateDevicesPUList(core);

	/* Create the Open With popup list */
	EDVUpdateOpenWithPUList(core);


	/* If the configuration file version is different from the
	 * compile time version of this program, then, print warning at
	 * this point
	 */
	if(cfg_version_different)
	{
	    gchar *s = g_strdup_printf(
#if defined(PROG_LANGUAGE_SPANISH)
"%s ha cambiado de la versin %i.%i.%i a la versin %s.\n\
\n\
Los valores de la configuracin pueden haber cambiado desde que\n\
la versin previa, usted debe tomar un momento de revisar sus\n\
opciones y las personalizaciones yendo a Escenarios->Opciones...\n\
y Escenarios->Personaliza...\n"
#elif defined(PROG_LANGUAGE_FRENCH)
"%s a chang de %i.%i.%i de version  %s de version.\n\
\n\
Les valeurs de configuration ont pu changer puisque la version\n\
prcdente, vous devez prendre un moment pour rexaminer vos\n\
options et vos personnalisations en allant aux\n\
Montages->Options... et les Montages->Personnalise...\n"
#elif defined(PROG_LANGUAGE_GERMAN)
"%s hat von Version %i.%i.%i zu Version %s gendert.\n\
\n\
Die konfiguration werte knnen gendert haben, da die vorherige\n\
version, sie einen moment nehmen sollen, ihre optionen und\n\
anpassungen durch gehen zu Settings->Optionen... und\n\
Settings->Anpassungen...\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
"%s ha cambiato da %i.%i.%i di versione a %s di versione.\n\
\n\
I valori di configurazione possono avere cambiato poich la\n\
versione precedente, lei dovrebbe portare un momento a riesaminare\n\
le sue opzioni e le sue personalizzazioni da andare ai\n\
Montaggi->Opzioni... ed i Montaggi->Personalizza...\n"
#elif defined(PROG_LANGUAGE_DUTCH)
"%s heeft van uitvoering %i.%i.%i aan uitvoering %s veranderd.\n\
\n\
De configuratie waarde hebben misschien veranderd aangezien de\n\
vorige uitvoering, u een moment zou moeten nemen om opnieuw je\n\
opties en aanpassingen door gaan aan Settings->Opties... en\n\
Settings->Aanpassingen...\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"%s mudou de %i.%i.%i de verso a %s de verso.\n\
\n\
Os valores de configurao podem ter mudado desde que a verso\n\
prvia, voc devem tomar um momento revisar seuas opes e\n\
customizations por ir a Settings->Opes... e\n\
Settings->Customizations...\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"%s forandrer seg fra versjon %i.%i.%i til versjon %s.\n\
\n\
Konfigurasjonsverdiene forandret seg da den forrige versjonen,\n\
de tar et yeblikk overprve Deres alternativer og customizations\n\
ved  dra til Innstillinger->Alternativer... og\n\
Innstillinger->Customizations...\n"
#else
"%s has changed from version %i.%i.%i to version %s.\n\
\n\
The configuration values may have changed since the previous version,\n\
you should take a moment to review your options and customizations\n\
by going to Settings->Options... and Settings->Customize...\n"
#endif
		, PROG_NAME_FULL,
		old_version_major, old_version_minor, old_version_release,
		PROG_VERSION
	    );

	    EDVPlaySoundInfo(core);
	    CDialogSetTransientFor(NULL);
	    CDialogGetResponse(
#if defined(PROG_LANGUAGE_SPANISH)
"La Nota Del Cambio De La Versin"
#elif defined(PROG_LANGUAGE_FRENCH)
"La Notification De Changement De Version"
#elif defined(PROG_LANGUAGE_GERMAN)
"Version nderung Notiz"
#elif defined(PROG_LANGUAGE_ITALIAN)
"L'Avviso Di Cambiamento Di Versione"
#elif defined(PROG_LANGUAGE_DUTCH)
"Uitvoering Verandering Bericht"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
"O Aviso De Mudana De Verso"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
"VersjonsForandring Legger Merke Til"
#else
"Version Change Notice"
#endif

		, s, NULL,
		CDIALOG_ICON_INSTALL,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);
	    g_free(s);
	}


	/* Check the recycle bin size and warn the user as needed */
	EDVRecycleBinSizeCheck(core, NULL);


	/* Map the Recycle Bin Desktop Icon? */
	if(EDV_GET_B(EDV_CFG_PARM_RECBIN_SHOW_DESKTOP_ICON))
	    EDVMapRecBinDeskIcon(core);


	/* Create the initial window in accordance with the window
	 * type specified from the command line, if no window type was
	 * specified from the command line then refer to the window
	 * type specified by the configuration
	 */
	if(!STRISEMPTY(window_name))
	{
	    /* Create a window specified by the command line */
	    EDVNewWindow(
		core,
		window_name, startup_full_path, arg_extra,
		NULL
	    );
	}
	else
	{
	    /* No window name specified so startup with a window
	     * specified by the configuration
	     */
	    gboolean created_window = FALSE;

	    if(startup_browser)
	    {
		EDVNewBrowser(core, startup_full_path);
		created_window = TRUE;
	    }
	    if(startup_imbr)
	    {
		EDVNewImbr(core, startup_full_path);
		created_window = TRUE;
	    }
	    if(startup_archiver)
	    {
		EDVNewArchiver(core, startup_full_path, arg_extra);
		created_window = TRUE;
	    }
	    if(startup_recbin)
	    {
		EDVMapRecBin(core);
		created_window = TRUE;
	    }
	    /* If no window was specified to be created then create a
	     * File Browser
	     */
	    if(!created_window)
	    {
		EDVNewBrowser(core, startup_full_path);
		created_window = TRUE;
	    }
	}

#if !defined(DEBIAN)
	/* Display License/Copyright?
	 *
	 * Use the About dialog to display the copyright if the version
	 * has changed or there was an error loading the configuration
	 * file (suggesting the configuration file does not exist)
	 */
	if(cfg_version_different || cfg_file_load_status)
	    EDVAboutPage(
		core, "Copyright", NULL
	    );
#endif

	/* Set main management timeout function */
	core->manage_toid = gtk_timeout_add(
	    1000l, 		/* 1 second interval */
	    EDVManageTimeoutCB, core
	);

	DO_FREE_LOCALS
#undef DO_FREE_LOCALS

	return(core);
}

/*
 *	Deletes the Endeavour core.
 *
 *	The core specifies the Endeavour core.
 *
 *	If save_config is TRUE then the Devices list, MIME Types list,
 *	and the configuration list will be saved to file first.
 */
void EDVDelete(
	edv_core_struct *core,
	const gboolean save_config
)
{
	gint i;

	if(core == NULL)
	    return;

	/* Save the configuration? */
	if((core->cfg_list != NULL) && save_config)
	{
	    const cfg_item_struct *cfg_list = core->cfg_list;

	    /* Save MIME Types */
	    EDVMimeTypesListFileSave(
		EDV_GET_S(EDV_CFG_PARM_FILE_MIME_TYPES),
		core->mimetype, core->total_mimetypes,
		FALSE,		/* Do not save MIME Types marked read_only */
		NULL, core
	    );

	    /* Save Devices */
	    EDVDeviceListFileSave(
		EDV_GET_S(EDV_CFG_PARM_FILE_DEVICES),
		core->device, core->total_devices,
		NULL, core
	    );

	    /* Save configuration */
	    CFGFileSave(core->cfg_file, core->cfg_list);
	}


	/* Remove the InterPS lock link if it refers to this process */
	if(EDVInterPSGetLock(core->cfg_list) == core->pid)
	    EDVInterPSRemoveLock(core->cfg_list);


	/* Begin deleting */

	/* Remove the timeouts callbacks */
	GTK_TIMEOUT_REMOVE(core->check_devices_toid);
	core->check_devices_toid = 0;
	GTK_TIMEOUT_REMOVE(core->manage_toid);
	core->manage_toid = 0;

	/* Delete all the File Browsers */
	for(i = 0; i < core->total_browsers; i++)
	    EDVBrowserDelete(core->browser[i]);
	g_free(core->browser);
	core->browser = NULL;
	core->total_browsers = 0;

	/* Delete all the Image Browsers */
	for(i = 0; i < core->total_imbrs; i++)
	    EDVImbrDelete(core->imbr[i]);
	g_free(core->imbr);
	core->imbr = NULL;
	core->total_imbrs = 0;

	/* Delete all the Archivers */
	for(i = 0; i < core->total_archivers; i++)
	    EDVArchiverDelete(core->archiver[i]);
	g_free(core->archiver);
	core->archiver = NULL;
	core->total_archivers = 0;

	/* Delete the Recycle Bin */
	EDVRecBinDelete(core->recbin);
	core->recbin = NULL;

	/* Delete the Recycle Bin desktop icon */
	EDVRecBinDeskIconDelete(core->recbin_deskicon);
	core->recbin_deskicon = NULL;


	/* Delete the Find Window */
	EDVFindWinDelete(core->find_win);
	core->find_win = NULL;

	/* Delete all the Property Dialogs */
	for(i = 0; i < core->total_propdlgs; i++)
	    EDVPropDlgDelete(core->propdlg[i]);
	g_free(core->propdlg);
	core->propdlg = NULL;
	core->total_propdlgs = 0;

	/* Delete the History List Window */
	EDVHistoryWinDelete(core->history_listwin);
	core->history_listwin = NULL;

	/* Delete the Run Dialog */
	EDVRunDlgDelete(core->run_dlg);
	core->run_dlg = NULL;

	/* Delete the Devices List Window */
	EDVDevicesListWinDelete(core->device_listwin);
	core->device_listwin = NULL;

	/* Delete the MIME Types List Window */
	EDVMimeTypesListWinDelete(core->mimetype_listwin);
	core->mimetype_listwin = NULL;

	/* Delete the Options Window */
	EDVGenOptWinDelete(core->options_window);
	core->options_window = NULL;

	/* Delete the Customize Window */
	EDVGenOptWinDelete(core->customize_window);
	core->customize_window = NULL;

	/* Delete the About Dialog */
	AboutDlgDelete(core->about_dlg);
	core->about_dlg = NULL;


	/* Delete the Open With popup list */
	PUListDelete(core->open_with_pulist);
	core->open_with_pulist = NULL;

	/* Delete the MIME Types list */
	for(i = 0; i < core->total_mimetypes; i++)
	    EDVMimeTypeDelete(core->mimetype[i]);
	g_free(core->mimetype);
	core->mimetype = NULL;
	core->total_mimetypes = 0;


	/* Delete the Devices popup list */
	PUListDelete(core->devices_pulist);
	core->devices_pulist = NULL;

	/* Delete the Devices list */
	for(i = 0; i < core->total_devices; i++)
	    EDVDeviceDelete(core->device[i]);
	g_free(core->device);
	core->device = NULL;
	core->total_devices = 0;

	/* Delete all the Cursors */
	for(i = 0; i < core->total_cursors; i++)
	    EDVCursorDelete(core->cursor[i]);
	g_free(core->cursor);
	core->cursor = NULL;
	core->total_cursors = 0;


	/* Delete the configuration list */
	CFGItemListDeleteList(core->cfg_list);
	core->cfg_list = NULL;


	/* Delete the Users & Groups popup lists */
	PUListDelete(core->users_pulist);
	core->users_pulist = NULL;
	PUListDelete(core->groups_pulist);
	core->groups_pulist = NULL;

	/* Delete the User & Group IDs lists */
	for(i = 0; i < core->total_uids; i++)
	    EDVUIDDelete(core->uid[i]);
	g_free(core->uid);
	core->uid = NULL;
	core->total_uids = 0;

	for(i = 0; i < core->total_gids; i++)
	    EDVGIDDelete(core->gid[i]);
	g_free(core->gid);
	core->gid = NULL;
	core->total_gids = 0;


	/* Reset the DND Icon */
	GUIDNDSetDragIcon(NULL, NULL, 0, 0);


	/* Delete the user defined GtkRcStyles */
	GTK_RC_STYLE_UNREF(core->standard_rcstyle)
	core->standard_rcstyle = NULL;
	GTK_RC_STYLE_UNREF(core->lists_rcstyle)
	core->lists_rcstyle = NULL;


	/* Delete the Pixmaps List */
	core->pixmap_list = EDVPixmapListClean(core->pixmap_list);
	g_list_foreach(
	    core->pixmap_list, (GFunc)EDVPixmapDelete, NULL
	);
	g_list_free(core->pixmap_list);
	core->pixmap_list = NULL;


	core->pending_flags = 0;

	core->interps_signal_count = 0;


	/* Delete other memory on the core */
	core->geometry_set = FALSE;
	memset(&core->geometry, 0x00, sizeof(GdkRectangle));

	g_free(core->font_name);
	core->font_name = NULL;

	GDK_FONT_UNREF(core->font);
	core->font = NULL;

	g_free(core->fg_color_name);
	core->fg_color_name = NULL;
	g_free(core->bg_color_name);
	core->bg_color_name = NULL;

	g_free(core->sfg_color_name);
	core->sfg_color_name = NULL;
	g_free(core->sbg_color_name);
	core->sbg_color_name = NULL;

	g_free(core->cfg_color_name);
	core->cfg_color_name = NULL;
	g_free(core->cbg_color_name);
	core->cbg_color_name = NULL;

	g_free(core->bg_pixmap_path);
	core->bg_pixmap_path = NULL;
	g_free(core->sbg_pixmap_path);
	core->sbg_pixmap_path = NULL;

	g_free(core->wm_name);
	core->wm_name = NULL;
	g_free(core->wm_class);
	core->wm_class = NULL;
	g_free(core->title);
	core->title = NULL;


	g_free(core->cfg_file);
	core->cfg_file = NULL;

	g_free(core->prog_file);
	core->prog_file = NULL;

	g_free(core->home_dir);
	core->home_dir = NULL;

	g_free(core->effective_user_id_str);
	core->effective_user_id_str = NULL;
	g_free(core->effective_user_id_host_str);
	core->effective_user_id_host_str = NULL;

	g_free(core);
}
