#ifndef EDV_ARCHIVE_STAT_H
#define EDV_ARCHIVE_STAT_H

#include <glib.h>
#include "edv_types.h"
#include "edv_archive_obj.h"


extern const gchar *EDVArchStatGetError(void);

extern edv_archive_object_struct *EDVArchStat(
	edv_core_struct *core,
	const gchar *arch_obj,
	const gchar *path,
	const gchar *password
);
extern GList *EDVArchStatList(
	edv_core_struct *core,
	const gchar *arch_obj,
	GList *paths_list,
	const gchar *filter,
	const gchar *password,
	gint (*progress_cb)(
		const gchar *,
		edv_archive_object_struct *,
		const gulong, const gulong,
		gpointer
	),
	gpointer progress_data
);


#endif	/* EDV_ARCHIVE_STAT_H */
