#!/usr/bin/python

# Input

name = "triangle"
angle = 30
width = 31

# Globals

color_chars  = " #ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!$%&/()=+?,;:_,.-*^~"
color_values = [0,0xFF]
pixel_lines = []

# Functions

import math
tan = math.tan

def rad(d):
	return d * 0.0174532925199

# remember sin(rad(60)) = 0.866025403783

def getChar(v):
	global color_chars, color_values
	if color_values.count(v) == 0:
		color_values.append(v)
	
	return color_chars[color_values.index(v)]


# Compute

incline = tan(rad(angle))

half_width = (width + 1) / 2
width = half_width * 2 - 1
i = half_width - incline
y = 1

while (i > 0):
	inti = int(i)
	
	line = ""
	for x in range(0, half_width):
		if (x < inti):
			v = 0;
		elif (x == inti):
			v = (1.0 - (i - inti)) * 255
		else:
			v = 255
		
		c = getChar(v)
		line = line + c
	
	for x in range(half_width, width):
		line = line + line[width - x - 1]
	
	pixel_lines.append(line)
	y = y + 1
	i = half_width - y * incline


# Print

print "const static gchar %s_xpm[] = {" % name
print "\"%d %d %d 1\"," % (width, len(pixel_lines), len(color_values))
for i in range(1, len(color_values)):
	c = color_chars[i]
	v = color_values[i]
	print "\"%c c #%02x%02x%02x\"," % (c, v,v,v)
print "\"  c None\","

for i in range(0, len(pixel_lines)):
	print "\"%s\"," % pixel_lines[i]

print "};"
